//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndScopedPtr.h
 * @brief		XR[v|C^NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndScopedPtr_H_
#define INCG_IRIS_FndScopedPtr_H_

//======================================================================
// include
#include "FndLiberator.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	XR[v|C^NX
 * @tparam	_TN	= Ώی^
*/
template<typename _TN, class _Liberator=CLiberatorObject<_TN>>
class CScopedPtr : public _Liberator
{
	typedef CScopedPtr<_TN, _Liberator>	_Myt;
public:
	typedef _Liberator	Liberator;
	typedef _TN			value_type;
	typedef _TN			*value_ptr;
	typedef _TN			&value_ref;
private:
	const value_type	m_pPtr;	//!< |C^
public:
	/// RXgN^
	CScopedPtr(void) : Liberator(nullptr) {}
	/// RXgN^
	explicit CScopedPtr(value_type ptr) : Liberator(ptr) {}
	/// fXgN^
	~CScopedPtr(void) { reset(nullptr); }

public:
	//! rebind
	template<typename _TN2> struct rebind { typedef CScopedPtr<_TN2> other; };

public:
	/// AhXQ
	value_ref	operator * (void) const		{ return *m_pPtr; }
	/// A[Zq
	value_type	operator -> (void) const	{ return m_pPtr; }
	/// |C^̎擾
	value_type	ptr(void)					{ return m_pPtr; }
	/// |C^̎擾
	value_type	get(void)					{ return m_pPtr; }

public:
	/// |C^̍Đݒ
	void		reset(value_type ptr)
	{
		if( ptr == m_pPtr ) return;
		_Liberator::liberate();
		m_pPtr = ptr;
	}
	/// swap
	void		swap(_Myt& b)
	{
		value_ptr p = b.m_pPtr;
		b.m_pPtr = m_pPtr;
		m_pPtr = p;
	}

public:
	/// ^ϊ
	template<typename Other>
	operator CScopedPtr<Other> (void) { return CScopedPtr<Other>(*this); }

private:
	/// ֘At̉
	value_type	release(void)
	{
		value_type p = m_pPtr;
		m_pPtr = nullptr;
		return p;
	}
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
