//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndSealed.h
 * @brief		pNX̃CX^X̋֎~NX
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndSealed_H_
#define INCG_IRIS_FndSealed_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace fnd
{

//================================================================================
// declare
template <class T>class CSealed;

//================================================================================
// class
//! V[hNXx[X
template<typename _TN>
class CSealedBase : public IIrisObject
{
	template <typename X> class identity { typedef X type; };
#if		defined(__GNUC__) || defined(__MWERKS__)
	friend class identity<_TN>::type;
#else
	friend identity<_TN>::type;
	//friend typename identity<_TN>::type;
#endif
	friend class CSealed<_TN>;
	CSealedBase(void)				{}
	CSealedBase(const CSealedBase&)	{}
};

//! V[hNX
template <class _TC>
class CSealed : public virtual CSealedBase<_TC>
{
};

}	// end of namespace fnd
}	// end of namespace iris

/******************************************************
// how to use
void main( void )
{
	struct p : public sealed<p>{};
	struct q : public p{};

	p a;
//	q b;// error
	q* b = (q*)new p;// ok
}
********************************************************/

#endif	// #ifndef _FndSealed_H_
