//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndSort.h
 * @brief		\[g֐Qt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndSort_H_
#define INCG_IRIS_FndSort_H_

//======================================================================
// include
#include "FndOperator.h"
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// declare
/// I\[g
template<typename _TN, typename _Func>
void	SelectionSort(s32 num, _TN* elem, const _Func& func);
/// ou\[g
template<typename _TN, typename _Func>
void	BubbleSort(s32 num, _TN* elem, const _Func& func);
/// }\[g
template<typename _TN, typename _Func>
void	InsertSort(s32 num, _TN* elem, const _Func& func);
/// }[W\[g
template<typename _TN, typename _Func>
void	MergeSort(s32 num, _TN* elem, const _Func& func);
/// NCbN\[g
template<typename _TN, typename _Func>
void	QuickSort(s32 num, _TN* elem, const _Func& func);

//======================================================================
// struct
#ifdef _IRIS_DEBUGTEST_ENABLE
// fobOeXgp\
typedef struct tagSORT_DEBUGTEST_REG
{
	s32 sw;	// swap
	tagSORT_DEBUGTEST_REG(void) : sw(0) {}
	void	dump(const char* pName, s32 fn)
	{
		printf("%s : func %d, swap %d(%d).\n", pName, fn, sw/3, sw);
	}
} SORT_DEBUGTEST_REG;
#endif

//======================================================================
// define
#ifdef _IRIS_DEBUGTEST_ENABLE
#define SDTR_VAL()		SORT_DEBUGTEST_REG sdtr
#define SDTR_DUMP(txt)	sdtr.dump(txt, func.count())
#define SDTR_SW(n)		sdtr.sw += (n)

#else
#define SDTR_VAL()		(void)0
#define SDTR_DUMP(txt)	(void)0
#define SDTR_SW(n)		(void)0

#endif

//======================================================================
// function
/**
 * @brief I\[g
 * @param [in]	num		= \[gz̗vf
 * @param [io]	elem	= \[gΏ۔z
 * @param [in]	func	= r֐
*/
template<typename _TC, typename _TN, typename _Func>
void	SelectionSort(s32 num, _TC& elem, const _Func& func)
{
	SelectionSort<_TC, _TN>(num, elem, 0, num, func);
}
template<typename _TC, typename _TN, typename _Func>
void	SelectionSort(s32 num, _TC& elem, s32 begin, s32 end, const _Func& func)
{
	IRIS_UNUSED_VARIABLE(num);
	SDTR_VAL();
	for( s32 i=begin; i < end-1; ++i )
	{
		s32 curr = i;
		for( s32 j=i+1; j < end; ++j )
		{
			if( func(elem[j], elem[curr]) )
			{
				curr = j;
			}
		}
		swap(elem[i], elem[curr]);
		SDTR_SW(3);
	}
	SDTR_DUMP("SelectionSort");
}

/**
 * @brief ou\[g
 * @param [in]	num		= \[gz̗vf
 * @param [io]	elem	= \[gΏ۔z
 * @param [in]	func	= r֐
*/
template<typename _TC, typename _TN, typename _Func>
void	BubbleSort(s32 num, _TC& elem, const _Func& func)
{
	BubbleSort<_TC, _TN>(num, elem, 0, num, func);
}
template<typename _TC, typename _TN, typename _Func>
void	BubbleSort(s32 num, _TC& elem, s32 begin, s32 end, const _Func& func)
{
	IRIS_UNUSED_VARIABLE(num);
	SDTR_VAL();
	for( s32 i=begin, n=end-1; i < n; ++i )
	{
		for( s32 j=begin; j < n-i; ++j )
		{
			if( !func(elem[j], elem[j+1]) )
			{
				swap(elem[j], elem[j+1]);
				SDTR_SW(3);
			}
		}
	}
	SDTR_DUMP("BubbleSort");
}

/**
 * @brief }\[g
 * @param [in]	num		= \[gz̗vf
 * @param [io]	elem	= \[gΏ۔z
 * @param [in]	func	= r֐(<= or >= Ȃ\[gA< or > ̓Xebv邵s)
*/
template<typename _TC, typename _TN, typename _Func>
void	InsertSort(s32 num, _TC& elem, const _Func& func)
{
	InsertSort<_TC, _TN>(num, elem, 0, num, func);
}
template<typename _TC, typename _TN, typename _Func>
void	InsertSort(s32 num, _TC& elem, s32 begin, s32 end, const _Func& func)
{
	IRIS_UNUSED_VARIABLE(num);
	SDTR_VAL();
	for( s32 i=begin+1, j; i < end; ++i )
	{
		_TN tmp = elem[i];
		for( j=i; j > begin && !func(elem[j-1], tmp); --j )
		{
			elem[j] = elem[j-1];
		}
		elem[j]		= tmp;
		SDTR_SW(i-j+1);
	}
	SDTR_DUMP("InsertSort");
}

/**
 * @brief }[W\[g
 * @param [in]	num		= \[gz̗vf
 * @param [io]	elem	= \[gΏ۔z
 * @param [in]	func	= r֐
*/
template<typename _TC, typename _TN, typename _Func>
void	MergeSort(s32 num, _TC& elem, const _Func& func)
{
#ifndef _IRIS_DEBUGTEST_ENABLE
	MergeSort<_TC, _TN>(num, elem, 0, num, func);
#else
	SDTR_VAL();
	MergeSort<_TC, _TN>(num, elem, 0, num, func, sdtr);
	SDTR_DUMP("MergeSort");
#endif
}

/**
 * @brief }[W\[g
 * @param [in]	num		= \[gz̗vf
 * @param [io]	elem	= \[gΏ۔z
 * @param [in]	begin	= 擪index
 * @param [in]	end		= I[index
 * @param [in]	func	= r֐
*/
template<typename _TC, typename _TN, typename _Func>
void	MergeSort(s32 num, _TC& elem, s32 begin, s32 end, const _Func& func
#ifdef _IRIS_DEBUGTEST_ENABLE
				  , SORT_DEBUGTEST_REG& sdtr
#endif
				  )
{
	if( num <= 1 ) return;
	s32 half	= num>>1;
	s32 center	= begin + half;
	num = num - half;

	// \[g
#ifndef _IRIS_DEBUGTEST_ENABLE
	MergeSort<_TC, _TN>(half, elem, begin , center, func);
	MergeSort<_TC, _TN>(num , elem, center, end   , func);
#else
	MergeSort<_TC, _TN>(half, elem, begin , center, func, sdtr);
	MergeSort<_TC, _TN>(num , elem, center, end   , func, sdtr);
#endif

	// }[W
	_TN tmp;
	s32 i;
	while( num > 0 && half > 0 )
	{
		if( func(elem[begin], elem[center]) )
		{
			++begin;
			--half;
		}
		else
		{
			tmp = elem[center];
			for( i=begin; i < center; ++i ) elem[i+1] = elem[i];
			elem[begin] = tmp;
			++center;
			++begin;
			--num;
			SDTR_SW(center + 2 - begin);
		}
	}
}

/**
 * @brief NCbN\[g
 * @param [in]	num		= \[gz̗vf
 * @param [io]	elem	= \[gΏ۔z
 * @param [in]	begin	= 擪index
 * @param [in]	end		= I[index
 * @param [in]	func	= r֐
*/
template<typename _TC, typename _TN, typename _Func>
void	QuickSort(s32 num, _TC& elem, const _Func& func)
{
#ifndef _IRIS_DEBUGTEST_ENABLE
	QuickSort<_TC, _TN>(num, elem, 0, num, func);
#else
	SDTR_VAL();
	QuickSort<_TC, _TN>(num, elem, 0, num, func, sdtr);
	SDTR_DUMP("QuickSort");
#endif
}

/**
 * @brief NCbN\[g
 * @param [in]	num		= \[gz̗vf
 * @param [io]	elem	= \[gΏ۔z
 * @param [in]	func	= r֐
*/
template<typename _TC, typename _TN, typename _Func>
void	QuickSort(s32 num, _TC& elem, s32 begin, s32 end, const _Func& func
#ifdef _IRIS_DEBUGTEST_ENABLE
				  , SORT_DEBUGTEST_REG& sdtr
#endif
				  )
{
	typename _Func::append<CEqualOp>::other	func2;
#ifndef _IRIS_DEBUGTEST_ENABLE
	QuickSort<_TC, _TN>(num, elem, begin, end, func, func2);
#else
	QuickSort<_TC, _TN>(num, elem, begin, end, func, func2, sdtr);
#endif
}

/**
 * @brief NCbN\[g
 * @param [in]	num		= \[gz̗vf
 * @param [io]	elem	= \[gΏ۔z
 * @param [in]	func	= r֐
*/
template<typename _TC, typename _TN, typename _Func1, typename _Func2>
void	QuickSort(s32 num, _TC& elem, s32 begin, s32 end, const _Func1& func1, const _Func2& func2
#ifdef _IRIS_DEBUGTEST_ENABLE
				  , SORT_DEBUGTEST_REG& sdtr
#endif
				  )
{
#if 0
	if( num <= 1 ) return;
#else
	// ȂƂ́A}\[g
	if( num < 8 )
	{
		for( s32 i=begin+1, j; i < end; ++i )
		{
			_TN tmp = elem[i];
			for( j=i; j > begin && !func2(elem[j-1], tmp); --j )
			{
				elem[j] = elem[j-1];
			}
			elem[j]	= tmp;
			SDTR_SW(i-j+1);
		}
		return;
	}
#endif
	int l=begin, r=end-1;
	{
#if 0
		_TN pbt = elem[begin+(num>>1)];	// ^񒆂ɂls{bgɂ
#else
		// 3TvO̒l
		_TN a =  elem[begin+(num>>2)];
		_TN b =  elem[begin+(num>>1)];
		_TN c =  elem[begin+((num*3)>>2)];
		_TN pbt = a > b ? (a < c ? a : c) : (b < c ? b : c);
#endif
		while(1)
		{
			for( ; l < end; ++l )
				if( !func1(elem[l], pbt) ) break;
			for( ; r > begin; --r )
				if(  func2(elem[r], pbt) ) break;
			if( l >= r ) break;

			swap(elem[l++], elem[r--]);
			SDTR_SW(3);
		}
	}
	s32 half = l - begin;
	num -= half;
#ifndef _IRIS_DEBUGTEST_ENABLE
	QuickSort<_TC, _TN>(half, elem, begin,   l, func1, func2);
	QuickSort<_TC, _TN>(num , elem,     l, end, func1, func2);
#else
	QuickSort<_TC, _TN>(half, elem, begin,   l, func1, func2, sdtr);
	QuickSort<_TC, _TN>(num , elem,     l, end, func1, func2, sdtr);
#endif
}

// wrap
// SelectionSort
template<typename _TN, typename _Func>
void	SelectionSort(s32 num, _TN* elem, const _Func& func)
{
	SelectionSort<_TN*, _TN>(num, elem, func);
}
template<typename _TN, typename _Func>
void	SelectionSort(s32 num, _TN* elem, s32 begin, s32 end, const _Func& func)
{
	SelectionSort<_TN*, _TN>(num, elem, begin, end, func);
}

// BubbleSort
template<typename _TN, typename _Func>
void	BubbleSort(s32 num, _TN* elem, const _Func& func)
{
	BubbleSort<_TN*, _TN>(num, elem, func);
}
template<typename _TN, typename _Func>
void	BubbleSort(s32 num, _TN* elem, s32 begin, s32 end, const _Func& func)
{
	BubbleSort<_TN*, _TN>(num, elem, begin, end, func);
}

// InsertSort
template<typename _TN, typename _Func>
void	InsertSort(s32 num, _TN* elem, const _Func& func)
{
	InsertSort<_TN*, _TN>(num, elem, func);
}
template<typename _TN, typename _Func>
void	InsertSort(s32 num, _TN* elem, s32 begin, s32 end, const _Func& func)
{
	InsertSort<_TN*, _TN>(num, elem, begin, end, func);
}

// MergeSort
template<typename _TN, typename _Func>
void	MergeSort(s32 num, _TN* elem, const _Func& func)
{
	MergeSort<_TN*, _TN>(num, elem, func);
}
template<typename _TN, typename _Func>
void	MergeSort(s32 num, _TN* elem, s32 begin, s32 end, const _Func& func)
{
#ifndef _IRIS_DEBUGTEST_ENABLE
	MergeSort<_TN*, _TN>(num, elem, begin, end, func);
#else
	SDTR_VAL();
	MergeSort<_TN*, _TN>(num, elem, begin, end, func, stdr);
	SDTR_DUMP("MergeSort");
#endif
}

// QuickSort
template<typename _TN, typename _Func>
void	QuickSort(s32 num, _TN* elem, const _Func& func)
{
	QuickSort<_TN*, _TN>(num, elem, func);
}
template<typename _TN, typename _Func>
void	QuickSort(s32 num, _TN* elem, s32 begin, s32 end, const _Func& func)
{
#ifndef _IRIS_DEBUGTEST_ENABLE
	QuickSort<_TN*, _TN>(num, elem, begin, end, func);
#else
	SDTR_VAL();
	QuickSort<_TN*, _TN>(num, elem, begin, end, func, stdr);
	SDTR_DUMP("MergeSort");
#endif
}

}	// end of namespace fnd
}	// end of namespace iris

// undef
#undef SDTR_VAL
#undef SDTR_DUMP
#undef SDTR_SW

#endif
