//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndStaticPtr.h
 * @brief		ÓI|C^ϐNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndStaticPtr_H_
#define INCG_IRIS_FndStaticPtr_H_

//======================================================================
// include
#include "FndAutoPtr.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	ÓI|C^ϐNX
 * @tparam	_TN			= Ώی^
 * @tparam	_Liberator	= 폜IuWFNg
 * @deprecated	A^(_TN)ɑ΂ėB̃CX^XɂȂĂ邽߁AsSłB
 *				Ӑ}Ȃʂ܂̂ŁAgpTĂB
 *				Ⴆ΁ACStaticPtr<int>  a, b; ƂƂɁAa, b ̒l͓ƗLĂ܂܂B
*/
template< typename _TN, class _Liberator=CLiberator >
class CStaticPtr : public IIrisObject
{
	typedef CStaticPtr<_TN, _Liberator>	_Myt;
private:
	typedef _TN		value_type;
	typedef _TN*	value_ptr;
	typedef _TN&	value_ref;

public:
	typedef CAutoPtr<_TN, _Liberator>	_AutoPtr;

public:
	/**
	 * @brief	RXgN^
	*/
	CStaticPtr(void)		{}
	explicit CStaticPtr(value_ptr v) { ptr() = v; }

	/**
	 * @brief	fXgN^
	*/
	~CStaticPtr(void)
	{
		ptr() = nullptr;
	}

public:
	// operator
	/**
	 * 
	*/
	_Myt&	operator	= (value_ptr v)	{ ptr() = v; return *this; }

	/**
	 * LXg
	*/
	operator		value_ptr	(void)			{ return ptr(); }
	operator const	value_ptr	(void)	const	{ return ptr(); }

	/**
	 * @brief	ANZT
	*/
			value_ptr	operator	->	(void)			{ return ptr(); }
	const	value_ptr	operator	->	(void)	const	{ return ptr(); }

	/**
	 * @brief	r
	*/
	s32		operator	== (value_ptr v)	{ return ptr() == v; }

private:
	static	_AutoPtr&	ptr(void)
	{
		static _AutoPtr	s_ptr;
		return s_ptr;
	}
};


}	// end of namespace wx
}	// end of namespace iris

#endif
