//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndSHA256.h
 * @brief		SHA256 NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndSHA256_H_
#define INCG_IRIS_FndSHA256_H_

//======================================================================
// include
#include "FndHash.h"
#include "../../math/hash/MathSHA256.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/// SHA256 nbVNX
class CSHA256 : public IHash
{
public:
	enum
	{
		HASHSIZE	= SHA256_HASHSIZE
	};
protected:
	math::SHA256CONTEXT		m_Context;

public:
	// RXgN^
	CSHA256(void);
	// fXgN^
	virtual ~CSHA256(void);
public:

	// 
	virtual void	Init(void);
	// NA
	virtual void	Clear(void);
	// XV
	virtual void	Update(const u8* lpBuffer, size_t uLength);
	// ŏIXV
	virtual void	Final(void);
	// nbV̏o
	virtual void	Output(u8* lpBuffer)	const;
	/// o
	virtual void	ToStringA(LPSTR  lpString, size_t uSize, u8* lpBuffer)	const;
	virtual void	ToStringW(LPWSTR lpString, size_t uSize, u8* lpBuffer)	const;
	/// o
	virtual void	ToStringA(LPSTR  lpString, size_t uSize)	const;
	virtual void	ToStringW(LPWSTR lpString, size_t uSize)	const;
	// nbVTCY̎擾
	virtual u32		GetHashSize(void)	const	{ return HASHSIZE; }

};

}	// end of namespace fnd
}	// end of namespace iris

#endif
