//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndImage.h
 * @brief		摜NXC^[tFCXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndImage_H_
#define INCG_IRIS_FndImage_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/// 摜NXC^[tFCX
class IImage : public IIrisObject
{
public:
	/// imageo̓sNZtH[}bg
	typedef enum
	{
		PF_RGBA8	= 0,	//!< RGBA8888
		PF_RGB8,			//!< RGB888
		PF_RGBA4,			//!< RGBA4444
		PF_RGBA5551,		//!< RGBA5551
		PF_RGB565,			//!< RGB565
		PF_L8,				//!< LUMINANCE 8
		PF_LA8,				//!< LUMINANCE ALPHA 8
		PF_NUM,
		PF_INVALID	= 0xFF
	} PIXEL_FORMAT;
public:
	/// RXgN^
	IImage(void)	{}
	/// fXgN^
	virtual ~IImage(void) {}

public:
	/// LȃC[Wǂ
	virtual bool	IsValid(void)	const = 0;
	/// ̎擾
	virtual s32		GetWidth(void)	const = 0;
	/// ̎擾
	virtual s32		GetHeight(void)	const = 0;

public:
	// Rs[
	virtual bool		Duplicate(IImage& /*rImage*/) { return false; }
	
public:
	/// sNZJ[̎擾
	virtual bool		GetPixelRGBA8888(s32 x, s32 y, IrisRGBA8888& rgba) const = 0;
	/// sNZJ[̐ݒ
	virtual bool		SetPixelRGBA8888(s32 x, s32 y, const IrisRGBA8888& rgba) = 0;

public:
	// obt@ɓWJ
	virtual	bool		CreateImage(void* /*pBuffer*/, int /*nPixelFormat*/) const	{ return false; }

};

}	// end of namespace wx
}	// end of namespace iris

#endif
