//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndMemFunc.h
 * @brief		֐t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndMemFunc_H_
#define INCG_IRIS_FndMemFunc_H_

//======================================================================
// include
#include "../../iris_inchead.h"
#include "../../iris_debug.h"
#include <string.h>

EXTERN_C_BEGIN

//======================================================================
// function
void* irisCpuCopy8 (void* pDst, const void* pSrc, IrisU32 nSize);
void* irisCpuCopy16(void* pDst, const void* pSrc, IrisU32 nSize);
void* irisCpuCopy32(void* pDst, const void* pSrc, IrisU32 nSize);
void* irisCpuCopy32Fast(void* pDst, const void* pSrc, IrisU32 nSize);
void* irisCpuCopy64(void* pDst, const void* pSrc, IrisU32 nSize);
void* irisCpuCopyAlign(void* pDst, const void* pSrc, IrisU32 nSize, IrisU32 nAlign);

void* irisCpuClear8 (void* pDst, IrisS32 nValue, IrisU32 nSize);
void* irisCpuClear16(void* pDst, IrisS32 nValue, IrisU32 nSize);
void* irisCpuClear32(void* pDst, IrisS32 nValue, IrisU32 nSize);

EXTERN_C_END

#endif
