//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndRandom.h
 * @brief		ǗNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndRandom_H_
#define INCG_IRIS_FndRandom_H_

//======================================================================
// include
#include "../container/FndSingleton.h"

//======================================================================
// define
//#define _IRIS_GENRAND_LCG
//#define _IRIS_GENRAND_XOR128
//#define _IRIS_GENRAND_MT19937
//#define _IRIS_GENRAND_SFMT607
//#define _IRIS_GENRAND_SFMT1279
//#define _IRIS_GENRAND_SFMT19937
//#define _IRIS_GENRAND_BBSHUB

//======================================================================
// include
#if		defined(_IRIS_GENRAND_LCG)
#include "../../math/random/RndLCG.h"

#elif	defined(_IRIS_GENRAND_XOR128)
#include "../../math/random/RndXOR.h"

#elif	defined(_IRIS_GENRAND_MT19937)
#include "../../math/random/RndMT19937ar.h"

#elif	defined(_IRIS_GENRAND_SFMT607)
#include "../../math/random/RndSFMT607.h"

#elif	defined(_IRIS_GENRAND_SFMT1279)
#include "../../math/random/RndSFMT1279.h"

#elif	defined(_IRIS_GENRAND_SFMT19937)
#include "../../math/random/RndSFMT19937.h"

#elif	defined(_IRIS_GENRAND_BBSHUB)
#include "../../math/random/RndBBShub.h"

#else
#include "../../math/random/RndMT19937ar.h"

#endif

namespace iris {
namespace fnd
{

//======================================================================
// class
/// NX
class CRandom : public iris::math::rnd::IRand, public CSingleton<CRandom>
{
	static CRandom s_Random;
public:
#if		defined(_IRIS_GENRAND_LCG)
	typedef ::iris::math::rnd::CLCGRand		Random;
#elif	defined(_IRIS_GENRAND_XOR128)
	typedef ::iris::math::rnd::CXorShift	Random;
#elif	defined(_IRIS_GENRAND_MT19937)
	typedef ::iris::math::rnd::CMT19937ar	Random;
#elif	defined(_IRIS_GENRAND_SFMT607)
	typedef ::iris::math::rnd::CSFMT<607>	Random;
#elif	defined(_IRIS_GENRAND_SFMT1279)
	typedef ::iris::math::rnd::CSFMT<1279>	Random;
#elif	defined(_IRIS_GENRAND_SFMT19937)
	typedef ::iris::math::rnd::CSFMT19937>	Random;
#elif	defined(_IRIS_GENRAND_BBSHUB)
	typedef ::iris::math::rnd::CBBShubRand	Random;
#else
	typedef ::iris::math::rnd::CMT19937ar	Random;
#endif

private:
	Random	m_Random;
public:
	// ̐ݒ
	virtual void	SetSeed(u32 seed)
	{
		m_Random.SetSeed(seed);
	}
	virtual void	SetArraySeed(u32* seed, s32 size)
	{
		m_Random.SetArraySeed(seed, size);
	}

public:
	// 32bit ̐
	virtual u32		GenRand32(void)	{ return m_Random.GenRand32(); }
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
