//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndLayer.h
 * @brief		C[NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndLayer_H_
#define INCG_IRIS_FndLayer_H_

//======================================================================
// include
#include "../container/FndList.h"
#include "../types/FndCollector.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/// C[NX
class CDrawLayer : public CListNodeBase
{
	s32				m_ID;	//!< C[ID
protected:
	CDrawCollector	m_List;	//!< Xg
public:
	// RXgN^
	CDrawLayer(s32 id);
	// fXgN^
	virtual ~CDrawLayer(void);

public:
	// \[gp̔r֐
	bool	operator	== (const CDrawLayer& layer) const	{ return m_ID == layer.m_ID; }
	bool	operator	<  (const CDrawLayer& layer) const	{ return m_ID <  layer.m_ID; }

public:
	virtual void	PushBack(CDrawNode* drawer);
	virtual void	Insert(CDrawCollector::iterator pos, CDrawNode* drawer);
	virtual void	Erase(CDrawNode* drawer);
	virtual void	PreDraw(void)	{}
	virtual void	Draw(void);
	virtual void	PostDraw(void)	{}
};

/// \[gC[NX
class CSortDrawLayer : public CDrawLayer
{
public:
	// RXgN^
	CSortDrawLayer(s32 id);
	// fXgN^
	virtual ~CSortDrawLayer(void);
public:
	virtual void	Draw(void);
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
