//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndFps.h
 * @brief		FPSNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndFps_H_
#define INCG_IRIS_FndFps_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
//! FPSNX
class CFps : public IIrisObject
{
private:
	static CFps		s_Fps;
public:
	static const xf32	BASE_FPS;	//!< default fps
private:
	// fps
	u32		m_dwMspf;
	xf32	m_fps;
	xf32	m_spf;

private:
	// RXgN^
	CFps(void);
	// fXgN^
	//~CFps(void);

public:
	// GetInstance
	static	CFps&	GetInstance(void)	{ return s_Fps; }
public:
	// fps
	void	SetFPS(xf32 fps);
	xf32	GetFPS(void)		const	{ return m_fps; }
	xf32	GetSPF(void)		const	{ return m_spf; }
	u32		GetMSPF(void)		const	{ return m_dwMspf; }
	xf32	GetFPSRate(void)	const	{ return XF32_Div(BASE_FPS, m_fps); }
};

//======================================================================
// function
/// FPS̎擾
STATICINLINE	xf32	FPS(void)		{ return CFps::GetInstance().GetFPS(); }
/// SPF̎擾
STATICINLINE	xf32	SPF(void)		{ return CFps::GetInstance().GetSPF(); }
/// MSPF̎擾
STATICINLINE	u32		MSPF(void)		{ return CFps::GetInstance().GetMSPF(); }
/// BASE_FPSƌ݂FPS̔䗦擾(base/now)
STATICINLINE	xf32	FPSRate(void)	{ return CFps::GetInstance().GetFPSRate(); }

}	// end of namespace fnd
}	// end of namespace iris

#endif
