//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndTimer.h
 * @brief		TimerC^[tFCXNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndTimer_H_
#define INCG_IRIS_FndTimer_H_

//======================================================================
// include
#include "../../iris_object.h"
#include "../utility/FndFlag.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
//! TimerC^[tFCXNX
class ITimer : public IIrisObject
{
protected:
	typedef enum
	{
		TFO_ACTIVE	= 0,	//!< vǂ
		TFO_TERM
	} ITIMER_FLAG_OFS;
protected:
			CFlag	m_Flags;		//!< tO
	mutable	u64		m_LastTime;		//!< O̎
			u64		m_BaseTime;		//!< AvP[V̋N
			u64		m_StopTime;		//!< ~
			f32		m_fTosec;		//!< ~bbPʂɕϊϐ
public:
	/// RXgN^
	ITimer(void);
	// fXgN^
	//~ITimer(void);

protected:
	// ݂̃^C}[JEg擾
	virtual u64		GetNowTime(void)	const = 0;

public:
	// EZbg
	virtual	void	Reset(void);
	// v̊Jn
	virtual	void	Resume(void);
	// v̒~
	virtual	void	Suspend(void);

	/// Sync
	virtual	bool	Sync(bool sleep)			= 0;
	/// SyncƂ̍XVԂ̎擾
	virtual	xf32	GetSyncElapsedSecond(void)	const	= 0;

public:
	/// o߃~b̎擾
	virtual	u64		GetElapsedMilliSecond(void)	const	= 0;
	// oߕb̎擾
	virtual f32		GetElapsedSecond(void)		const;
	/// ^C}[ZbgƂ̌o߃~b
	virtual u64		GetStockMilliSecond(void)	const	= 0;
	// ^C}[ZbgƂ̌oߕb
	virtual f32		GetStockSecond(void)		const;

public:
	/// o߃~b̎擾iQƁj
	virtual	u64		GetElapsedMilliSecondRef(void)	const	= 0;
	/// oߕb̎擾
	virtual f32		GetElapsedSecondRef(void)		const;

public:
	// ^C}[̕bϊύX
	void	SetTosec(float tosec)	{ m_fTosec = tosec; }
	// ^C}[̕bϊ擾
	float	GetTosec(void)	const	{ return m_fTosec; }
	// Zbg
	void	ResetTosec(void)		{ m_fTosec = 1.0f/1000.0f; }

public:
	/// ^C}[vǂ
	virtual bool	IsActive(void)	const	{ return m_Flags.IsFlag(1 << TFO_ACTIVE); }

protected:
	/// 
	virtual void	Activate(bool active)	{ m_Flags.SetFlag(1 << TFO_ACTIVE, active); }
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
