//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndEndian.h
 * @brief		GfBAΉt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndEndian_H_
#define INCG_IRIS_FndEndian_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace fnd
{

//======================================================================
// declare
// union
union endian16;
union endian32;
union endian64;

//======================================================================
// union
//! endianΉϐ(16bit)
typedef union endian16
{
	u16	uv;
	s16 sv;
	struct
	{
		u8 byte[2];
	};
	struct
	{
#ifdef __BIG_ENDIAN__
		u8	c1;
		u8	c2;
#else
		u8	c2;
		u8	c1;
#endif
	};
} endian16;

//! endianΉϐ(32bit)
typedef union endian32
{
	u32	uv;
	s32 sv;
	struct
	{
		u8 byte[4];
	};
	struct
	{
#ifdef __BIG_ENDIAN__
		u8	c1;
		u8	c2;
		u8	c3;
		u8	c4;
#else
		u8	c4;
		u8	c3;
		u8	c2;
		u8	c1;
#endif
	};
	struct
	{
		u16	s1;
		u16	s2;
	};
} endian32;

//! endianΉϐ(64bit)
typedef union endian64
{
	u64	uv;
	s64 sv;
	struct
	{
		u8 byte[8];
	};
	struct
	{
#ifdef __BIG_ENDIAN__
		u8	c1;
		u8	c2;
		u8	c3;
		u8	c4;
		u8	c5;
		u8	c6;
		u8	c7;
		u8	c8;
#else
		u8	c8;
		u8	c7;
		u8	c6;
		u8	c5;
		u8	c4;
		u8	c3;
		u8	c2;
		u8	c1;
#endif
	};
	struct
	{
		u16	s1;
		u16	s2;
		u16	s3;
		u16	s4;
	};
	struct
	{
		u32	l1;
		u32	l2;
	};
} endian64;

//======================================================================
// function
// GfBA̔]
BOOL ReversEndian(void* pDst, const void* pSrc, u32 size, u32 tsize);

}	// end of namespace fnd
}	// end of namespace iris

#endif
