//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndVLVariable.h
 * @brief		ϒϐNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndVLVariable_H_
#define INCG_IRIS_FndVLVariable_H_

//======================================================================
// include
#include "../container/FndVector.h"
#include "FndLargeVariable.h"
#include "../../iris_debug.h"
#include <string.h>

namespace iris {
namespace fnd
{

//======================================================================
// class

//======================================================================
/** 
 * @brief		ϒϐNXirbgϐNXj
 * @note		TODO : ꉞtϐłBi܂As肻j
 * @deprecated	݂HAgȁII
 */
class CVLVariable : public IIrisObject
{
public:
	typedef u32			_VT;
	typedef u64			_LT;
	enum
	{
		VSIZE	= 32,
		LSIZE	= 64,
		VMASK	= 0xFFFFFFFF,
		VMSB	= 0x80000000
	};
	
private:
	typedef CVLVariable		_Myt;
#ifdef __BIG_ENDIAN__
	class CVectorBE : public CVector<_VT>
	{
	public:
	value_ref		operator [] (s32 pos)			{ pos = size()-pos-1; return m_list[pos]->get(); }
	const_ref		operator [] (s32 pos)	const	{ pos = size()-pos-1; return m_list[pos]->get(); }
	};
	typedef CVectorBE		_vector;
#else
	typedef CVector<_VT>	_vector;
#endif
	
private:
	// l
	// 0ŉ
	_vector		m_Variable;
public:
	// RXgN^
	CVLVariable(void)				{ m_Variable.push_back(0); }
	CVLVariable(const _Myt& src)	{ Copy(src); }
	CVLVariable(const _Myt* src)	{ Copy(*src); }
	CVLVariable(u64 number)			{ Copy(number); }
	CVLVariable(s64 number)			{ Copy(number); }
	CVLVariable(u32 number)			{ Copy((u64)number); }
	CVLVariable(s32 number)			{ Copy((s64)number); }
	CVLVariable(u16 number)			{ Copy((u64)number); }
	CVLVariable(s16 number)			{ Copy((s64)number); }
	CVLVariable(u8  number)			{ Copy((u64)number); }
	CVLVariable(s8  number)			{ Copy((s64)number); }
	CVLVariable(unsigned int number)	{ Copy((u64)number); }
	CVLVariable(int number)				{ Copy((s64)number); }

	CVLVariable(s32 arrays, bool sign, ...);
	CVLVariable(s32 arrays, _VT pArray[]);
	CVLVariable(const char* str)	{ StringTo(str); }

	template<u32 BITS>
	CVLVariable(const CLargeVariable<BITS>& src)	{ Copy(src); }
	template<u32 BITS>
	CVLVariable(const CLargeVariable<BITS>* src)	{ Copy(*src); }

	// fXgN^
	~CVLVariable(void) {}

public:
	// LXg operator
	operator	u32	(void)				{ return UnsignedCast<u32>(); }
	operator	u16	(void)				{ return UnsignedCast<u16>(); }
	operator	u8 	(void)				{ return UnsignedCast<u8>(); }
	operator	u64	(void)				{ return UnsignedCast<u64>(); }
	operator	s32	(void)				{ return SignedCast<s32>(); }
	operator	s16	(void)				{ return SignedCast<s16>(); }
	operator	s8 	(void)				{ return SignedCast<s8>(); }
	operator	s64	(void)				{ return SignedCast<s64>(); }

	operator	char(void)				{ return SignedCast<char>(); }
	operator	int	(void)				{ return SignedCast<int>(); }
	operator	unsigned int (void)		{ return UnsignedCast<unsigned int>(); }

	template<u32 BITS>
	operator	CLargeVariable<BITS> (void)			{ return LVCast< CLargeVariable<BITS> >(); }

public:
	// lZ operator
	_Myt&		operator =		(const _Myt& v)			{ return Copy(v); }
	const _Myt	operator +		(void)					{ return *this; }
	const _Myt	operator +		(const _Myt& v)	const	{ _Myt t(this); t += v; return t; }
	const _Myt	operator -		(void)			const	{ _Myt t;		t -= *this; return t; }
	const _Myt	operator -		(const _Myt& v)	const	{ _Myt t(this); t -= v; return t; }
	const _Myt	operator *		(const _Myt& v)	const	{ _Myt t(this); t *= v; return t; }
	const _Myt	operator /		(const _Myt& v)	const	{ _Myt t(this); t /= v; return t; }
	const _Myt	operator %		(const _Myt& v)	const	{ _Myt t(this); t %= v; return t; }
	_Myt&		operator +=		(const _Myt& v)			{ return Add(v); }
	_Myt&		operator -=		(const _Myt& v)			{ return Sub(v); }
	_Myt&		operator *=		(const _Myt& v)			{ return Mul(v); }
	_Myt&		operator /=		(const _Myt& v)			{ return Div(v); }
	_Myt&		operator %=		(const _Myt& v)			{ return Mod(v); }

	_Myt	operator ++		(void)					{ return Add(1); }
	_Myt	operator ++		(int)					{ _Myt t(this); Add(1); return t; }
	_Myt	operator --		(void)					{ return Sub(1); }
	_Myt	operator --		(int)					{ _Myt t(this); Sub(1); return t; }

	template<typename _TN>
	_Myt	operator <<		(_TN shift)	const		{ _Myt t(this); t <<= shift; return t; }
	template<typename _TN>
	_Myt	operator >>		(_TN shift)	const		{ _Myt t(this); t >>= shift; return t; }
	template<typename _TN>
	_Myt&	operator <<=	(_TN shift)				{ return LShift((u32)shift); }
	template<typename _TN>
	_Myt&	operator >>=	(_TN shift)				{ return RShift((u32)shift); }

	const _Myt	operator |		(const _Myt& v)	const	{ _Myt t(this); t |= v; return t; }
	const _Myt	operator &		(const _Myt& v)	const	{ _Myt t(this); t &= v; return t; }
	const _Myt	operator ^		(const _Myt& v)	const	{ _Myt t(this); t ^= v; return t; }
	_Myt&		operator |=		(const _Myt& v)			{ return OR(v); }
	_Myt&		operator &=		(const _Myt& v)			{ return AND(v); }
	_Myt&		operator ^=		(const _Myt& v)			{ return XOR(v); }
	_Myt&		operator ~		(void)					{ return NOT(); }

	bool	operator >		(const _Myt& v)	const	{ return IsGreater(v); }
	bool	operator >=		(const _Myt& v)	const	{ return !IsLess(v); }
	bool	operator <		(const _Myt& v)	const	{ return IsLess(v); }
	bool	operator <=		(const _Myt& v)	const	{ return !IsGreater(v); }
	bool	operator ==		(const _Myt& v)	const	{ return IsEqual(v); }
	bool	operator !=		(const _Myt& v)	const	{ return !IsEqual(v); }

	template<typename _TN>
	_VT		operator []		(_TN index)				{ return GetValue(index); }
	template<typename _TN>
	_VT		operator []		(_TN index)		const	{ return GetValue(index); }

public:
	// lZ operator (template)
	template<typename _TN>
	_Myt&	operator =		(_TN v)			{ return Copy(v); }
	template<typename _TN>
	_Myt	operator +		(_TN v)			{ _Myt t(this); t += v; return t; }
	template<typename _TN>
	_Myt	operator -		(_TN v)			{ _Myt t(this); t -= v; return t; }
	template<typename _TN>
	_Myt	operator *		(_TN v)			{ _Myt t(this); t *= v; return t; }
	template<typename _TN>
	_Myt	operator /		(_TN v)			{ _Myt t(this); t /= v; return t; }
	template<typename _TN>
	_Myt	operator %		(_TN v)			{ _Myt t(this); t %= v; return t; }
	template<typename _TN>
	_Myt&	operator +=		(_TN v)			{ return Add(v); }
	template<typename _TN>
	_Myt&	operator -=		(_TN v)			{ return Sub(v); }
	template<typename _TN>
	_Myt&	operator *=		(_TN v)			{ return Mul(v); }
	template<typename _TN>
	_Myt&	operator /=		(_TN v)			{ return Div(v); }
	template<typename _TN>
	_Myt&	operator %=		(_TN v)			{ return Mod(v); }

	template<typename _TN>
	_Myt	operator |		(_TN v)			{ _Myt t(this); t |= v; return t; }
	template<typename _TN>
	_Myt	operator &		(_TN v)			{ _Myt t(this); t &= v; return t; }
	template<typename _TN>
	_Myt	operator ^		(_TN v)			{ _Myt t(this); t ^= v; return t; }
	template<typename _TN>
	_Myt&	operator |=		(_TN v)			{ return OR(v); }
	template<typename _TN>
	_Myt&	operator &=		(_TN v)			{ return AND(v); }
	template<typename _TN>
	_Myt&	operator ^=		(_TN v)			{ return XOR(v); }

	template<typename _TN>
	bool	operator >		(_TN v)	const	{ return IsGreater(v); }
	template<typename _TN>
	bool	operator >=		(_TN v)	const	{ return !IsLess(v); }
	template<typename _TN>
	bool	operator <		(_TN v)	const	{ return IsLess(v); }
	template<typename _TN>
	bool	operator <=		(_TN v)	const	{ return !IsGreater(v); }
	template<typename _TN>
	bool	operator ==		(_TN v)	const	{ return IsEqual(v); }
	template<typename _TN>
	bool	operator !=		(_TN v)	const	{ return !IsEqual(v); }

public:
	/// zero fill
	void	Zero(void)
	{
		if( m_Variable.empty() ) m_Variable.push_back(0);
		else
		{
			for( _vector::iterator it=m_Variable.begin(), end=m_Variable.end(); it != end; ++it )
				*it = 0;
		}
	}
	/// ==
	bool	IsEqual(const _Myt& v) const
	{
		s32 sz1 = m_Variable.size();
		s32 sz2 = v.m_Variable.size();
		_VT tmp = 0;
		int i=0;
		_vector::const_iterator	it1 =  m_Variable.begin(), end1 =   m_Variable.end();
		_vector::const_iterator	it2 =v.m_Variable.begin(), end2 = v.m_Variable.end();
		if( sz1 < sz2 )
		{
			if( IsSign() ) tmp = (_VT)-1;
			for( ; i < sz1; ++i, ++it1, ++it2 )	
			{
				if( *it1 != *it2 ) return false;
			}
			for( ; i < sz2; ++i, ++it2 )		if( *it2 != tmp ) return false;
		}
		else
		{
			if( v.IsSign() ) tmp = (_VT)-1;
			for( ; i < sz2; ++i, ++it1, ++it2 )	if( *it1 != *it2 ) return false;
			for( ; i < sz1; ++i, ++it1 )		if( *it1 != tmp ) return false;
		}
		return true;
	}
	/// <
	bool	IsLess(const _Myt& v) const
	{
		if( IsSign() != v.IsSign() ) return IsSign();
		s32 sz1 = m_Variable.size();
		s32 sz2 = v.m_Variable.size();
		_vector::const_iterator	it1 = --  m_Variable.end(), end1 =   m_Variable.end();
		_vector::const_iterator	it2 = --v.m_Variable.end(), end2 = v.m_Variable.end();
		_VT tmp = 0;
		int i=0;
		if( sz1 < sz2 )
		{
			if( IsSign() ) tmp = (_VT)-1;
			for( i=sz2-1; i >= sz1; --i, --it2 )
			{
				if( tmp > *it2 ) return false;
				if( tmp < *it2 ) return true;
			}
			for( ; i >= 0; --i, --it1, --it2 )
			{
				if( *it1 > *it2 ) return false;
				if( *it1 < *it2 ) return true;
			}
		}
		else
		{
			if( v.IsSign() ) tmp = (_VT)-1;
			for( i=sz1-1; i >= sz2; --i, --it1 )
			{
				if( *it1 > tmp ) return false;
				if( *it1 < tmp ) return true;
			}
			for( ; i >= 0; --i, --it1, --it2 )
			{
				if( *it1 > *it2 ) return false;
				if( *it1 < *it2 ) return true;
			}
		}
		return false;
	}
	/// >
	bool	IsGreater(const _Myt& v) const
	{
		if( IsSign() != v.IsSign() ) return v.IsSign();
		s32 sz1 = m_Variable.size();
		s32 sz2 = v.m_Variable.size();
		_vector::const_iterator	it1 = --  m_Variable.end(), end1 =   m_Variable.end();
		_vector::const_iterator	it2 = --v.m_Variable.end(), end2 = v.m_Variable.end();
		_VT tmp = 0;
		int i=0;
		if( sz1 < sz2 ) 
		{
			if( IsSign() ) tmp = (_VT)-1;
			for( i=sz2-1; i >= sz1; --i, --it2 )
			{
				if( tmp > *it2 ) return true;
				if( tmp < *it2 ) return false;
			}
			for( ; i >= 0; --i, --it1, --it2 )
			{
				if( *it1 > *it2 ) return true;
				if( *it1 < *it2 ) return false;
			}
		}
		else
		{
			if( v.IsSign() ) tmp = (_VT)-1;
			for( i=sz1-1; i >= sz2; --i, --it1 )
			{
				if( *it1 > tmp ) return true;
				if( *it1 < tmp ) return false;
			}
			for( ; i >= 0; --i, --it1, --it2 )
			{
				if( *it1 > *it2 ) return true;
				if( *it1 < *it2 ) return false;
			}
		}
		return false;
	}
	/// =
	_Myt&	Copy(const _Myt& v)
	{
		s32 size = v.m_Variable.size();
		m_Variable.resize(size);
		_vector::iterator		it1=  m_Variable.begin();
		_vector::const_iterator	it2=v.m_Variable.begin();
		for( s32 i=0; i < size; ++i, ++it1, ++it2 )
		{
			*it1 = *it2;
		}
		return *this;
	}
	/// =
	template<u32 BITS>
	_Myt&	Copy(const CLargeVariable<BITS>& v)
	{
		m_Variable.resize(CLargeVariable<BITS>::ARRAYS);
		_vector::iterator it=m_Variable.begin();
		u32 i=0;
		for( ; i < CLargeVariable<BITS>::ARRAYS; ++i, ++it )
		{
			it->get() = v.GetValue(i);
		}
		_VT tmp = 0;
		if( v.IsSign() ) tmp = VMASK;
		for( i=CLargeVariable<BITS>::MSB; i > 1; --i )
		{
			if( v.GetValue(i-1) != tmp ) break;
		}
		m_Variable.resize(i+1);
		return *this;
	}
	/// = (u64)
	_Myt&	Copy(u64 v)
	{
		s32 size = sizeof(u64)/sizeof(_VT);
		m_Variable.resize(size);
		_vector::iterator it=m_Variable.begin();
		for( int i=0; i < size; ++i, ++it )
		{
			it->get() = (_VT)(v&((_VT)-1));
			v >>= VSIZE;
		}
		return *this;
	}
	/// = (s64)
	_Myt&	Copy(s64 v)
	{
		s32 size = sizeof(u64)/sizeof(_VT);
		m_Variable.resize(size);
		_vector::iterator it=m_Variable.begin();
		for( int i=0; i < size; ++i, ++it )
		{
			it->get() = (_VT)(v&((_VT)-1));
			v >>= VSIZE;
		}
		return *this;
	}
	/// cast (unsigend)
	template<typename _TN>
	_TN		UnsignedCast(void)
	{
		_TN ret = (_TN)m_Variable[0];
		_vector::iterator it=m_Variable.begin();
		for( int i=1, n=sizeof(_TN)/(s32)sizeof(_VT), sz=m_Variable.size(); i < n && i < sz; ++i, ++it )
		{
			ret |= it->get() << (i*VSIZE);
		}
		return ret;
	}
	/// cast (sigend)
	template<typename _TN>
	_TN		SignedCast(void)
	{
		_TN ret = (_TN)m_Variable[0];
		s32 tnsz = sizeof(_TN);
		_vector::iterator it=m_Variable.begin();
		for( int i=1, n=tnsz/(s32)sizeof(_VT), sz=m_Variable.size(); i < n && i < sz; ++i, ++it )
		{
			ret |= it->get() << (i*VSIZE);
		}
		ret &= ~((_TN)1<<(tnsz*8-1));
		if( IsSign() ) ret |= ((_TN)1<<(tnsz*8-1));
		return ret;
	}
	/// cast (unsigend)
	template<typename _LV>
	_LV		LVCast(void)
	{
		typedef _LV TYPE;
		typename TYPE::_VT	tmp[TYPE::ARRAYS];
		_VT* p = (_VT*)&tmp;
		_vector::iterator it=m_Variable.begin();
		s32 size = TYPE::ARRAYS > m_Variable.size() ? m_Variable.size() : TYPE::ARRAYS;
		for( int i=0; i < size; ++i, ++it )
		{
			p[i] = *it;
		}
		TYPE ret(size, tmp);
		return ret;
	}
	/// |
	_Myt&	OR(const _Myt& v)
	{
		s32 sz1 = m_Variable.size();
		s32 sz2 = v.m_Variable.size();
		_VT tmp = 0;
		int i=0;
		if( sz1 < sz2 ) Resize(sz2);
		else
		{
			if( v.IsSign() ) tmp = (_VT)-1;
		}
		_vector::iterator		it1=  m_Variable.begin();
		_vector::const_iterator it2=v.m_Variable.begin();
		for( ; i < sz2; ++i, ++it1, ++it2 ) it1->get() |= it2->get();
		for( ; i < sz1; ++i, ++it1 )		it1->get() |= tmp;
		return *this;
	}
	/// &
	_Myt&	AND(const _Myt& v)
	{
		s32 sz1 = m_Variable.size();
		s32 sz2 = v.m_Variable.size();
		_VT tmp = 0;
		int i=0;
		if( sz1 < sz2 ) Resize(sz2);
		else
		{
			if( v.IsSign() ) tmp = (_VT)-1;
		}
		_vector::iterator		it1=  m_Variable.begin();
		_vector::const_iterator it2=v.m_Variable.begin();
		for( ; i < sz2; ++i, ++it1, ++it2 ) it1->get() &= it2->get();
		for( ; i < sz1; ++i, ++it1 )		it1->get() &= tmp;
		return *this;
	}
	/// ^
	_Myt&	XOR(const _Myt& v)
	{
		s32 sz1 = m_Variable.size();
		s32 sz2 = v.m_Variable.size();
		_VT tmp = 0;
		int i=0;
		if( sz1 < sz2 ) Resize(sz2);
		else
		{
			if( v.IsSign() ) tmp = (_VT)-1;
		}
		_vector::iterator		it1=  m_Variable.begin();
		_vector::const_iterator it2=v.m_Variable.begin();
		for( ; i < sz2; ++i, ++it1, ++it2 ) it1->get() ^= it2->get();
		for( ; i < sz1; ++i, ++it1 )		it1->get() ^= tmp;
		return *this;
	}
	/// ~
	_Myt&	NOT(void)
	{
		s32 sz = m_Variable.size();
		_vector::iterator it=m_Variable.begin();
		for( int i=0; i < sz; ++i, ++it ) it->get() = ~it->get();
		return *this;
	}
	/// <<
	_Myt&	LShift(u32 shift)
	{
		// VSIZEbitȏ̃VtgɑΉ
		u32 i=0,j=0;
		u32 size = (u32)m_Variable.size();
		_vector::iterator it = m_Variable.begin();
		if( shift > VSIZE )
		{
			u32 byte = shift/VSIZE;
			Resize((s32)(size+byte));
			size = (u32)m_Variable.size();
			shift -= byte*VSIZE;
			for( i=size-1, j=size-byte; j > 0; --i, --j )
				m_Variable[(s32)i] = m_Variable[(s32)j-1];
			it = m_Variable.begin();
			for( i=0; i < byte; ++i, ++it ) 
				*it = (_VT)0;
		}
		if( shift != 0 )
		{
			_LT low=0;
			it = m_Variable.begin();
			for( i=0; i < size; ++i, ++it )
			{
				_LT a = (((_LT)it->get()) << shift) | low;
				*it = (_VT)(a & (_VT)-1);
				low = ((a >> VSIZE) & (_VT)(-1));
			}
			if( low != 0 )
			{
				m_Variable.push_back((_VT)low);
			}
		}
		return *this;
	}
	/// >>
	_Myt&	RShift(u32 shift)
	{
		u32 i=0,j=0;
		u32 size = (u32)m_Variable.size();
		_vector::iterator it = m_Variable.begin();
		// 32bitȏ̃VtgɑΉ
		if( shift > VSIZE )
		{
			u32 byte = shift/VSIZE;
			shift -= byte*VSIZE;
			if( byte > (u32)size )
			{
				byte = size;
				shift = 0;
			}
			for( i=0, j=byte; i < size-byte; ++i, ++j )
				m_Variable[(s32)i] = m_Variable[(s32)j];
			it = --m_Variable.end();
			for( i=size; i > size-byte; --i, --it ) 
				*it = (_VT)0;
		}
		if( shift != 0 )
		{
			_LT hi=0;
			it = --m_Variable.end();
			for( i=size; i > 0; --i, --it )
			{
				_LT a = (((_LT)it->get()) << (VSIZE-shift)) | (hi<<VSIZE);
				*it = (_VT)((a >> VSIZE) & VMASK);
				hi = (a & (_VT)-1);
			}
		}
		return *this;
	}
	/// bit擾
	bool	Bit(s32 offset)	const 
	{
		s32 size = m_Variable.size();
		s32 index = offset/VSIZE;
		if(index >= size) return false;
		offset -= index*VSIZE;
		return ( m_Variable[index] & (1<<offset) ) ? true : false;
	}
	/// sign
	bool	IsSign(void) const 
	{
		s32 size = m_Variable.size();
		return Bit(size*VSIZE-1);
	}
public:
	// lZ function
	/// +
	_Myt&	Add(const _Myt& v)
	{
		s32 sz1 = m_Variable.size();
		s32 sz2 = v.m_Variable.size();
		bool sign1 = IsSign();
		bool sign2 = v.IsSign();
		_VT tmp = 0;
		if( v.IsSign() ) tmp = (_VT)-1;
		if( sz1 < sz2 ) Resize(sz2);

		_vector::iterator		it1=  m_Variable.begin();
		_vector::const_iterator it2=v.m_Variable.begin();
		_LT up = 0;
		int i=0;
		for( ; i < sz2; ++i, ++it1, ++it2 )
		{
			_LT a = (_LT)it1->get() + (_LT)it2->get() + up;
			it1->get() = (_VT)(a & (_VT)(-1));
			up = ((a >> 32) & (_VT)(-1));
		}
		for( ; i < sz1; ++i, ++it1 )
		{
			_LT a = (_LT)it1->get() + (_LT)tmp + up;
			it1->get() = (_VT)(a & (_VT)(-1));
			up = ((a >> 32) & (_VT)(-1));
		}
		if( sign1 == sign2 )
		{
			if( sign1 != IsSign() )
			{
				tmp += (_VT)up;
				m_Variable.push_back(tmp);
			}
		}
		return *this;
	}
	/// |
	_Myt&	Sub(const _Myt& v)
	{
		s32 sz1 = m_Variable.size();
		s32 sz2 = v.m_Variable.size();
		_VT tmp = 0;
		if( sz1 < sz2 ) Resize(sz2);
		else
		{
			if( v.IsSign() ) tmp = (_VT)-1;
		}
		_vector::iterator		it1=  m_Variable.begin();
		_vector::const_iterator it2=v.m_Variable.begin();
		_LT up = 1;
		int i=0;
		for( ; i < sz2; ++i, ++it1, ++it2 )
		{
			_LT a = (_LT)it1->get() + ( ~(_LT)(it2->get()) & ((_VT)-1)) + up;
			it1->get() = (_VT)(a & (_VT)(-1));
			up = ((a >> VSIZE) & (_VT)(-1));
		}
		for( ; i < sz1; ++i, ++it1 )
		{
			_LT a = (_LT)it1->get() + ( ~(_LT)(tmp) & ((_VT)-1)) + up;
			it1->get() = (_VT)(a & (_VT)(-1));
			up = ((a >> VSIZE) & (_VT)(-1));
		}
		return *this;
	}
	/// *
	_Myt&	Mul(const _Myt& v)
	{
		// TODO:tvH
		s32 size = v.m_Variable.size();
		_vector::const_iterator it=v.m_Variable.begin();
		_Myt a(this);
		_Myt ret;
		for(int i=0; i < size; ++i, ++it )
		{
			for( int j=0; j < VSIZE; ++j )
			{
				_VT tmp = *it;
				if( tmp & (1<<j) ) ret += a;
				a <<= 1;
			}
		}
		Copy(ret);
		return *this;
	}
	/// /
	_Myt&	Div(const _Myt& v)
	{
		s32 size = m_Variable.size();
		_vector::iterator it=--m_Variable.end();
		// TODO:tvH
		_Myt a(this);
		Zero();
		int i, j=VSIZE-2;
		for( i=size-1; i >= 0; --i, --it )
		{
			for( ; j >= 0; --j )
			{
				if( (a >> (i*VSIZE+j)) >= v )
				{
					it->get() |= (1 << j);
					a -= (v << (i*VSIZE+j));
				}
			}
			j = VSIZE - 1;
		}
		return *this;
	}
	/// %
	_Myt&	Mod(const _Myt& v)
	{
		s32 size = m_Variable.size();
		int i, j=VSIZE-2;
		for( i=size-1; i >= 0; --i )
		{
			for( ; j >= 0; --j )
			{
				if( (*this >> (i*VSIZE+j)) >= v )
				{
					*this -= (v << (i*VSIZE+j));
				}
			}
			j = VSIZE - 1;
		}
		return *this;
	}

public:
public:
	/// string ->
	void	StringTo(const char* str)
	{
		Zero();
		if( str == nullptr ) return;
		if( str[0] == '\0' ) return;
		const char* msb = str;
		int tmp=0, base = 10, sign = 0;
		_Myt digit = 1;
		if( msb[0] == '-' ) { ++msb; sign = 1; }
		if( msb[0] == '0' && msb[1] == 'x' ) { base = 16; msb += 2; }
		const char* p = msb;
		while( *(p+1) != '\0' ) { ++p; }
		while(1)
		{
			if( base == 16 )
			{
				if( *p >= 'a' && *p <= 'f' )
				{
					tmp = *p - 'a' + 10;
					Add(digit*tmp);
				}
				if( *p >= 'A' && *p <= 'F' )
				{
					tmp = *p - 'A' + 10;
					Add(digit*tmp);
				}
			}
			if( *p >= '0' && *p <= '9' )
			{
				tmp = *p - '0';
				Add(digit*tmp);
			}
			digit *= base;
			if( p == msb ) break;
			--p;
		}
		s32 size = m_Variable.size();
		m_Variable[size-1] |= (sign << (VSIZE-1));
	}

	// to string
	s32		ToString(char* str, s32 size)
	{
		// 10i
		_Myt tmp(this);
		int i=0;
		if( str == nullptr )
		{
			for( ; tmp != 0; ++i, tmp/=10) {}
			return i;
		}
		for( ; i < size && tmp != 0; ++i, tmp/=10)
		{
			s32 n = tmp%10;
			str[i] = (char)(n + '0');
		}
		str[i] = '\0';
		_strrev(str);
		return i;
	}
public:
	// get
	/// z̒g擾
	_VT		GetValue(s32 index)			{ return m_Variable[index]; }
	/// z̒g擾
	_VT		GetValue(s32 index) const	{ return m_Variable[index]; }
	/// z̃TCY擾
	s32		GetSize(void)				{ return m_Variable.size(); }
	/// z̃TCY擾
	s32		GetSize(void)	const		{ return m_Variable.size(); }

private:
	/// TCY
	void	Resize(s32 size)
	{
		s32 sz = m_Variable.size();
		if( sz < size )
		{
			_VT val=0;
			if( IsSign() ) val = (_VT)-1;
			for( ; sz < size; ++sz )
			{
				m_Variable.push_back(val);
			}
		}
		else
		{
			m_Variable.resize(size);
		}
	}
};


/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	arrays	= pArray̔z
 * @param [in]	pArray	= memcpy
*//***********************************************************************/
inline CVLVariable::CVLVariable(s32 arrays, _VT pArray[])
{
	for( int i=0; i < arrays; ++i )
	{
		m_Variable.push_back(pArray[i]);
	}
}

}	// end of namespace fnd
}	// end of namespace iris

// iostream
#ifndef _IRIS_NOT_SUPPORT_IOSTREAM

#if defined(__cplusplus)
#include <iostream>

inline std::ostream& operator << (std::ostream& o, const iris::fnd::CVLVariable& v)
{
	int i;
	for( i=v.GetSize()-1; i > 0; --i )
	{
		if( v[i] != 0 ) break;
	}
	o << "0x";
	for( ; i > 0; --i )
	{
		o << std::hex << v[i] << "," << std::dec;
	}
	o << std::hex << v[i] << std::dec;
	return o;
}

#endif
#endif	// #ifndef _IRIS_NOT_SUPPORT_IOSTREAM


#endif
