//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndArgAnalyzer.h
 * @brief		arg̓NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndArgAnalyzer_H_
#define INCG_IRIS_FndArgAnalyzer_H_

//======================================================================
// include
#include "../container/FndObserver.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
//! arǵAsNX
class CArgAnalyzer : public IIrisObject
{
public:
	//! WNX
	class CCollecter : public CObserver<CCollecter>
	{
		friend class CArgAnalyzer;
		char	m_Name[32];	//!< 
		char*	m_pArg;		//!< 
	public:
		/// RXgN^
		CCollecter(LPCSTR pName) : m_pArg(nullptr)
		{
			strcpy_s(m_Name, sizeof(m_Name), pName);
		}
		/// ʂ̎擾
		LPSTR	GetArg(void)		{ return m_pArg; }
		/// ʂ̎擾
		bool	IsFind(void)		{ return m_pArg != nullptr; }
	public:
		/// s
		bool	Exec(void* pUser)	{ IRIS_UNUSED_VARIABLE(pUser); return true; }
	};

private:
	CSubject<CCollecter>	m_Subject;	//!< Xg
	int						m_argc;		//!< arg
	char**					m_argv;		//!< argv

public:
	// RXgN^
	CArgAnalyzer(int argc, char* argv[]);

public:
	// RN^̓o^
	void		Attach(CCollecter* pCollecter)	{ m_Subject.AttachObserver(pCollecter); }
	// RN^̍폜
	void		Detach(CCollecter* pCollecter)	{ m_Subject.DetachObserver(pCollecter); }
	// RN^̐擪擾
	CCollecter*	Begin(void)						{ return m_Subject.GetObserver(); }

public:
	// 
	void	Analyze(void);
	// s
	void	Exec(void* pUser);
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
