//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndByteArrayIOStream.h
 * @brief		u8zɑ΂ĂIONXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndByteArrayIOStream_H_
#define INCG_IRIS_FndByteArrayIOStream_H_

//======================================================================
// include
#include "../types/FndEndian.h"
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
//! u8zɑ΂ĂIONX
class CByteArrayIOStream : public IIrisObject
{
	u8*	m_pArray;	//!< f[^z
	s32	m_Length;	//!< f[^
	s32	m_Current;	//!< JgCfbNX
public:
	/// RXgN^
	CByteArrayIOStream(void) : m_pArray(nullptr), m_Length(0), m_Current(0) {}
	/// RXgN^
	CByteArrayIOStream(u8* pArray, s32 length, s32 offset)
	{
		SetArray(pArray, length);
		m_Current = offset;
	}

public:
	///	f[^ݒ
	void	SetArray(u8* pArray, s32 length)
	{
		m_pArray = pArray;
		m_Length = length;
		m_Current = 0;
	}

	/// f[^擾
	s32		GetLength(void)			const	{ return m_Length; }
	/// Jgf[^ʒu擾
	s32		GetCurrent(void)		const	{ return m_Current; }
	/// Jgf[^ʒuݒ
	void	SetCurrent(s32 offset)	{ IRIS_ASSERT(offset >= 0 && offset < m_Length); m_Current = offset; }
	/// Jgf[^ʒui߂
	void	Skip(s32 skip)			{ m_Current += skip; m_Current %= m_Length; }

public:
	/// u8l擾
	u8		ReadU8(s32 offset)
	{
		IRIS_ASSERT(offset >= 0 && offset < m_Length); 
		IRIS_ASSERT(m_pArray != nullptr);
		return m_pArray[offset];
	}

	/// u16l擾
	u16		ReadU16(s32 offset)
	{
		IRIS_ASSERT(offset >= 0 && offset+1 < m_Length); 
		IRIS_ASSERT(m_pArray != nullptr);
		u8* p = m_pArray + offset;
		endian16 ret;
		ret.c1 = *p;
		ret.c2 = *(++p);
		return ret.uv;
	}

	/// u32l擾
	u32		ReadU32(s32 offset)
	{
		IRIS_ASSERT(offset >= 0 && offset+3 < m_Length); 
		IRIS_ASSERT(m_pArray != nullptr);
		u8* p = m_pArray + offset;
		endian32 ret;
		ret.c1 = *p;
		ret.c2 = *(++p);
		ret.c3 = *(++p);
		ret.c4 = *(++p);
		return ret.uv;
	}

	/// u64l擾
	u64		ReadU64(s32 offset)
	{
		IRIS_ASSERT(offset >= 0 && offset+7 < m_Length); 
		IRIS_ASSERT(m_pArray != nullptr);
		u8* p = m_pArray + offset;
		endian64 ret;
		ret.c1 = *p;
		ret.c2 = *(++p);
		ret.c3 = *(++p);
		ret.c4 = *(++p);
		ret.c5 = *(++p);
		ret.c6 = *(++p);
		ret.c7 = *(++p);
		ret.c8 = *(++p);
		return ret.uv;
	}

	/// s8l擾
	s8		ReadS8(s32 offset)	{ return static_cast<s8>(ReadU8(offset)); }
	/// s16l擾
	s16		ReadS16(s32 offset)	{ return static_cast<s16>(ReadU16(offset)); }
	/// s32l擾
	s32		ReadS32(s32 offset)	{ return static_cast<s32>(ReadU32(offset)); }
	/// s64l擾
	s64		ReadS64(s32 offset)	{ return static_cast<s64>(ReadU64(offset)); }

public:
	/// u8l擾
	u8		ReadU8(void)		{ u8  ret = ReadU8 (m_Current); Skip(1); return ret; }	
	/// u16l擾
	u16		ReadU16(void)		{ u16 ret = ReadU16(m_Current); Skip(2); return ret; }	
	/// u32l擾
	u32		ReadU32(void)		{ u32 ret = ReadU32(m_Current); Skip(4); return ret; }	
	/// u64l擾
	u64		ReadU64(void)		{ u64 ret = ReadU64(m_Current); Skip(8); return ret; }

	/// s8l擾
	s8		ReadS8(void)		{ return static_cast<s8>(ReadU8()); }
	/// s16l擾
	s16		ReadS16(void)		{ return static_cast<s16>(ReadU16()); }	
	/// s32l擾
	s32		ReadS32(void)		{ return static_cast<s32>(ReadU32()); }	
	/// s64l擾
	s64		ReadS64(void)		{ return static_cast<s64>(ReadU64()); }

	/// wTCYf[^擾iGfBA͍lȂj
	void	Read(s32 offset, void* buf, u32 size)
	{
		IRIS_ASSERT(offset >= 0 && offset + size - 1 < (u32)m_Length);
		IRIS_ASSERT(m_pArray != nullptr);
		memcpy(buf, m_pArray, size);
	}
	/// wTCYf[^擾iGfBA͍lȂj
	void	Read(void* buf, u32 size)
	{
		Read(m_Current, buf, size);
		Skip((s32)size);
	}

public:
	/// u8l
	void	WriteU8(s32 offset, u8 data)
	{
		IRIS_ASSERT(offset >= 0 && offset < m_Length); 
		IRIS_ASSERT(m_pArray != nullptr);
		m_pArray[offset] = data;
	}

	/// u16l
	void	WriteU16(s32 offset, u16 data)
	{
		IRIS_ASSERT(offset >= 0 && offset+1 < m_Length); 
		IRIS_ASSERT(m_pArray != nullptr);
		u8* p = m_pArray + offset;
		endian16 edn;
		edn.uv = data;
		*p		= edn.c1;
		*(++p)	= edn.c2;
	}

	/// u16l
	void	WriteU32(s32 offset, u32 data)
	{
		IRIS_ASSERT(offset >= 0 && offset+3 < m_Length); 
		IRIS_ASSERT(m_pArray != nullptr);
		u8* p = m_pArray + offset;
		endian32 edn;
		edn.uv = data;
		*p		= edn.c1;
		*(++p)	= edn.c2;
		*(++p)	= edn.c3;
		*(++p)	= edn.c4;
	}

	/// u64l
	void	WriteU64(s32 offset, u64 data)
	{
		IRIS_ASSERT(offset >= 0 && offset+3 < m_Length); 
		IRIS_ASSERT(m_pArray != nullptr);
		u8* p = m_pArray + offset;
		endian64 edn;
		edn.uv = data;
		*p		= edn.c1;
		*(++p)	= edn.c2;
		*(++p)	= edn.c3;
		*(++p)	= edn.c4;
		*(++p)	= edn.c5;
		*(++p)	= edn.c6;
		*(++p)	= edn.c7;
		*(++p)	= edn.c8;
	}

	/// u8l
	void	WriteU8(u8 data)	{ WriteU8 (m_Current, data); Skip(1); }
	/// u16l
	void	WriteU8(u16 data)	{ WriteU16(m_Current, data); Skip(2); }
	/// u32l
	void	WriteU8(u32 data)	{ WriteU32(m_Current, data); Skip(4); }
	/// u64l
	void	WriteU8(u64 data)	{ WriteU64(m_Current, data); Skip(8); }

	/// wTCYf[^
	void	Write(s32 offset, void* buf, u32 size)
	{
		IRIS_ASSERT(offset >= 0 && offset + size - 1 < (u32)m_Length);
		IRIS_ASSERT(m_pArray != nullptr);
		memcpy(m_pArray + offset, buf, size);
	}
	/// wTCYf[^
	void	Write(void* buf, u32 size)
	{
		Write(m_Current, buf, size);
		Skip((s32)size);
	}

};

}	// end of namespace fnd
}	// end of namespace iris

#endif
