//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndLockObject.h
 * @brief		bNIuWFNgt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndLockObject_H_
#define INCG_IRIS_FndLockObject_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/// bNIuWFNgNX
class CLockObject : public INonCopyable<>
{
private:
	enum
	{
		LO_UNLOCK	= 0x00000000,	//!< 񃍃bN
		LO_LOCKED	= 0x10000000,	//!< bN
	};
private:
	u32		m_Lock;		//!< bNtO
public:
	/// RXgN^
	CLockObject(void) : m_Lock(LO_UNLOCK) {}
public:
	/**
	 * @brief	bN
	 * @return	ȑȌ
	*/
	u32			Lock(void)
	{
		u32 ret = m_Lock;
		m_Lock |= LO_LOCKED;
		return ret;
	}

	/**
	 * @brief	bN
	 * @return	ȑȌ
	*/
	u32			Unlock(void)
	{
		u32 ret = m_Lock;
		m_Lock &= ~LO_LOCKED;
		return ret;
	}
	
	/**
	 * @brief	bNǂ
	 * @return	^Ul
	*/
	IrisBool	IsLock(void)
	{
		return (m_Lock & LO_LOCKED) ? IRIS_TRUE : IRIS_FALSE;
	}

public:
	/**
	 * @brief	Ԏ擾
	 * @return	
	*/
	u32			GetFlag(void)	const
	{
		return m_Lock;
	}
	
};


}	// end of namespace fnd
}	// end of namespace iris

#endif
