//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndRIFF.h
 * @brief		RIFFtH[}bgt@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndRIFF_H_
#define INCG_IRIS_FndRIFF_H_

//======================================================================
// include
#include "../memory/FndMemBuffer.h"

namespace iris {
namespace fnd
{

//======================================================================
// declare
class CRIFF;

//======================================================================
// struct
/// RIFF `N
typedef struct tagRIFF_FILE_CHUNK
{
	u4cc	uID;		//!< t@Cʎq
	s32		Size;		//!< t@CTCY
	u32		uForm;		//!< tH[^Cv
} RIFF_FILE_CHUNK, *LPRIFF_FILE_CHUNK;

/// RIFF Tu`N wb_
typedef struct tagRIFF_CHUNK_HEADER
{
	u4cc	uID;		//!< ʎq
	s32		Size;		//!< TCY
} RIFF_CHUNK_HEADER, *LPRIFF_CHUNK_HEADER;

/// RIFF LIST `N
typedef struct tagRIFF_LIST_CHUNK
{
	u4cc	uID;		//!< ʎq
	s32		Size;		//!< TCY
	u32		uType;		//!< Xg^Cv
} RIFF_LIST_CHUNK, *LPRIFF_LIST_CHUNK;

/// RIFF Tu`N
#include "../../misc/iris_pushpack1.h"
typedef IRIS_PACKED struct tagRIFF_CHUNK
{
	u4cc	uID;		//!< ʎq
	s32		Size;		//!< TCY
	u8		pData[1];	//!< f[^
} RIFF_CHUNK, *LPRIFF_CHUNK;
#include "../../misc/iris_poppack.h"


/// RIFF fmt `N
typedef struct tagRIFF_FMT_CHUNK
{
	u4cc	uID;			//!< ʎq
	s32		Size;			//!< TCY
	s16		Fmt;			//!< tH[}bg
	u16		Channels;		//!< `l
	u32		SamplePerSec;	//!< TvO(Hz)
	u32		BytePerSec;		//!< σf[^
	u16		BlockAlign;		//!< f[^̃ubNTCY
	u16		BitsWidth;		//!< 1Tvbit
} RIFF_FMT_CHUNK, *LPRIFF_FMT_CHUNK;

/// RIFF gfmt `N
#include "../../misc/iris_pushpack2.h"
typedef IRIS_PACKED struct tagRIFF_FMT_EX_CHUNK
{
	u4cc	uID;			//!< ʎq
	s32		Size;			//!< TCY
	s16		Fmt;			//!< tH[}bg
	u16		Channels;		//!< `l
	u32		SamplePerSec;	//!< TvO(Hz)
	u32		BytePerSec;		//!< σf[^
	u16		BlockAlign;		//!< f[^̃ubNTCY
	u16		BitsWidth;		//!< 1Tvbit
	u16		ExtSize;		//!< gTCY
} RIFF_FMT_EX_CHUNK, *LPRIFF_FMT_EX_CHUNK;
#include "../../misc/iris_poppack.h"

/// RIFF data `N
#include "../../misc/iris_pushpack1.h"
typedef IRIS_PACKED struct tagRIFF_DATA_CHUNK
{
	u4cc	uID;		//!< ʎq
	s32		Size;		//!< TCY
	u8		pData[1];	//!< f[^
} RIFF_DATA_CHUNK, *LPRIFF_DATA_CHUNK;
#include "../../misc/iris_poppack.h"


/// RIFF cue point \
typedef struct tagRIFF_CUEPOINT
{
	s32		Identifier;		//!< 
	s32		Position;		//!< 
	u32		Chunk;			//!< 
	s32		ChunkStart;		//!< 
	s32		BlockStart;		//!< 
	s32		SampleOffset;	//!< 
} RIFF_CUEPOINT, *LPRIFF_CUEPOINT;

/// RIFF cue `N
typedef struct tagRIFF_CUE_CHUNK
{
	u4cc	uID;				//!< ʎq
	s32		Size;				//!< TCY
	s32		nCuePoint;			//!< CuePoint
	RIFF_CUEPOINT Points[1];	//!< CuePoint
} RIFF_CUE_CHUNK, *LPRIFF_CUE_CHUNK;


/// RIFF Playlist \
typedef struct tagRIFF_SEGMENT
{
	s32		Identifier;		//!< 
	s32		Length;			//!< 
	s32		Repeats;		//!< 
} RIFF_SEGMENT, *LPRIFF_SEGMENT;

/// RIFF Playlist `N
typedef struct tagRIFF_PLST_CHUNK
{
	u4cc	uID;			//!< ʎq
	s32		Size;			//!< TCY
	s32		nSegment;		//!< segment
	RIFF_SEGMENT Segments;	//!< segment
} RIFF_PLST_CHUNK, *LPRIFF_PLST_CHUNK;


/// RIFF Label `N
#include "../../misc/iris_pushpack1.h"
typedef IRIS_PACKED struct tagRIFF_LABL_CHUNK
{
	u4cc	uID;			//!< ʎq
	s32		Size;			//!< TCY
	s32		Identifier;		//!< 
	char	Text[1];		//!< 
} RIFF_LABL_CHUNK, *LPRIFF_LABL_CHUNK;
#include "../../misc/iris_poppack.h"


/// RIFF note `N
#include "../../misc/iris_pushpack1.h"
typedef IRIS_PACKED struct tagRIFF_NOTE_CHUNK
{
	u4cc	uID;			//!< ʎq
	s32		Size;			//!< TCY
	s32		Identifier;		//!< 
	char	Text[1];		//!< 
} RIFF_NOTE_CHUNK, *LPRIFF_NOTE_CHUNK;
#include "../../misc/iris_poppack.h"


/// RIFF Label Text `N
#include "../../misc/iris_pushpack1.h"
typedef IRIS_PACKED struct tagRIFF_LTXT_CHUNK
{
	u4cc	uID;			//!< ʎq
	s32		Size;			//!< TCY
	s32		Identifier;		//!< 
	s32		SampleLength;	//!< 
	s32		Purpose;		//!< 
	s16		Country;		//!< 
	s16		Language;		//!< 
	s16		Dialect;		//!< 
	s16		CodePage;		//!< 
	char	Text[1];		//!< 
} RIFF_LTXT_CHUNK, *LPRIFF_LTXT_CHUNK;
#include "../../misc/iris_poppack.h"


/// RIFF Sample Loop \
typedef struct tagRIFF_SMPL_LOOP
{
	s32		Identifier;		//!< 
	s32		Type;			//!< 
	s32		Start;			//!< [vJnTv
	s32		End;			//!< [vITv
	s32		Fraction;		//!< 
	s32		PlayCount;		//!< 
} RIFF_SMPL_LOOP, *LPRIFF_SMPL_LOOP;

/// RIFF smpl `N
typedef struct tagRIFF_SMPL_CHUNK
{
	u4cc	uID;				//!< ʎq
	s32		Size;				//!< TCY
	s32		Manufacturer;		//!< 
	s32		Product;			//!< 
	s32		SamplePeriod;		//!< 
	s32		MIDIUnityNote;		//!< 
	s32		MIDIPitchFraction;	//!< 
	s32		SMPTEFormat;		//!< 
	s32		SMPTEOffset;		//!< 
	s32		SampleLoops;		//!< [v
	s32		SamplerData;		//!< [vTCY
	RIFF_SMPL_LOOP	Loops[1];	//!< [v
} RIFF_SMPL_CHUNK, *LPRIFF_SMPL_CHUNK;


/// RIFF Instruments `N
#include "../../misc/iris_pushpack1.h"
typedef IRIS_PACKED struct tagRIFF_INST_CHUNK
{
	u4cc	uID;				//!< ʎq
	s32		Size;				//!< TCY
	u8		UnshiftedNote;		//!< 
	s8		FineTune;			//!< 
	s8		Gain;				//!< 
	u8		LowNote;			//!< 
	u8		HighNote;			//!< 
	u8		LowVelocity;		//!< 
	u8		HighVelocity;		//!< 
} RIFF_INST_CHUNK, *LPRIFF_INST_CHUNK;
#include "../../misc/iris_poppack.h"

/// RIFF AVIH `N
typedef struct tagRIFF_AVIH_CHUNK
{
	u4cc	uID;				//!< ʎq
	s32		Size;				//!< TCY
	u32		MicroSecPerFrame;	//!< t[ԁi܂ 0j
	u32		MaxBytesPerSec;		//!< ][g̍ől
	u32		PaddingGranularity;	//!< ̃TCY̔{ɃpfBO
	u32		Flags;				//!< ŒtO
	u32		TotalFrames;		//!< # t@C̃t[
	u32		InitialFrames;		//!< 
	u32		Streams;			//!< Xg[
	u32		SuggestedBufferSize;//!< 
	u32		Width;				//!< rfIXg[̕
	u32		Height;				//!< rfIXg[̍
} RIFF_AVIH_CHUNK, *LPRIFF_AVIH_CHUNK;

/// RIFF stream header `N
typedef struct tagRIFF_STRH_CHUNK
{
	u4cc	uID;				//!< ʎq
	s32		Size;				//!< TCY
	u4cc	uType;				//!< ^Cv
	u4cc	uHandler;			//!< R[fbN̎ʎq
	u32		Flags;				//!< tO
	u16		Priority;			//!< 
	u16		Language;			//!< 
	u32		InitialFrames;		//!< t@Cɑ݂Xg[̍ŏ̃ubN̐
	u32		Scale;				//!< Rate / Scale == samples/second
	u32		Rate;				//!< Rate / Scale == samples/second
	u32		Start;				//!< Xg[̊Jn
	u32		Length;				//!< RateScaleŒ`Pʂł̃Xg[̃TCY
	u32		SuggestedBufferSize;//!< 
	u32		Quality;			//!< NIeB
	u32		SampleSize;			//!< Xg[̍ŏP
    IrisIRect	Frame;			//!< 
} RIFF_STRH_CHUNK, *LPRIFF_STRH_CHUNK;



//======================================================================
// enum
// `Nʎq
typedef enum
{
	// big endian
	RIFF_ID_FILE_CHUNK	= IRIS_FOURCC_BE('R','I','F','F'),	//!< t@C
	RIFF_ID_LIST_CHUNK	= IRIS_FOURCC_BE('L','I','S','T'),	//!< Xg`N

	// audio
	RIFF_ID_FMT_CHUNK	= IRIS_FOURCC_BE('f','m','t',' '),	//!< fmt`N
	RIFF_ID_DATA_CHUNK	= IRIS_FOURCC_BE('d','a','t','a'),	//!< data`N
	RIFF_ID_FACT_CHUNK	= IRIS_FOURCC_BE('f','a','c','t'),	//!< fact`N
	RIFF_ID_CUE_CHUNK	= IRIS_FOURCC_BE('c','u','e',' '),	//!< cue`N
	RIFF_ID_PLST_CHUNK	= IRIS_FOURCC_BE('p','l','s','t'),	//!< playlist`N
	RIFF_ID_LABL_CHUNK	= IRIS_FOURCC_BE('l','a','b','l'),	//!< x`N
	RIFF_ID_NOTE_CHUNK	= IRIS_FOURCC_BE('n','o','t','e'),	//!< note`N
	RIFF_ID_LTXT_CHUNK	= IRIS_FOURCC_BE('l','t','x','t'),	//!< xeLXg`N
	RIFF_ID_SMPL_CHUNK	= IRIS_FOURCC_BE('s','m','p','l'),	//!< smpl`N
	RIFF_ID_INST_CHUNK	= IRIS_FOURCC_BE('i','n','s','t'),	//!< inst`N

	// avi
	RIFF_ID_AVIH_CHUNK	= IRIS_FOURCC_BE('a','v','i','h'),	//!< avih`N
	RIFF_ID_STRH_CHUNK	= IRIS_FOURCC_BE('s','t','r','h'),	//!< strh`N
	RIFF_ID_STRF_CHUNK	= IRIS_FOURCC_BE('s','t','r','f'),	//!< strf`N
	RIFF_ID_STRN_CHUNK	= IRIS_FOURCC_BE('s','t','r','n'),	//!< strn`N
	RIFF_ID_INDX_CHUNK	= IRIS_FOURCC_BE('i','n','d','x')	//!< indx`N
} RIFF_CHUNK_ID;

//!< RIFF tH[^Cv
typedef enum
{
	RIFF_FORM_WAVE	= IRIS_FOURCC_BE('W','A','V','E'),	//!< WAVE
	RIFF_FORM_AVI	= IRIS_FOURCC_BE('A','V','I',' ')	//!< AVI 
} RIFF_FORM_TYPE;

//======================================================================
// class
/// RIFFtH[}bgt@CNX
class CRIFF : public CMemBuffer
{
public:
	// RXgN^
	CRIFF(void);
	// fXgN^
	virtual ~CRIFF(void);
public:
	// J
	bool	Open (LPCTSTR fname);
	bool	OpenA(LPCSTR  fname);
	bool	OpenW(LPCWSTR fname);
	// 
	void	Close(void);

public:
	// LȏԂǂ
	bool	IsValid(void)		const;
	// t@CTCY̎擾
	u32		GetSize(void)		const;
	// tH[^Cv̎擾
	u32		GetFormType(void)	const;

public:
	// LIST`Ň
	LPRIFF_LIST_CHUNK	FindListChunk(LPRIFF_LIST_CHUNK chunk);
	// LIST`Ň
	LPRIFF_LIST_CHUNK	FindListChunk(u32 ListType);

	// Tu`Ň
	LPRIFF_CHUNK		FindChunk(LPRIFF_CHUNK chunk);
	// Tu`Ň
	LPRIFF_CHUNK		FindChunk(u32 ChunkType);
	// LIST`ÑTu`Ň
	LPRIFF_CHUNK		FindChunk(LPRIFF_LIST_CHUNK list, LPRIFF_CHUNK chunk);
	// LIST`ÑTu`Ň
	LPRIFF_CHUNK		FindChunk(LPRIFF_LIST_CHUNK list, u32 ChunkType);

	// ̃`N擾
	LPRIFF_CHUNK_HEADER	GetNextChunk(const LPRIFF_CHUNK_HEADER chunk);

private:
	// ʃI[v
	bool	_Open(void);
};


}	// end of namespace fnd
}	// end of namespace iris

#endif
