//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndRingBuffer.cpp
 * @brief		obt@NXx[X
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndRingBuffer_CPP_

//======================================================================
// include
#include "FndRingBuffer.h"
#include <string.h>

#include "iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CRingBuffer::CRingBuffer(void)
: m_pBuffer(nullptr)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	lpBuffer	= obt@AhX
*//***********************************************************************/
CRingBuffer::CRingBuffer(void* lpBuffer)
: m_pBuffer(nullptr)
{
	Bind(lpBuffer);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CRingBuffer::~CRingBuffer(void)
{
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	lpBuffer	= obt@AhX
 * @param [in]	uSize		= obt@TCY
*//***********************************************************************/
void CRingBuffer::Init(void* lpBuffer, u32 uSize)
{
	IRIS_ASSERT( uSize > sizeof(HEADER) );
	m_pBuffer = static_cast<LPHEADER>(lpBuffer);
	m_pBuffer->signature = SIGNATURE;
	m_pBuffer->status	= 0;
	m_pBuffer->start	= static_cast<u8*>(lpBuffer) + sizeof(HEADER);
	m_pBuffer->end		= m_pBuffer->start;
	m_pBuffer->buf		= m_pBuffer->start;
	m_pBuffer->size		= uSize - sizeof(HEADER);
}

/**********************************************************************//**
 *
 * o^
 *
 ----------------------------------------------------------------------
 * @param [in]	lpBuffer	= obt@AhX
 * @return	
*//***********************************************************************/
bool CRingBuffer::Bind(void* lpBuffer)
{
	LPHEADER head = static_cast<LPHEADER>(lpBuffer);
	if( head->signature != SIGNATURE ) return false;
	m_pBuffer = head;
	return true;
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [out]	lpBuffer	= obt@AhX
 * @param [in]	uSize		= obt@TCY
 * @param [out]	lpRead		= ǂݍ񂾃TCY
 * @return	GetReadableSizeǂݍ񂾂ǂ
*//***********************************************************************/
bool CRingBuffer::Read(void* lpBuffer, u32 uSize, u32* lpRead)
{
	IRIS_ASSERT( lpBuffer != nullptr );
	IRIS_ASSERT( lpRead != nullptr );
	u32 readable = GetReadableSize();
	if( readable == 0 )
	{
		*lpRead = 0;
		return true;
	}

	u8* pDst = (u8*)lpBuffer;
	u8* pSrc = _IncAddr(m_pBuffer->start, sizeof(u32));
	u8* end = GetEnd();
	u32 rest = readable;
	if( readable > uSize ) rest = IRIS_RoundDown4B(uSize);
	*lpRead = rest;

	while( rest > 0 )
	{
		u32 read = min( (u32)(end - pSrc), rest );
		memcpy(pDst, pSrc, read);
		pSrc = _IncAddr(pSrc, IRIS_RoundUp4B(read));
		pDst += read;
		rest -= read;
	}

	if( *lpRead != readable )
	{
		u32 size = readable - *lpRead;
		pSrc = _DecAddr(pSrc, sizeof(u32));
		*(u32*)pSrc = size;
		return false;
	}
	return true;
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	lpBuffer	= obt@AhX
 * @param [in]	uSize		= obt@TCY
 * @return	
*//***********************************************************************/
bool CRingBuffer::Write(const void* lpBuffer, u32 uSize)
{
	IRIS_ASSERT( lpBuffer != nullptr );
	if( uSize > GetWritableSize() )
	{
		m_pBuffer->status |= STATUS_OVERFLOW;
		return false;
	}
	// TCYwb_𖄂ߍ
	*(u32*)m_pBuffer->end = uSize;
	u8* pSrc = (u8*)lpBuffer;
	u8* pDst = _IncAddr(m_pBuffer->end, sizeof(u32));
	u8* end  = GetEnd();
	while( uSize > 0 )
	{
		u32 write = min( (u32)(end - pDst), uSize );
		memcpy(pDst, pSrc, write);
		pDst = _IncAddr(pDst, IRIS_RoundUp4B(write));
		pSrc += write;
		uSize -= write;
	}
	m_pBuffer->end = pDst;
	return true;
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	lpBuffer	= obt@AhX
 * @param [in]	uSize		= obt@TCY
 * @return	
*//***********************************************************************/
bool CRingBuffer::WriteEx(const void* lpBuffer, u32 offset, u32 uSize, u32 totalSize)
{
	IRIS_ASSERT( lpBuffer != nullptr );
	if( offset+uSize > GetWritableSize() )
	{
		m_pBuffer->status |= STATUS_OVERFLOW;
		return false;
	}
	// TCYwb_𖄂ߍ
	*(u32*)m_pBuffer->end = totalSize;
	u8* pSrc = (u8*)lpBuffer;
	u8* pDst = _IncAddr(m_pBuffer->end, sizeof(u32) + offset);
	u8* end  = GetEnd();
	while( uSize > 0 )
	{
		u32 write = min( (u32)(end - pDst), uSize );
		memcpy(pDst, pSrc, write);
		pDst = _IncAddr(pDst, IRIS_RoundUp4B(write));
		pSrc += write;
		uSize -= write;
	}
	if( offset + uSize == totalSize ) m_pBuffer->end = pDst;
	return true;
}

/**********************************************************************//**
 *
 * ǂݍ݉\obt@TCY̎擾
 *
 ----------------------------------------------------------------------
 * @return	TCY
*//***********************************************************************/
u32 CRingBuffer::GetReadableSize(void)
{
	if( m_pBuffer->start == m_pBuffer->end ) return 0;
	return *(u32*)m_pBuffer->start;
}

/**********************************************************************//**
 *
 * ǂݍ݉\ȂׂẴobt@TCY̎擾
 *
 ----------------------------------------------------------------------
 * @return	TCY
*//***********************************************************************/
u32 CRingBuffer::GetTotalReadableSize(void)
{
	if( m_pBuffer->start == m_pBuffer->end ) return 0;
	u32 total = 0;
	u8* start = m_pBuffer->start;
	while( start != m_pBuffer->end )
	{
		u32 size = *(u32*)start;
		total += size;
		start = _IncAddr(start, IRIS_RoundUp4B(size));
	}
	return total;
}

/**********************************************************************//**
 *
 * ݉\ȃobt@TCY̎擾
 *
 ----------------------------------------------------------------------
 * @return	TCY
*//***********************************************************************/
u32 CRingBuffer::GetWritableSize(void)
{
	u32 write = 0;
	if( m_pBuffer->start > m_pBuffer->end )
	{
		write = (u32)(m_pBuffer->end - m_pBuffer->start);
	}
	else
	{
		write = m_pBuffer->size - ( (u32)(m_pBuffer->end - m_pBuffer->start) );
	}
	write -= sizeof(u32);	// TCYwb_
	if( write > 0 ) write -= sizeof(u32);
	return write;
}


/**********************************************************************//**
 *
 * AhX̃CNg
 *
 ----------------------------------------------------------------------
 * @param [in]	ptr		= obt@AhX
 * @param [in]	inc		= i߂TCY
 * @return	
*//***********************************************************************/
u8* CRingBuffer::_IncAddr(u8* ptr, u32 inc)
{
	ptr += inc;
	if( ptr >= GetEnd() )
	{
		ptr -= m_pBuffer->size;
	}
	return ptr;
}

/**********************************************************************//**
 *
 * AhX̃fNg
 *
 ----------------------------------------------------------------------
 * @param [in]	ptr		= obt@AhX
 * @param [in]	inc		= ߂TCY
 * @return	
*//***********************************************************************/
u8* CRingBuffer::_DecAddr(u8* ptr, u32 dec)
{
	ptr -= dec;
	if( ptr < m_pBuffer->buf )
	{
		ptr += m_pBuffer->size;
	}
	return ptr;
}

}	// end of namespace fnd
}	// end of namespace iris
