//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndUID.h
 * @brief		j[NIDWFl[^t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FndUID_H_
#define INCG_IRIS_FndUID_H_

//======================================================================
// include
#include "../../iris_object.h"
#include "../../iris_debug.h"

namespace iris {
namespace fnd
{

//======================================================================
// class
/**
 * @brief	j[NIDWFl[^NX
 *
 * @template	MAX_NUM	= \ID̏
 * @template	BASE_NO	= ID̃x[Xl
*/
template< u32 MAX_NUM = 32, int BASE_NO = 0 >
class CUIDGenerator : public INonCopyable<>
{
//--------------------
// `
private:
	enum {
		PARTIAL_BITS			= 32,
		MAX_REFBIT				= (MAX_NUM+PARTIAL_BITS-1)/PARTIAL_BITS
	};
//--------------------
// ϐ錾
private:
	u32	m_bits[MAX_REFBIT];
	
//--------------------
// ֐錾
public:
	/// RXgN^
	CUIDGenerator(void)		{ memset( m_bits, 0, sizeof(m_bits) ); }
	/// fXgN^
	~CUIDGenerator(void)	{}
public:
	/// UID̍쐬
	s32		Create(void)
	{
		for( int i=0; i < MAX_REFBIT; ++i )
		{
			u32 bits = refbit(i);
			if( bits != 0xFFFFFFFF )
			{
				s32 shift = 0;
				if( !((bits & 0x0000FFFF) ^ 0x0000FFFF) ) 
				{
					shift += 16;
					bits = (bits >> 16);
				}
				if( !((bits & 0x000000FF) ^ 0x000000FF) ) 
				{
					shift += 8;
					bits = (bits >> 8);
				}
				if( !((bits & 0x0000000F) ^ 0x0000000F) ) 
				{
					shift += 4;
					bits = (bits >> 4);
				}
				if( !((bits & 0x00000003) ^ 0x00000003) ) 
				{
					shift += 2;
					bits = (bits >> 2);
				}
				if( !((bits & 0x00000001) ^ 0x00000001) )
				{
					shift += 1;
				}
				refbit(i) |= (0x1) << shift;
				return ( BASE_NO + (i*PARTIAL_BITS+shift) );
			}
		}
		// Œ~MAX_NUM𑝂₷
		IRIS_ASSERTMSG( 0, "cant find free work!!" );
		return BASE_NO-1;
	}
	/// UID̕Ԋ
	void	Delete(s32 uid)
	{
		int id = uid - BASE_NO;
		if( id >= 0 && id < MAX_NUM )
		{
			int index = id / PARTIAL_BITS;
			int shift = id - (index*PARTIAL_BITS);
			refbit(index) &= ~(0x1<<shift);
		}
	}

private:
	
	u32&	refbit(int index) { return m_bits[index]; }
};

}	// end of namespace fnd
}	// end of namespace iris

#endif
