//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FndVram.cpp
 * @brief		VRAMNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FndVram_CPP_

//======================================================================
// include
#include "FndVram.h"

namespace iris {
namespace fnd
{

//======================================================================
// class

/**********************************************************************//**
 *
 * ubÑNA
 *
*//***********************************************************************/
void CVramBlock::Clear(void)
{
	if( !IsValid() ) return;
	SecureZeroMemory((void*)m_Base, m_Size);
}


/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CVram::CVram(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CVram::~CVram(void)
{
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @param [in]	base	= x[XAhX
 * @param [in]	size	= TCY
*//***********************************************************************/
bool CVram::Initialize(u32 base, u32 size)
{
	if( m_Size != 0 ) return false;
	m_Base = base;
	m_Size = size;
	return true;
}

/**********************************************************************//**
 *
 * I
 *
*//***********************************************************************/
void CVram::Terminate(void)
{
	ReleaseAll();
	m_Base = 0;
	m_Size = 0;
}

/**********************************************************************//**
 *
 * ubN̊m
 *
 -----------------------------------------------------------------------
 * @param [in]	pBlk	= ubN
 * @param [in]	uBase	= x[XAhX
 * @param [in]	uSize	= vTCY
*//***********************************************************************/
bool CVram::NewBlock(CVramBlock* pBlk, u32 uBase, u32 uSize)
{
	if( pBlk == nullptr ) return false;
	if( IsValid() == false ) return false;
	IRIS_ASSERT( uSize != 0 );

	u32 base = m_Base;
	if( base > uBase && uBase > base + m_Size ) return false;
	for( CVramList::iterator it = m_List.begin(), end = m_List.end(); it != end; ++it )
	{
		u32 blk_base = it->GetBase();
		if( base <= uBase && uBase + uSize <= blk_base )
		{
			// m
			pBlk->Set(uBase, uSize);
			m_List.insert(it, pBlk);
			return true;
		}
		base = blk_base + it->GetSize(); 
	}
	if( base <= uBase && uBase + uSize <= m_Base + m_Size )
	{
		pBlk->Set(uBase, uSize);
		m_List.push_back(pBlk);
		return true;
	}
	return false;
}

/**********************************************************************//**
 *
 * ubN̊m
 *
 -----------------------------------------------------------------------
 * @param [in]	pBlk	= ubN
 * @param [in]	uSize	= vTCY
 * @param [in]	uAlign	= ACg
*//***********************************************************************/
bool CVram::NewBlockAlign(CVramBlock* pBlk, u32 uSize, u32 uAlign)
{
	if( pBlk == nullptr ) return false;
	if( IsValid() == false ) return false;
	IRIS_ASSERT( uAlign != 0 );

	u32 valid_base = m_Base;
	u32 valid_size = m_Size;
	u32 valid_next = valid_base + valid_size;

	const u32 mask_inv	= uAlign - 1;
	const u32 mask		= ~mask_inv;

	u32 base = (valid_base + mask_inv) & mask;
	if( base + uSize >= valid_next ) return false;

	for( CVramList::iterator it = m_List.begin(), end = m_List.end(); it != end; ++it )
	{
		u32 blk_base = it->GetBase();
		u32 blk_size = it->GetSize();
		if( blk_base >= valid_base )
		{
			const u32 empty_next = (valid_next < blk_base) ? valid_next : blk_base;
			if( base < empty_next )
			{
				const u32 empty_size = empty_next - base;
				if( empty_size >= uSize )
				{
					// m
					pBlk->Set(base, uSize);
					m_List.insert(it, pBlk);
					return true;
				}
			}
			const u32 tmp_base = (blk_base + blk_size + mask_inv) & mask;
			if( tmp_base > base )
			{
				base = tmp_base;
				if( base >= valid_next ) return false;
			}
		}
	}

	if( base + uSize <= valid_next )
	{
		pBlk->Set(base, uSize);
		m_List.push_back(pBlk);
		return true;
	}

	return false;
}

/**********************************************************************//**
 *
 * ubN̊m
 *
 -----------------------------------------------------------------------
 * @param [in]	pBlk		= ubN
 * @param [in]	uSize		= vTCY
 * @param [in]	uAlign		= ACg
 * @param [in]	uAreaBase	= ̈x[XAhX
 * @param [in]	uAreaSize	= ̈TCY
*//***********************************************************************/
bool CVram::NewBlockAlign(CVramBlock* pBlk, u32 uSize, u32 uAlign, u32 uAreaBase, u32 uAreaSize)
{
	if( pBlk == nullptr ) return false;
	if( IsValid() == false ) return false;
	IRIS_ASSERT( uAlign != 0 );

	u32 valid_base = m_Base;
	u32 valid_size = m_Size;
	u32 valid_next = valid_base + valid_size;

    const u32 area_next = uAreaBase + uAreaSize;

	if( valid_base < uAreaBase ) valid_base = uAreaBase;
	if( valid_next > area_next ) valid_next = area_next;

    valid_size = valid_next - valid_base;

	const u32 mask_inv	= uAlign - 1;
	const u32 mask		= ~mask_inv;

	u32 base = (valid_base + mask_inv) & mask;
	if( base + uSize >= valid_next ) return false;

	for( CVramList::iterator it = m_List.begin(), end = m_List.end(); it != end; ++it )
	{
		u32 blk_base = it->GetBase();
		u32 blk_size = it->GetSize();
		if( blk_base >= valid_base )
		{
			const u32 empty_next = (valid_next < blk_base) ? valid_next : blk_base;
			if( base < empty_next )
			{
				const u32 empty_size = empty_next - base;
				if( empty_size >= uSize )
				{
					// m
					pBlk->Set(base, uSize);
					m_List.insert(it, pBlk);
					return true;
				}
			}
			const u32 tmp_base = (blk_base + blk_size + mask_inv) & mask;
			if( tmp_base > base )
			{
				base = tmp_base;
				if( base >= valid_next ) return false;
			}
		}
	}

	if( base + uSize <= valid_next )
	{
		pBlk->Set(base, uSize);
		m_List.push_back(pBlk);
		return true;
	}

	return false;
}

/**********************************************************************//**
 *
 * ubN̉
 *
 -----------------------------------------------------------------------
 * @param [in]	pBlk	= ubN
*//***********************************************************************/
void CVram::ReleaseBlock(CVramBlock* pBlk)
{
	if( pBlk == nullptr ) return;
	pBlk->Set(0, 0);
	m_List.erase(pBlk);
}

/**********************************************************************//**
 *
 * ubN̑S
 *
*//***********************************************************************/
void CVram::ReleaseAll(void)
{
	for( CVramList::iterator it = m_List.begin(), end = m_List.end(); it != end; )
	{
		it->Set(0, 0);
		it = m_List.erase(it);
	}
}

}	// end of namespace fnd
}	// end of namespace iris
