//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvWindow.cpp
 * @brief		OpenCV Window t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_CvWindow_CPP_

//======================================================================
// include
#include "CvWindow.h"
#include "../CvSystem.h"
#include "../../../iris_debug.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace cv
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCvWindow::CCvWindow(void)
: m_hWnd(nullptr)
{
	CCvSystem::Initialize();
}

/**********************************************************************//**
 *
 * RXgN^
 *
 -----------------------------------------------------------------------
 * @param [in]	wnd	= EBhEnh
*//***********************************************************************/
CCvWindow::CCvWindow(cvHWND wnd)
: m_hWnd(nullptr)
{
	CCvSystem::Initialize();
	Attach(wnd);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CCvWindow::~CCvWindow(void)
{
	Close();
}

/**********************************************************************//**
 *
 * A^b`
 *
 -----------------------------------------------------------------------
 * @param [in]	wnd	= EBhEnh
 * @return 
*//***********************************************************************/
bool CCvWindow::Attach(cvHWND wnd)
{
	if( m_hWnd != nullptr ) return false;
	m_hWnd = wnd;
	return true;
}

/**********************************************************************//**
 *
 * f^b`
 *
 -----------------------------------------------------------------------
 * @return ȑÕEBhEnh
*//***********************************************************************/
cvHWND CCvWindow::Detach(void)
{
	cvHWND hWnd = m_hWnd;
	m_hWnd = nullptr;
	return hWnd;
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszName	= EBhE
 * @param [in]	flags		= tO
 * @return	
*//***********************************************************************/
bool CCvWindow::Create(LPCSTR lpszName, int flags)
{
	Close();
	//::cv::namedWindow(lpszName, flags);
	cvNamedWindow(lpszName, flags);
	return OnCreate(lpszName);
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CCvWindow::Close(void)
{
	if( m_hWnd != nullptr )
	{
		cvDestroyWindow(GetWindowName());
		m_hWnd = nullptr;
	}
}

/**********************************************************************//**
 *
 * C[W̕\
 *
 -----------------------------------------------------------------------
 * @param [in]	x	= xW
 * @param [in]	y	= yW
*//***********************************************************************/
void CCvWindow::Move(int x, int y)
{
	cvMoveWindow(GetWindowName(), x, y);
}

/**********************************************************************//**
 *
 * C[W̕\
 *
 -----------------------------------------------------------------------
 * @param [in]	image	= C[W̔z
*//***********************************************************************/
void CCvWindow::ShowImage(const ::cv::Mat& image)
{
	if( m_hWnd != 0 )
	{
		::cv::imshow(GetWindowName(), image);
	}
}

/**********************************************************************//**
 *
 * EBhE̎擾
 *
 -----------------------------------------------------------------------
 * @return	EBhE
*//***********************************************************************/
LPCSTR CCvWindow::GetWindowName(void)
{
	return cvGetWindowName(m_hWnd);
}

/**********************************************************************//**
 *
 * 쐬̏
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszName		= EBhE
 * @return	
*//***********************************************************************/
bool CCvWindow::OnCreate(LPCSTR lpszName)
{
	IRIS_ASSERT(lpszName != nullptr);
	if( m_hWnd != nullptr ) return false;
	m_hWnd = cvGetWindowHandle(lpszName);
	if( m_hWnd == nullptr ) return false;
	return true;
}

}	// end of namespace cv
}	// end of namespace gx
}	// end of namespace iris

#endif
