//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		CvImage.cpp
 * @brief		OpenCV Image t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_CvImage_CPP_

//======================================================================
// include
#include "CvImage.h"
#include "iris_debug.h"

#ifdef _IRIS_SUPPORT_OPENCV

namespace iris {
namespace gx {
namespace cv
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCvImage::CCvImage(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CCvImage::~CCvImage(void)
{
	Release();
}

/**********************************************************************//**
 *
 * C[W̍쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	size		= TCY
 * @param [in]	depth		= [x
 * @param [in]	channels	= `l
 * @return	
*//***********************************************************************/
bool CCvImage::Create(const CvSize& size, int depth, int channels)
{
	Release();
	IplImage* pImage = cvCreateImage(size, depth, channels);
	if( pImage == nullptr ) return false;
	Attach(pImage);
	return true;
}

/**********************************************************************//**
 *
 * C[W̃[h
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszPath	= pX
 * @param [in]	flags		= tO
 * @return	
*//***********************************************************************/
bool CCvImage::Load(LPCSTR lpszPath, int flags)
{
	Release();
	IplImage* pImage = cvLoadImage(lpszPath, flags);
	if( pImage == nullptr ) return false;
	Attach(pImage);
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CCvImage::Release(void)
{
	m_Mat.release();
}

/**********************************************************************//**
 *
 * J[tH[}bg̕ϊ
 *
 -----------------------------------------------------------------------
 * @param [out]	rImage		= o
 * @param [in]	code		= tO
 * @param [in]	dstChannels	= o̓`l(0 w肷ƎvZ)
 * @return	
*//***********************************************************************/
void CCvImage::TranslateColor(CCvImage& rImage, int code, int dstChannels)
{
	::cv::cvtColor(*this, rImage, code, dstChannels);
}

/**********************************************************************//**
 *
 * A^b`
 *
 -----------------------------------------------------------------------
 * @param [in]	pImage		= o^C[W
*//***********************************************************************/
void CCvImage::Attach(IplImage* pImage)
{
	IRIS_ASSERT( pImage != nullptr );
	//::cv::Mat mat = pImage;
	m_Mat = pImage;
	//cvReleaseImage(&pImage);
}

}	// end of namespace cv
}	// end of namespace gx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../../unit/UnitCore.h"
#include "../gui/CvWindow.h"
#include "../../../iris_using.h"
#include "../../../iris_iostream.h"
#include <stdio.h>
#include <tchar.h>

//======================================================================
// test
IRIS_UNITTEST(CCvImageUnitTest, CvImageUnitTest)
{
	CCvImage image, gray;
	CCvWindow window;
	CHAR path[MAX_PATH];
	std::cout << "Jt@C͂ĂB" << std::endl;
	std::cin >> path;

	if( !image.Load(path) ) return;
	window.Create("Show Image");
	image.TranslateColor(gray, CV_BGR2GRAY);
	window.ShowImage(gray);
	cvWaitKey();
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#endif
