//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FBXNode.h
 * @brief		FBX SDK nodeNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FBXNode_H_
#define INCG_IRIS_FBXNode_H_

//======================================================================
// include
#ifdef _IRIS_SUPPORT_FBX
#include "FBXObject.h"
#endif

#ifdef _IRIS_SUPPORT_FBX

namespace iris {
namespace gx {
namespace fbx
{

//======================================================================
// declare
class CFBXNode;								// m[hNX

//======================================================================
// function
// [hW̎擾
KFbxXMatrix GetGlobalPosition(KFbxNode* pNode, KTime& rTime, KFbxXMatrix* pParent=nullptr);
// [hW̎擾
KFbxXMatrix GetGlobalPosition(KFbxNode* pNode, KTime& rTime, KFbxPose* pPose, KFbxXMatrix* pParent=nullptr);
// WIg}gbNX̎擾
KFbxXMatrix GetGeometricMatrix(KFbxNode* pNode);

//======================================================================
// class
/// FBX SDK Node
class CFBXNode : public IFBXObjectBase<KFbxNode>
{
public:
	// RXgN^
	CFBXNode(void);
	// RXgN^
	CFBXNode(kfbx_ptr ptr);
	// RXgN^
	explicit CFBXNode(CFBXNode& obj);

	// fXgN^
	~CFBXNode(void);
public:
	/// 
	CFBXNode&	operator = (kfbx_ptr ptr)	{ m_pKfbx = ptr; return *this; }

public:
	KFbxXMatrix GetGlobalPosition(KTime& rTime, KFbxXMatrix* pParent=nullptr)	{ return fbx::GetGlobalPosition(m_pKfbx, rTime, pParent); }
	KFbxXMatrix GetGlobalPosition(KTime& rTime, KFbxPose* pPose, KFbxXMatrix* pParent=nullptr)	{ return fbx::GetGlobalPosition(m_pKfbx, rTime, pPose, pParent); }
	KFbxXMatrix GetGeometricMatrix(void)	{ return fbx::GetGeometricMatrix(m_pKfbx); }

public:
	// m[hAgr[ǧ
	KFbxNodeAttribute*	FindAttribute(KFbxNodeAttribute::EAttributeType Type);
	// m[hAgr[ǧ
	KFbxNodeAttribute*	FindAttribute(KFbxNodeAttribute* pPrevAttr
									, KFbxNodeAttribute::EAttributeType Type);
protected:
	// qm[h̃m[hAgr[ǧ
	KFbxNodeAttribute*	FindChildAttribute(KFbxNode* pCurrent
									, KFbxNodeAttribute::EAttributeType Type);
};

}	// end of namespace fbx
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
