//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		fbxsdkver.h
 * @brief		FBX SDK o[Wt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_fbxsdkver_H_
#define INCG_IRIS_fbxsdkver_H_

#ifdef _IRIS_SUPPORT_FBX

//======================================================================
// include
#ifndef FBXSDK_H
#include <fbxsdk.h>
#endif

//======================================================================
// define
// version
// namespace𗘗pĂ݂
#ifdef fbxsdk_200901
#  undef fbxsdk_200901
#endif

#ifdef fbxplugins_200901
#  undef fbxplugins_200901
#endif

#ifdef fbxsdk_200903
#  undef fbxsdk_200903
#endif

#ifdef fbxsdk_201002
#  undef fbxsdk_201002
#endif

#ifdef fbxsdk_2011_2
#  undef fbxsdk_2011_2
#endif

#define fbxsdk_200901		200901
#define fbxplugins_200901	fbxsdk_200901
#define fbxsdk_200903		200903
#define fbxsdk_201002		201002
#define fbxsdk_2011_2		201102
#define fbxsdk_2011_3		201103

#define FBXSDK_VER_200901	200901
#define FBXSDK_VER_200903	200903
#define FBXSDK_VER_201002	201002
#define FBXSDK_VER_201102	201102
#define FBXSDK_VER_201103	201103

// FBXSDK Version 
#ifdef FBXFILESDK_NAMESPACE_USE
#  if	(FBXFILESDK_NAMESPACE == FBXSDK_VER_200901)
#    define FBXSDK_VER			FBXSDK_VER_200901
#  elif	(FBXFILESDK_NAMESPACE == FBXSDK_VER_200903)
#    define FBXSDK_VER			FBXSDK_VER_200903
#  elif	(FBXFILESDK_NAMESPACE == FBXSDK_VER_201002)
#    define FBXSDK_VER			FBXSDK_VER_201002
#  elif	(FBXFILESDK_NAMESPACE == FBXSDK_VER_201102)
#    define FBXSDK_VER			FBXSDK_VER_201102
#  elif	(FBXFILESDK_NAMESPACE == FBXSDK_VER_201103)
#    define FBXSDK_VER			FBXSDK_VER_201103
#  else
#    define FBXSDK_VER			FBXSDK_VER_201102
#  endif
#else
#pragma IRIS_MSG_WARNING("ΉłĂȂ̂ōŐV")
#  define FBXSDK_VER			FBXSDK_VER_201102
#endif

#define	FBXSDK_AT_LEAST(ver)	(FBXSDK_VER >= ver)
#define	FBXSDK_AT_LESS(ver)		(FBXSDK_VER < ver)

#undef fbxsdk_200901
#undef fbxplugins_200901
#undef fbxsdk_200903
#undef fbxsdk_201002
#undef fbxsdk_2011_2
#undef fbxsdk_2011_3

#else

#define	FBXSDK_AT_LEAST(ver)	0
#define	FBXSDK_AT_LESS(ver)		0

#endif	// #ifdef _IRIS_SUPPORT_FBX

#endif	// #ifndef _IRIS_fbx_inchead_H_
