//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FBXMesh.h
 * @brief		FBX SDK meshNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FBXMesh_H_
#define INCG_IRIS_FBXMesh_H_

//======================================================================
// include
#ifdef _IRIS_SUPPORT_FBX
#include "../../../fnd/types/FndExecutor.h"
#include "../FBXAttribute.h"
#endif

#ifdef _IRIS_SUPPORT_FBX

namespace iris {
namespace gx {
namespace fbx
{

//======================================================================
// class
/// FBX SDK Mesh
class CFBXMesh : public IFBXAttribute<KFbxMesh>, public fnd::CExecutor
{
protected:
	KFbxVector4*	m_pVertex;	//!< _obt@
	KTime			m_Time;		//!< 
public:
	// RXgN^
	CFBXMesh(void);
	CFBXMesh(kfbx_ptr ptr);
	CFBXMesh(CFBXMesh& obj);
	// fXgN^
	virtual ~CFBXMesh(void);

public:
	// ֘At
	virtual bool	Attach(KFbxMesh* pMesh);
	// Ǎ
	virtual bool	Load(KFbxMesh* pMesh);
	// ēǂݍ
	virtual bool	Reload(void);
	// 
	virtual void	Release(void);

public:
	// XV
	virtual	void	Update(xf32 time);
	// `
	virtual	void	Draw(void);

public:
	// }eA̎擾
			int				GetMaterialNum(void) const;
	// }eA̎擾
	KFbxSurfaceMaterial*	GetMaterial(int idx) const;

protected:
	// LbVf[^璸_擾
			bool	ReadVertexCacheData(KTime& rTime);
	// `ftH[[V
			bool	ShapeDeformation(KTime& rTime);
	// NX^[ftH[[V
			bool	ClusterDeformation(KTime& rTime, KFbxPose* pPose=nullptr);
};


}	// end of namespace fbx
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
