//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FBXSkeleton.h
 * @brief		FBX SDK skeltonNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FBXSkeleton_H_
#define INCG_IRIS_FBXSkeleton_H_

//======================================================================
// include
#ifdef _IRIS_SUPPORT_FBX
#include "../../../fnd/types/FndExecutor.h"
#include "../FBXAttribute.h"
#endif

#ifdef _IRIS_SUPPORT_FBX

namespace iris {
namespace gx {
namespace fbx
{

//======================================================================
// class
/// FBX SDK Skeleton
class CFBXSkeleton : public IFBXAttribute<KFbxSkeleton>, public fnd::CExecutor
{
	typedef IFBXAttribute<KFbxSkeleton>	_Base;
	KTime			m_Time;		//!< 
public:
	// RXgN^
	CFBXSkeleton(void);
	CFBXSkeleton(kfbx_ptr ptr);
	CFBXSkeleton(CFBXSkeleton& obj);
	// fXgN^
	virtual ~CFBXSkeleton(void);

public:
	// XV
	virtual	void	Update(xf32 time);
	// `
	virtual	void	Draw(void);
};


}	// end of namespace fbx
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
