//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		GXGLExt.cpp
 * @brief		glextt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_GXGLExt_CPP_

//======================================================================
// include
#include "GXGLExt.h"
#include <string.h>

#if	defined(_IRIS_SUPPORT_OPENGL)

//======================================================================
// define
#ifdef _IRIS_DEBUG
#define IS_GXGLEW_SUPPORT_EXTENSION(val)	if( (val) == 0 ) do { IRIS_WARNING("glext " #val "is not support"); } while(0)
#else
#define IS_GXGLEW_SUPPORT_EXTENSION(val)	(void)(0)
#endif

namespace iris {
namespace gx {
namespace gl
{

//======================================================================
// function
/**********************************************************************//**
 *
 * glextpł邩ǂ
 * 
 -----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
bool gxglIsSupportEXT(void)
{
#if	defined(_IRIS_SUPPORT_OPENGL)
	if( glGetString(GL_EXTENSIONS) != nullptr ) return true;
#endif
	return false;
}

/**********************************************************************//**
 *
 * glext̎w@\pł邩ǂ
 * 
 -----------------------------------------------------------------------
 * @param [in]	pFunction	= @\
 * @return	^Ul
*//***********************************************************************/
bool gxglGetExtension(LPCSTR pFunction)
{
	return gxglewGetExtension(pFunction);
}

/**********************************************************************//**
 *
 * glext֐|C^̎擾
 * 
 -----------------------------------------------------------------------
 * @param [in]	pFunction	= @\
 * @return	֐|C^
*//***********************************************************************/
PROC gxglGetProcAddress(LPCSTR pFunction)
{
	return gxglewGetProcAddress(pFunction);
}

/**********************************************************************//**
 *
 * glext̏
 * 
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool gxglInitializeEXT(void)
{
	LPCSTR ext = reinterpret_cast<LPCSTR>(glGetString(GL_EXTENSIONS));
	if( ext == nullptr ) return false;
	return gxglewInit();
}

/**********************************************************************//**
 *
 * uhIy[^̐ݒ
 * 
 -----------------------------------------------------------------------
 * @return	T|[gĂ邩ǂ
*//***********************************************************************/
void gxglBlendEquationEXT(GLenum op)
{
	IS_GXGLEW_SUPPORT_EXTENSION(GLEW_EXT_blend_minmax);
	glBlendEquationEXT(op);
}

}	// end of namespace gl
}	// end of namespace gx
}	// end of namespace iris

#endif
