//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		GXGLProgram.h
 * @brief		GLSL VF[_[vOIuWFNgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_GXGLProgram_H_
#define INCG_IRIS_GXGLProgram_H_

//======================================================================
// include
#include "../../../iris_object.h"
#include "GXGLSL.h"

#if		defined(_IRIS_SUPPORT_OPENGL)

namespace iris {
namespace gx {
namespace gl
{

//======================================================================
// class
//! GLSL VF[_[IuWFNgNX
class CGLProgram : public INonCopyable<>
{
private:
	GLuint			m_Program;	//!< vOIuWFNg
public:
	// RXgN^
	CGLProgram(void);
	// fXgN^
	~CGLProgram(void);

public:
	/// IuWFNg̎擾Iy[^
	GLuint	operator ()(void)	{ return GetProgramObject(); }

public:
	// IuWFNg̍쐬
	bool	Create(void);
	// IuWFNg̍폜
	void	Delete(void);

public:
	// vO̎gp
	void	UseProgram(void);
	// Œ@\pCvC̎gp
	void	UseFixedFunction(void);
	// vO̎gpݒ
	void	Activate(bool bUse);
	// vOgpǂ
	bool	IsActive(void);

public:
	// VF[_[IuWFNg̓o^
	void	Attach(GLuint uShader);
	// VF[_[IuWFNg̓o^
	void	Detach(GLuint uShader);
	// N
	bool	Link(void);
	// O̎擾
	GLsizei	GetInfoLog(LPSTR pString, GLsizei nSize);

public:
	/// IuWFNg̎擾
	GLuint	GetProgramObject(void)	{ return m_Program; }

	/// ̎擾
	void	getiv(GLenum name, GLint* param)	{ glGetProgramiv(m_Program, name, param); }
};


}	// end of namespace gl
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
