//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_iostream.h
 * @brief		iostreamT|[gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_iostream_H_
#define INCG_IRIS_iris_iostream_H_

//======================================================================
// include
#include "iris_inchead.h"
#ifdef _IRIS_DEBUG
#include "iris_debug.h"
#endif

//======================================================================
// define
#ifdef UNICODE
#define tcout		wcout
#define tcerr		wcerr
#define tclog		wclog
#define tcin		wcin
#define tsafe_cin	sfae_wcin
#else
#define tcout		cout
#define tcerr		cerr
#define tclog		clog
#define tcin		cin
#define tsafe_cin	sfae_cin
#endif

#if defined(__cplusplus)
//======================================================================
// include
#ifndef _IRIS_NOT_SUPPORT_IOSTREAM
#include <stdio.h>
#include <iostream>
#include <iomanip>
#include <string>

#ifdef _IRIS_SUPPORT_SAFE_ISTREAM
#include <sstream>
namespace iris
{
//======================================================================
// declare
template<typename _Elem>class safe_baisc_istream;

//======================================================================
// typedef
typedef safe_baisc_istream<char>	safe_istream;	//!< Sistream
typedef safe_baisc_istream<wchar_t>	safe_wistream;	//!< Swistream
};

//======================================================================
// extern
namespace std
{
extern	::iris::safe_istream	safe_cin;	//!< Sistreamϐ
extern	::iris::safe_wistream	safe_wcin;	//!< Swistreamϐ
}	// end of namespace std

#else
#define safe_cin		cin
#define safe_wcin		wcin

#endif

//======================================================================
// define
// ֐`}N
#define IOSTREAM_FUNC_DEC_MBS(strm, op, type)	std::strm& operator op (std::strm&, const type&)
#if	IRIS_WCS
#  define IOSTREAM_FUNC_DEC_WCS(strm, op, type)	IOSTREAM_FUNC_DEC_MBS(w##strm, op, type)
#else
#  define IOSTREAM_FUNC_DEC_WCS(strm, op, type)	
#endif
#define IOSTREAM_FUNC_DEC(strm, op, type)		IOSTREAM_FUNC_DEC_WCS(strm, op, type); IOSTREAM_FUNC_DEC_MBS(strm, op, type)

//======================================================================
// function
IOSTREAM_FUNC_DEC(ostream, <<, IrisSRect);
IOSTREAM_FUNC_DEC(ostream, <<, IrisFRect);
IOSTREAM_FUNC_DEC(ostream, <<, IrisXFRect);
IOSTREAM_FUNC_DEC(ostream, <<, IrisIRect);
IOSTREAM_FUNC_DEC(ostream, <<, IrisRect);

IOSTREAM_FUNC_DEC(ostream, <<, IrisSVec2);
IOSTREAM_FUNC_DEC(ostream, <<, IrisFVec2);
IOSTREAM_FUNC_DEC(ostream, <<, IrisXFVec2);
IOSTREAM_FUNC_DEC(ostream, <<, IrisIVec2);
IOSTREAM_FUNC_DEC(ostream, <<, IrisVec2);

IOSTREAM_FUNC_DEC(ostream, <<, IrisSVec3);
IOSTREAM_FUNC_DEC(ostream, <<, IrisFVec3);
IOSTREAM_FUNC_DEC(ostream, <<, IrisXFVec3);
IOSTREAM_FUNC_DEC(ostream, <<, IrisIVec3);
IOSTREAM_FUNC_DEC(ostream, <<, IrisVec3);

IOSTREAM_FUNC_DEC(ostream, <<, IrisSVec4);
IOSTREAM_FUNC_DEC(ostream, <<, IrisFVec4);
IOSTREAM_FUNC_DEC(ostream, <<, IrisXFVec4);
IOSTREAM_FUNC_DEC(ostream, <<, IrisIVec4);
IOSTREAM_FUNC_DEC(ostream, <<, IrisVec4);

IOSTREAM_FUNC_DEC(ostream, <<, IrisFMtx22);
IOSTREAM_FUNC_DEC(ostream, <<, IrisXFMtx22);
IOSTREAM_FUNC_DEC(ostream, <<, IrisIMtx22);
IOSTREAM_FUNC_DEC(ostream, <<, IrisMtx22);

IOSTREAM_FUNC_DEC(ostream, <<, IrisFMtx33);
IOSTREAM_FUNC_DEC(ostream, <<, IrisXFMtx33);
IOSTREAM_FUNC_DEC(ostream, <<, IrisIMtx33);
IOSTREAM_FUNC_DEC(ostream, <<, IrisMtx33);

IOSTREAM_FUNC_DEC(ostream, <<, IrisFMtx43);
IOSTREAM_FUNC_DEC(ostream, <<, IrisXFMtx43);
IOSTREAM_FUNC_DEC(ostream, <<, IrisIMtx43);
IOSTREAM_FUNC_DEC(ostream, <<, IrisMtx43);

IOSTREAM_FUNC_DEC(ostream, <<, IrisFMtx44);
IOSTREAM_FUNC_DEC(ostream, <<, IrisXFMtx44);
IOSTREAM_FUNC_DEC(ostream, <<, IrisIMtx44);
IOSTREAM_FUNC_DEC(ostream, <<, IrisMtx44);

IOSTREAM_FUNC_DEC(ostream, <<, IrisFPlane);
IOSTREAM_FUNC_DEC(ostream, <<, IrisXFPlane);

IOSTREAM_FUNC_DEC(ostream, <<, IrisFColor);
IOSTREAM_FUNC_DEC(ostream, <<, IrisXFColor);

IOSTREAM_FUNC_DEC(ostream, <<, IrisFCMY);
IOSTREAM_FUNC_DEC(ostream, <<, IrisXFCMY);
IOSTREAM_FUNC_DEC(ostream, <<, IrisFCMYK);
IOSTREAM_FUNC_DEC(ostream, <<, IrisXFCMYK);
IOSTREAM_FUNC_DEC(ostream, <<, IrisFHSV);
IOSTREAM_FUNC_DEC(ostream, <<, IrisXFHSV);

IOSTREAM_FUNC_DEC(ostream, <<, IrisFComplex);
IOSTREAM_FUNC_DEC(ostream, <<, IrisXFComplex);

IOSTREAM_FUNC_DEC(ostream, <<, IrisFInt);
IOSTREAM_FUNC_DEC(ostream, <<, IrisXFInt);

IOSTREAM_FUNC_DEC(ostream, <<, IrisVaugeBool);


#ifdef _IRIS_HAS_NULLPTR_T
IOSTREAM_FUNC_DEC(ostream, <<, nullptr_t);
#endif


#undef IOSTREAM_FUNC_DEC_MBS
#undef IOSTREAM_FUNC_DEC_WCS
#undef IOSTREAM_FUNC_DEC

//======================================================================
// inline
#if	!(defined(__INTEL_COMPILER) || IRIS_MSC_AT_LESS(_MSC_VER_VC8))
/// 
template<size_t _Size>
STATICINLINE std::istream& operator >> (std::istream& in, char (&pstr)[_Size])
{
	std::string str;
	in >> str;
	strcpy_s(pstr, _Size, str.c_str());
	return in;
}
/// 
template<size_t _Size>
STATICINLINE std::wistream& operator >> (std::wistream& in, wchar_t (&pstr)[_Size])
{
	std::wstring str;
	in >> str;
	wcscpy_s(pstr, _Size, str.c_str());
	return in;
}
#endif
#if		defined(__MWERKS__)
/// 
STATICINLINE std::istream& operator >> (std::istream& in, char* str)
{
	in >> (IrisS8*)str;
	return in;
}
#endif

#ifdef _IRIS_SUPPORT_SAFE_ISTREAM
namespace iris
{

//======================================================================
// class
// Sȓ̓Xg[
template<typename _Elem>
class safe_baisc_istream
{
	typedef safe_baisc_istream<_Elem>		_Myt;
	typedef std::char_traits<_Elem>			_Traits;
	typedef std::allocator<_Elem>			_Allocator;
	typedef typename std::basic_streambuf<_Elem, _Traits>					_Mysb;
	typedef typename std::basic_ios<_Elem,  _Traits>						_Myios;
	typedef typename std::basic_istream<_Elem,  _Traits>					_Myis;
	typedef typename std::basic_ostream<_Elem,  _Traits>					_Myos;
	typedef typename std::basic_string<_Elem, _Traits, _Allocator>			_Mystr;
	typedef typename std::basic_istringstream< _Elem, _Traits, _Allocator>	_Myiss;

	typedef typename _Traits::int_type	int_type;
	typedef typename _Traits::pos_type	pos_type;
	typedef typename _Traits::off_type	off_type;

#ifdef INCG_IRIS_iris_iostream_CPP_
public:
#endif
	safe_baisc_istream(void) {}

public:
	template<size_t _Size>
	_Myt&	operator >> (_Elem (&_Str)[_Size])
	{
		_Mystr str;
		_Myis& istrm = _in();
		istrm.clear();
		istrm >> str;
		_strcpy(_Str, _Size, str.c_str());
#ifdef _IRIS_DEBUG
		if( istrm.rdstate() & ~_Myis::eofbit ) IRIS_ERRORWARNING(istrm.rdstate(), "error state");
#endif
		return *this;
	}

	template<typename _Type>
	_Myt&		operator >> (_Type& _Val)
	{
		_Myis& istrm = _in();
		while(1)
		{
			istrm.clear();
#if 1
			_Mystr str;
			istrm >> str;
			_Myiss is(str);
			is.copyfmt(istrm);
			is >> _Val;
			istrm.setstate(is.rdstate());
#else
			istrm >> _Val;
			if( !istrm ) istrm.ignore(INT_MAX, '\n');
#endif
			if( !istrm.fail() ) break;
			printf("istream failed. try again.\n");
		}
#ifdef _IRIS_DEBUG
		if( istrm.rdstate() & ~_Myis::eofbit ) IRIS_ERRORWARNING(istrm.rdstate(), "error state");
#endif
		return *this;
	}

	template<typename _Type, size_t _Size>
	_Myt&	operator >> (_Type (&_Val)[_Size])
	{
		size_t n = 0;
		_Myis& istrm = _in();
		istrm.clear();
		while(n < _Size)
		{
			_Mystr str, tmp;
			istrm >> str;
			_Myiss is(str);
			is.copyfmt(istrm);
			is >> _Val[n];
			if( is.fail() ) 
			{
				printf("istream failed. try again.\n");
				continue;
			}
			++n;
		}
#ifdef _IRIS_DEBUG
		if( istrm.rdstate() & ~_Myis::eofbit ) IRIS_ERRORWARNING(istrm.rdstate(), "error state");
#endif
		return *this;
	}

	_Myt&		operator >> (_Myis& (__cdecl *_Pfn)(_Myis&)) 
	{
		_in() >> _Pfn; return *this; 
	}
	_Myt&		operator >> (_Myios& (__cdecl *_Pfn)(_Myios&))
	{
		_in() >> _Pfn; return *this; 
	}
	_Myt&		operator >> (std::ios_base& (__cdecl *_Pfn)(std::ios_base&))
	{
		_in() >> _Pfn; return *this; 
	}
	bool		operator !(void) const			{ return fail(); }

public:
	int				rdstate(void) const					{ return _in().rdstate(); }
	bool			good(void) const					{ return _in().good(); }
	bool			eof(void) const						{ return _in().eof(); }
	bool			fail(void) const					{ return _in().fail(); }
	bool			bad(void) const						{ return _in().bad(); }
	int				exceptions(void) const				{ return _in().exceptions(); }
	void			exceptions(int _Newexcept)			{ _in().exceptions(_Newexcept); }
	void			exceptions(unsigned int _Newexcept)	{ _in().exceptions(_Newexcept); }
	int				flags(void) const					{ return _in().flags(); }
	int				flags(int _Newfmtflags)				{ return _in().flags(_Newfmtflags); }
	int				setf(int _Newfmtflags)				{ return _in().setf(_Newfmtflags); }
	int				setf(int _Newfmtflags, int _Mask)	{ return _in().setf(_Newfmtflags, _Mask); }
	void			unsetf(int _Mask)					{ _in().unsetf(_Mask); }
	std::streamsize	precision(void) const				{ return _in().precision(); }
	std::streamsize	precision(int _Newprecision)		{ return _in().precision(_Newprecision); }
	std::streamsize	width(void) const					{ return _in().width(); }
	std::streamsize	width(int _Newwidth)				{ return _in().width(_Newwidth); }
	std::locale		getloc(void) const					{ return _in().getloc(); }
	std::locale		imbue(const std::locale& _Loc)		{ return _in().imbue(_Loc); }
	long&			iword(int _Idx)						{ return _in().iword(_Idx); }
	void*&			pword(int _Idx)						{ return _in().pword(_Idx); }
	void			register_callback(std::ios_base::event_callback _Pfn, int _Idx)	{ _in().register_callback(_Pfn, _Idx); }
	_Myt&			copyfmt(_Myios& _Right)				{ _in().copyfmt(_Right); return *this; }
	_Myt&			copyfmt(_Myt& _Right)				{ return copyfmt(_Right._in()); }

public:
	void		clear(int _State = _Myios::goodbit, bool _Reraise = false)
	{
		_in().clear(_State, _Reraise);
	}
	void		clear(unsigned int _State)
	{
		_in().clear(_State);
	}
	void		setstate(int _State = _Myios::goodbit, bool _Reraise = false)
	{
		_in().setstate(_State, _Reraise);
	}
	void		setstate(unsigned int _State)
	{
		_in().setstate(_State);
	}
	_Myos*		tie(void) const			{ return _in().tie(); }
	_Myos*		tie(_Myos* _Newtie)		{ return _in().tie(_Newtie); }
	_Mysb*		rdbuf(void) const		{ return _in().rdbuf(); }
	_Mysb*		rdbuf(_Mysb* _Strbuf) 	{ return _in().rdbuf(_Strbuf); }
	_Elem		fill(void) const		{ return _in().fill(); }
	_Elem		fill(_Elem _Newfill)	{ return _in().fill(_Newfill); }
	char		narrow(_Elem _Ch, char _Dflt = '\0') const
	{
		return _in().narrow(_Ch, _Dflt);
	}
	_Elem		widen(char _Byte) const	{ return _in().widen(_Byte); }

public:
	bool		_Ipfx(bool _Noskip = false)	{ return _in()._Ipfx(_Noskip); }
	bool		ipfx(bool _Noskip = false)	{ return _in().ipfx(_Noskip); }
	void		isfx(void)					{ _in().isfx(); }

	int_type	get(void)					{ return _in().get(); }
	_Myt&		get(_Elem* _Str, int _Count)		{ _in().get(_Str, _Count); return *this; }
	_Myt&		get(_Elem* _Str, int _Count, _Elem _Delim)	{ _in().get(_Str, _Count, _Delim); return *this; }
	_Myt&		get(_Elem& _Ch)				{ _in().get(_Ch); return *this; }
	_Myt&		get(_Mysb& _Strbuf)			{ _in().get(_Strbuf); return *this; }
	_Myt&		get(_Mysb& _Strbuf, _Elem _Delim)	{ _in().get(_Strbuf, _Delim); return *this; }

	_Myt&		getline(_Elem* _Str, int _Count)	{ _in().getline(_Str, _Count); return *this; }
	_Myt&		getline(_Elem* _Str, int _Count, _Elem _Delim)	{ _in().getline(_Str, _Count, _Delim); return *this; }

	_Myt&		ignore(int _Count = -1, int_type _Metadelim = _Traits::eof())
	{
		_in().ignore(_Count, _Metadelim); return *this;
	}
	_Myt&		_Read_s(_Elem* _Str, size_t _Size, int _Count)
	{
#if	IRIS_MSC_AT_LEAST(_MSC_VER_VC8) && IRIS_MSC_AT_LESS(_MSC_VER_VC10)
		_in()._Read_s(_Str, _Size, _Count); return *this;
#else
		read(_Str, _Count);	return *this;
#endif
	}
	_Myt&		read(_Elem* _Str, int _Count)
	{
		_in().read(_Str, _Count); return *this;
	}
	template<size_t _Size>
	_Myt&		read(_Elem (&_Str)[_Size], int _Count)
	{
		return _Read_s(_Str, _Size, _Count);
	}
	std::streamsize		_Readsome_s(_Elem* _Str, size_t _Size, int _Count)
	{
#if	IRIS_MSC_AT_LEAST(_MSC_VER_VC8) && IRIS_MSC_AT_LESS(_MSC_VER_VC10)
		return _in()._Readsome_s(_Str, _Size, _Count);
#else
		return readsome(_Str, _Count);
#endif
	}
	std::streamsize		readsome(_Elem* _Str, int _Count)
	{
		IRIS_PRAGMA_WARNING_DISABLE(4996)
		return _in().readsome(_Str, _Count);
		IRIS_PRAGMA_WARNING_DEFAULT(4996)
	}
	template<size_t _Size>
	int			readsome(_Elem (&_Str)[_Size], int _Count)
	{
		return _in()._Readsome_s(_Str, _Size, _Count);
	}
	int_type			peek(void)				{ return _in().peek(); }
	_Myt&				putback(_Elem _Ch)		{ _in().putback(_Ch); return *this; }
	_Myt&				unget(void)				{ _in().unget(); return *this; }
	std::streamsize		gcount(void) const		{ return _in().gcount(); }
	std::streamsize		sync(void)				{ return _in().sync(); }
	_Myt&				seekg(pos_type _Pos)	{ _in().seekg(_Pos); return *this; }
	_Myt&				seekg(off_type _Off, std::ios_base::seekdir _Way)
	{
		_in().seekg(_Off, _Way); return *this;
	}
	pos_type	tellg(void)				{ return _in().tellg(); }

private:
	_Myis&		_in(void);
	_Myis&		_in(void) const;
	void		_strcpy(_Elem* dst, size_t size, const _Elem* src);
};

}	// end of namespace

#endif

#endif	// #ifndef _IRIS_NOT_SUPPORT_IOSTREAM

#endif	// #if defined(__cplusplus)

#endif
