//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_language_ex.h
 * @brief		g@\ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_language_ex_H_
#define INCG_IRIS_iris_language_ex_H_

//======================================================================
// include
#if		defined(__IAR_SYSTEMS_ICC__)
#define	IAR_LANGUAGE_EXTENDED	1

#pragma language=save
#pragma language=extended

#define __IAR_REG8(NAME, ADDRESS, ATTRIBUTE)              \
					volatile __no_init ATTRIBUTE unsigned char NAME @ ADDRESS

#define __IAR_REG16(NAME, ADDRESS, ATTRIBUTE)             \
					volatile __no_init ATTRIBUTE unsigned short NAME @ ADDRESS

#define __IAR_REG32(NAME, ADDRESS, ATTRIBUTE)             \
					volatile __no_init ATTRIBUTE unsigned long NAME @ ADDRESS


#define __IAR_REG8_BIT(NAME, ADDRESS, ATTRIBUTE, BIT_STRUCT)				\
						volatile __no_init ATTRIBUTE union		\
						{													\
							unsigned char NAME;								\
							BIT_STRUCT NAME ## _bit;						\
						} @ ADDRESS

#define __IAR_REG16_BIT(NAME, ADDRESS, ATTRIBUTE,BIT_STRUCT)				\
						volatile __no_init ATTRIBUTE union		\
						{													\
							unsigned short NAME;							\
							BIT_STRUCT NAME ## _bit;						\
						} @ ADDRESS

#define __IAR_REG32_BIT(NAME, ADDRESS, ATTRIBUTE, BIT_STRUCT)				\
						volatile __no_init ATTRIBUTE union		\
						{													\
							unsigned long NAME;								\
							BIT_STRUCT NAME ## _bit;						\
						} @ ADDRESS

#pragma language=restore

#else

#if	defined(__cplus_plus)
#  define	IAR_LANGUAGE_EXTENDED	0
#  define __IAR_REG8(NAME, ADDRESS, ATTRIBUTE)									\
					static volatile ATTRIBUTE unsigned char* p ## NAME	= (volatile unsigned char*)ADDRESS;			\
					static volatile unsigned char& NAME			= *p ## NAME
#  define __IAR_REG16(NAME, ADDRESS, ATTRIBUTE)									\
					static volatile ATTRIBUTE unsigned short* p ## NAME	= (volatile unsigned short*)ADDRESS;		\
					static volatile unsigned short& NAME		= *p##NAME
#  define __IAR_REG32(NAME, ADDRESS, ATTRIBUTE)									\
					static volatile ATTRIBUTE unsigned long* p ## NAME	= (volatile unsigned long*)ADDRESS;			\
					static volatile unsigned long& NAME			= *p ## NAME
#  define __IAR_REG8_BIT(NAME, ADDRESS, ATTRIBUTE, BIT_STRUCT)					\
					__IAR_REG8(NAME, ADDRESS, ATTRIBUTE);						\
					static volatile BIT_STRUCT&	NAME##_bit	= *(BIT_STRUCT*)(ADDRESS)
#  define __IAR_REG16_BIT(NAME, ADDRESS, ATTRIBUTE,BIT_STRUCT)					\
					__IAR_REG16(NAME, ADDRESS, ATTRIBUTE);						\
					static volatile BIT_STRUCT&	NAME##_bit	= *(BIT_STRUCT*)(ADDRESS)
#  define __IAR_REG32_BIT(NAME, ADDRESS, ATTRIBUTE, BIT_STRUCT)					\
					__IAR_REG32(NAME, ADDRESS, ATTRIBUTE);						\
					static volatile BIT_STRUCT&	NAME##_bit	= *(BIT_STRUCT*)(ADDRESS)
#else
#  define	IAR_LANGUAGE_EXTENDED	0
#  define __IAR_REG8(NAME, ADDRESS, ATTRIBUTE)									\
					static volatile ATTRIBUTE unsigned char* p ## NAME	= (volatile unsigned char*)ADDRESS
#  define __IAR_REG16(NAME, ADDRESS, ATTRIBUTE)									\
					static volatile ATTRIBUTE unsigned short* p ## NAME	= (volatile unsigned short*)ADDRESS
#  define __IAR_REG32(NAME, ADDRESS, ATTRIBUTE)									\
					static volatile ATTRIBUTE unsigned long* p ## NAME	= (volatile unsigned long*)ADDRESS
#  define __IAR_REG8_BIT(NAME, ADDRESS, ATTRIBUTE, BIT_STRUCT)					\
					__IAR_REG8(NAME, ADDRESS, ATTRIBUTE)
#  define __IAR_REG16_BIT(NAME, ADDRESS, ATTRIBUTE,BIT_STRUCT)					\
					__IAR_REG16(NAME, ADDRESS, ATTRIBUTE)
#  define __IAR_REG32_BIT(NAME, ADDRESS, ATTRIBUTE, BIT_STRUCT)					\
					__IAR_REG32(NAME, ADDRESS, ATTRIBUTE)
#endif

#endif

#endif
