//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_main.c
 * @brief		iris Ct@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_iris_main_C_

//======================================================================
// include
#include "iris_main.h"
#include "iris_inchead.h"
#include "iris_global.h"

#include <stdio.h>

EXTERN_C_BEGIN

//======================================================================
// linker
#if defined(_IRIS_NODEFAULTLIB)
#  if	defined(_WIN32) && defined(_MT)
#    ifdef	_DLL
#      ifdef _DEBUG
#        pragma comment( linker, "/NODEFAULTLIB:LIBCMTD.lib" )
#      else
#        pragma comment( linker, "/NODEFAULTLIB:LIBCMT.lib" )
#      endif
#    else
#      ifdef _DEBUG
#        pragma comment( linker, "/NODEFAULTLIB:MSVCRTD.lib" )
#      else
#        pragma comment( linker, "/NODEFAULTLIB:MSVCRT.lib" )
#      endif
#    endif
#  endif
#endif

//======================================================================
// using
#if defined(__cplusplus)
using namespace iris;
#endif

#if		defined(IRIS_MSC)
IRIS_PRAGMA_MESSAGE("Microsoft Compiler.");
#elif	defined(IRIS_MWERKS)
IRIS_PRAGMA_MESSAGE("Metroworks Compiler.");
#elif	defined(IRIS_GNUC)
IRIS_PRAGMA_MESSAGE("GNU Compiler.");
#elif	defined(IRIS_EDG)
#else
#endif

#if	(defined(_IRIS_SUPPORT_GOOGLETEST) || defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
//! iris unit test entory point.
EXTERN_C int Iris_UnitTest_Main(void);
#endif

//======================================================================
// define
#if (!defined(_IRIS_UNITTEST) && !defined(_IRIS_MULTI_UNITTEST) )
#define	IRIS_MAIN		iris_main
#else
#define IRIS_MAIN		Iris_UnitTest_Main
#endif

//======================================================================
// function

#if		!defined(_IRIS_SUPPORT_EXT_PLATFORM)

#if		defined(IRIS_WIN32)	// for Windows

#include <windows.h>
#include <stdlib.h>
#include <tchar.h>
#if		defined(_CONSOLE)
int _tmain( int argc, LPTSTR argv[] )
{
	__g_EntryInfo.uTarget = TARGET_WINCONSOLE;
#elif	defined(_USRDLL)
BOOL APIENTRY DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID lpReserved)
{
	__g_EntryInfo.uTarget		= TARGET_WINDLL;
	__g_EntryInfo.hInstance		= hInstance;
	__g_EntryInfo.dwReason		= dwReason;
	__g_EntryInfo.lpReserved	= lpReserved;
#if	defined(_IRIS_SUPPORT_MFC)
	// MFC āAG[̏ꍇ͌ʂ܂B
	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		return 1;
	}
#endif
#else
int WINAPI _tWinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nShowCmd)
{
	__g_EntryInfo.uTarget		= TARGET_WIN32;
	__g_EntryInfo.hInstance		= hInstance;
	__g_EntryInfo.hPrevInstance	= hPrevInstance;
	__g_EntryInfo.lpCmdLine		= lpCmdLine;
	__g_EntryInfo.nShowCmd		= nShowCmd;
#endif
	return IRIS_MAIN();
}
#elif	defined(IRIS_IPHONE)

int main(int argc, char *argv[]) 
{
	__g_EntryInfo.uTarget = TARGET_IPHONE;
    return IRIS_MAIN();
}

#elif	defined(IRIS_MAC)

int main(int argc, char *argv[]) 
{
	__g_EntryInfo.uTarget = TARGET_MAC;
    return IRIS_MAIN();
}

#elif	defined(IRIS_IAR_SYSTEM)

int main( int argc, char* argv[] )
{
	__g_EntryInfo.uTarget = TARGET_STM32;
	return IRIS_MAIN();
}

#else

int main( int argc, char* argv[] )
{
	__g_EntryInfo.uTarget = TARGET_UNKNOWN;
	return IRIS_MAIN();
}

#endif

#endif

EXTERN_C_END

