//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_platform.h
 * @brief		vbgtH[ʒ`ACN[ht@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_platform_H_
#define INCG_IRIS_iris_platform_H_

//======================================================================
// include
#if	defined(_IRIS_SUPPORT_EXT_PLATFORM)
#  include "iris_ext_platform.h"
#endif

//======================================================================
// define
#if		defined(_WIN32)	|| defined(_WIN32_WCE)	// for windows
#  define IRIS_WIN32
#  ifdef _WIN32_WCE
#    define IRIS_WIN32_WCE
#    if		defined(WIN32_PLATFORM_PSPC)
#      define IRIS_WIN32_PSPC	// pocket pc
#    elif	defined(WIN32_PLATFORM_WFPC)
#      define IRIS_WIN32_WFPC	// smartphone
#    endif
#  endif
#  ifdef _WIN64
#    define IRIS_WIN64
#  endif
#elif	defined(linux) || defined(__linux) || defined(__linux__)
#  define IRIS_LINUX		//!< linux
#elif	defined(__FreeBSD__) || defined(__NetBSD__) || defined(__OpenBSD__) || defined(__DragonFly__)
#  define IRIS_BSD			//!< BSD
#elif	defined(sun) || defined(__sun)
#  define IRIS_SOLARIS		//!< solaris
#elif	defined(__CYGWIN__)
#  define IRIS_CYGWIN		//!< cygwin
#elif	defined(__APPLE__) || defined(__APPLE_CC__) || defined(__MACH__) || defined(__MACOS_CLASSIC__)
#  define IRIS_APPLE		//!< apple
#  import	"TargetConditionals.h"
#  if	(defined(TARGET_OS_IPHONE) && TARGET_OS_IPHONE)
#    define IRIS_IPHONE		//!< iPhone
#  elif	(defined(TARGET_OS_MAC) && TARGET_OS_MAC)
#    define IRIS_MAC		//!< mac os
#  endif
#elif	defined(__TID__)
#  if	(((__TID__ >> 8) & 0x7F) == 0x4F)
#    define IRIS_AARM		//!< ASM ARM
#  endif
#endif

//======================================================================
// include
#if		defined(IRIS_WIN32)		// for windows
#  define NOMINMAX	// min, max }N`Ȃ
#  if		defined(_IRIS_SUPPORT_MFC) && !defined(_MFC_VER) && defined(__cplusplus)
#    include <afxwin.h>         // MFC ̃RAѕWR|[lg
#  endif
#  include <windows.h>
#  if		defined(IRIS_WIN32_WCE)
#    include <altcecrt.h>
#    include <kfuncs.h>
#  endif
#elif	defined(IRIS_IPHONE)	// for iPhone
#  include <stdio.h>
#  include <stdlib.h>
#  include <stdarg.h>
#  include <inttypes.h>
#  include <objc/objc.h>
#elif	defined(IRIS_MAC)		// for Mac
#  include <stdio.h>
#  include <stdlib.h>
#  include <stdarg.h>
#  include <inttypes.h>
#  include <objc/objc.h>
#elif	defined(IRIS_AARM)		// for ARM
#  include <stdio.h>
#elif	!defined(_IRIS_SUPPORT_EXT_PLATFORM)
#  include <stdio.h>
#endif

#endif
