//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_pragma.h
 * @brief		pragma t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_pragma_H_
#define INCG_IRIS_iris_pragma_H_

//======================================================================
// include
#include "iris_compiler.h"
#include "iris_declspec.h"

//======================================================================
// define 
#define VALID_PRAGMA(_code, option)			pragma _code option
#define INVALID_PRAGMA(_code, option)		define _code

// optimize
#if		defined(_MSC_VER)
#  define IRIS_OPTIMIZE_ON(opt)			optimize (opt, on)
#  define IRIS_OPTIMIZE_OFF(opt)		optimize (opt, off)
#else
#  define IRIS_OPTIMIZE_ON(opt)			
#  define IRIS_OPTIMIZE_OFF(opt)		
#endif

// auto_inline
#if		defined(_MSC_VER) && !defined(__INTEL_COMPILER)
#  define IRIS_AUTO_INLINE_ON()			auto_inline	(on)
#  define IRIS_AUTO_INLINE_OFF()		auto_inline	(off)
#else
#  define IRIS_AUTO_INLINE_ON()	
#  define IRIS_AUTO_INLINE_OFF()	
#endif

// inline_depth
#if		defined(_MSC_VER) && !defined(__INTEL_COMPILER)
#  define IRIS_INLINE_DEPTH(n)			inline_depth (n)
#else
#  define IRIS_INLINE_DEPTH(n)
#endif

// inline_recursion
#if		defined(_MSC_VER) && !defined(__INTEL_COMPILER)
#  define IRIS_INLINE_RECURSION_ON()	inline_recursion (on)
#  define IRIS_INLINE_RECURSION_OFF()	inline_recursion (off)
#else
#  define IRIS_INLINE_RECURSION_ON()
#  define IRIS_INLINE_RECURSION_OFF()
#endif


// mark
#if		defined(IRIS_APPLE) && !defined(IRIS_MWERKS)	// Xcode ?
#  define IRIS_PRAGMA_MARK(comment)		mark comment
#else
#  define IRIS_PRAGMA_MARK(comment)
#endif

//======================================================================
// _Pragma PZqgp^Cv

// #pragma message 
#if	defined(IRIS_EDG)
#  define IRIS_PRAGMA_MESSAGE(x)				
#else
#  define IRIS_PRAGMA_MESSAGE(x)				__Pragma(message ( x ))
#endif
#define IRIS_PRAGMA_MSG_TODO(x)				IRIS_PRAGMA_MESSAGE(__FILE__ "(" IRIS_PP_TOSTRING(__LINE__) "): TODO    : " x )
#define IRIS_PRAGMA_MSG_WARNING(msg)		IRIS_PRAGMA_MESSAGE(__FILE__ "(" IRIS_PP_TOSTRING(__LINE__) "): WARNING : " msg )

// #pragma warning
#if		defined(IRIS_MSC)
#  define IRIS_PRAGMA_WARNING_BEGIN()			__Pragma( warning (push) )
#  define IRIS_PRAGMA_WARNING_DISABLE(w_code)	__Pragma( warning (disable: w_code) )
#  define IRIS_PRAGMA_WARNING_DEFAULT(w_code)	__Pragma( warning (default: w_code) )
#  define IRIS_PRAGMA_WARNING_END()				__Pragma( warning (pop) )
#else
#  define IRIS_PRAGMA_WARNING_BEGIN()			// empty
#  define IRIS_PRAGMA_WARNING_DISABLE(w_code)	// empty
#  define IRIS_PRAGMA_WARNING_DEFAULT(w_code)	// empty
#  define IRIS_PRAGMA_WARNING_END()				// empty
#endif

// #pragma	push_macro
#if		defined(IRIS_MSC)
#  define IRIS_PRAGMA_PUSH_MACRO(macro)			__Pragma( push_macro (#macro) )
#  define IRIS_PRAGMA_POP_MACRO(macro)			__Pragma( pop_macro (#macro) )
#else
#  define IRIS_PRAGMA_PUSH_MACRO(macro)			// empty
#  define IRIS_PRAGMA_POP_MACRO(macro)			// empty
#endif

// #pragma intrinsic
#if		defined(IRIS_MSC)
#  define IRIS_PRAGMA_INTRINSIC_BEGIN(itr)		__Pragma( intrinsic (itr) )
#  define IRIS_PRAGMA_INTRINSIC_END(itr)		__Pragma( function (itr) )
#else
#  define IRIS_PRAGMA_INTRINSIC_BEGIN(itr)				// empty
#  define IRIS_PRAGMA_INTRINSIC_END(itr)				// empty
#endif

#if		defined(IRIS_MSC)
#  define IRIS_PRAGMA_DEPRECATE(x)				__Pragma( deprecated(x) )
#else
#  define IRIS_PRAGMA_DEPRECATE(x)				// empty
#endif

#endif
