//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_securelib.h
 * @brief		SECURE_LIB Ή֐t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_securelib_H_
#define INCG_IRIS_iris_securelib_H_

//======================================================================
// include
#include "iris_compiler.h"

// crt ZLeBΉ
#if !(defined(__STDC_WANT_SECURE_LIB__) && __STDC_WANT_SECURE_LIB__) || defined(IRIS_WIN32_WCE)

#define _vsnprintf_s(dst, size, cnt, src, va)	vsnprintf(dst, size, src, va)

#if !defined(IRIS_BORLANDC)

#define strtok_s(src, delim, context)			((void)(context), strtok(src, delim))
#define _strrev(src)							strrev(src)
#define vsnprintf_s(dst, size, cnt, src, va)	((void)(cnt), vsnprintf(dst, size, src, va))
#define fopen_s(fp, path, mode)					*(fp) = fopen(path,  mode)
#define freopen_s(fp, path, mode, old)			*(fp) = freopen(path,  mode,  old)
#define localtime_s(tm, time)					*(tm) = *localtime(time)

#define vsprintf_s(dst, size, fmt, va)			((void)(size), vsprintf(dst, fmt, va))
#ifndef vswprintf_s
#  if	defined(IRIS_MSC)
#    define vswprintf_s(dst, size, fmt, va)			vswprintf(dst, fmt, va)
#  else
#    define vswprintf_s(dst, size, fmt, va)			vswprintf(dst, size, fmt, va)
#  endif
#endif
#define _vsnwprintf_s(dst, size, cnt, src, va)	((void)(cnt), _vsnwprintf(dst, size, src, va))
#define _wfopen_s(fp, path, mode)				*fp = _wfopen(path,  mode)

#define	wcstombs_s(ret, mb, mbsize, wc, wcsize)	((void)(ret), ((void)(mbsize), wcstombs(mb, wc, wcsize)))
#define	mbstowcs_s(ret, wc, wcsize, mb, mbsize)	((void)(ret), ((void)(wcsize), mbstowcs(wc, mb, mbsize)))
#define	wctomb_s(ret, mb, mbsize, wc)			((void)(ret), ((void)(mbsize), wctomb(mb, wc)))

#define	_gcvt_s(dst, size, val, digit)			((void)(size), _gcvt(val, digit, dst))

// __VA_ARGS__gp}N
#if		IRIS_STDC_VA_ARGS
#  ifndef sprintf_s
#    define sprintf_s(src, size, format, ...)		((void)(size), sprintf(src, format, __VA_ARGS__))
#  endif
#  ifndef swprintf_s
#    define swprintf_s(src, size, format, ...)		((void)(size), swprintf(src, format, __VA_ARGS__))
#  endif
#define fprintf_s(fp, format, ...)				fprintf(fp, format, __VA_ARGS__)
#define fwprintf_s(fp, format, ...)				fwprintf(fp, format, __VA_ARGS__)
#endif

#endif

#endif

#endif
