//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_types.h
 * @brief		iris ^`wb_
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_types_H_
#define INCG_IRIS_iris_types_H_

//======================================================================
// include
#include "iris_platform.h" 
#include "iris_config.h"
#include "iris_xf.h"				// xf32, xf64 macro

//======================================================================
// declare
// rect
struct IrisSRect;
struct IrisUSRect;
struct IrisFRect;
struct IrisXFRect;
struct IrisIRect;
union IrisRect;

// vec2
struct IrisSVec2;
struct IrisFVec2;
struct IrisXFVec2;
struct IrisIVec2;
union  IrisVec2;

// vec3
struct IrisSVec3;
struct IrisFVec3;
struct IrisXFVec3;
struct IrisIVec3;
union  IrisVec3;

// vec4
struct IrisSVec4;
struct IrisFVec4;
struct IrisXFVec4;
struct IrisIVec4;
union  IrisVec4;

// matrix 22
union IrisFMtx22;
union IrisXFMtx22;
union IrisIMtx22;
union IrisMtx22;

// matrix 33
union IrisFMtx33;
union IrisXFMtx33;
union IrisIMtx33;
union IrisMtx33;

// matrix 43
union IrisFMtx43;
union IrisXFMtx43;
union IrisIMtx43;
union IrisMtx43;

// matrix 44
union IrisFMtx44;
union IrisXFMtx44;
union IrisIMtx44;
union IrisMtx44;

struct IrisFPlane;
struct IrisXFPlane;

// color
struct IrisFColor;
struct IrisXFColor;
union  IrisRGBA8888;
union  IrisRGBA4444;
union  IrisRGBA555;
union  IrisRGBA5551;
union  IrisRGB565;
union  IrisARGB8888;
struct IrisBGR888;
union  IrisBGRA555;
union  IrisRGBQUAD;

struct IrisFCMY;
struct IrisXFCMY;
struct IrisFCMYK;
struct IrisXFCMYK;
struct IrisFHSV;
struct IrisXFHSV;

struct IrisFComplex;
struct IrisXFComplex;

union  IrisFInt;
union  IrisXFInt;

union  IrisW128;

union  IrisUnion32;
union  IrisUnion64;
union  IrisUnion128;

struct IrisEntryInfo;

//======================================================================
// typedef
#ifndef	IRIS_BOOL_DEC
#define IRIS_BOOL_DEC
typedef int		BOOL;
#endif

//======================================================================
// define
#ifndef _W64
#define _W64
#endif

#ifndef FALSE
#define FALSE	0
#endif

#ifndef TRUE
#define TRUE	1
#endif

//======================================================================
// typedef
#if	defined(IRIS_MFC_VER)
#  ifndef FOURCC
typedef DWORD				FOURCC;
#  endif
#endif
#if	IRIS_MSC_AT_LESS(1400) || !defined(IRIS_WIN32)
typedef int errno_t;
#endif

typedef int					IrisInt;
typedef signed int			IrisSInt;
typedef unsigned int		IrisUInt;

typedef long				IrisLong;
typedef signed long			IrisSLong;
typedef unsigned long		IrisULong;

typedef char				IrisC8;
typedef signed char			IrisS8;
typedef unsigned char		IrisU8;

typedef signed short		IrisS16;
typedef unsigned short		IrisU16;

#if	(ULONG_MAX == 0xFFFFFFFFUL)
typedef signed long			IrisS32;
typedef unsigned long		IrisU32;
#else
typedef signed int			IrisS32;
typedef unsigned int		IrisU32;
#endif

#if		!defined(_IRIS_NOT_SUPPORT_LLONG) && (ULLONG_MAX == 18446744073709551615ULL)
typedef signed long long	IrisS64;
typedef unsigned long long	IrisU64;

#else

#if		defined(IRIS_BORLANDC) || defined(IRIS_MSC)
typedef signed __int64		IrisS64;
typedef unsigned __int64	IrisU64;
#else
#warning	iris not support 64bit variable
typedef signed long			IrisS64;
typedef unsigned long		IrisU64;
#endif

#endif

typedef float				IrisF32;
typedef double				IrisF32_va;
typedef double				IrisF64;

typedef	_W64 long			IrisS32W64;
typedef	_W64 unsigned long	IrisU32W64;

typedef IrisU32				IrisU4CC;		// FOURCC

#if		defined(IRIS_XF_FIXED_FLOAT)		// 
typedef fx16				IrisXF16;
typedef	fx32				IrisXF32;		// Œ菬̌vZɑΉKv^
typedef IrisXF32			IrisXF32_va;
typedef fx64				IrisXF64;
#undef IRIS_XF_FIXED_FLOAT
#define IRIS_XF_FIXED_FLOAT	1

#else						// else
typedef IrisF32				IrisXF16;
typedef	IrisF32				IrisXF32;		// Œ菬̌vZɑΉKv^
typedef IrisF32_va			IrisXF32_va;	// ϒɓndouble^ɂ̂ɑΉ
typedef IrisF64				IrisXF64;
#define IRIS_XF_FIXED_FLOAT	0

#endif

// volatile
typedef volatile IrisInt		IrisVInt;
typedef volatile IrisSInt		IrisVSInt;
typedef volatile IrisUInt		IrisVUInt;

typedef volatile IrisLong		IrisVLong;
typedef volatile IrisSLong		IrisVSLong;
typedef volatile IrisULong		IrisVULong;

typedef volatile IrisC8			IrisVC8;
typedef volatile IrisS8			IrisVS8;
typedef volatile IrisU8			IrisVU8;

typedef volatile IrisS16		IrisVS16;
typedef volatile IrisU16		IrisVU16;

typedef volatile IrisS32		IrisVS32;
typedef volatile IrisU32		IrisVU32;

typedef volatile IrisS64		IrisVS64;
typedef volatile IrisU64		IrisVU64;

typedef volatile IrisF32		IrisVF32;
typedef volatile IrisF64		IrisVF64;

typedef	volatile IrisS32W64		IrisVS32W64;
typedef	volatile IrisU32W64		IrisVU32W64;

typedef	volatile IrisXF16		IrisVXF16;
typedef	volatile IrisXF32		IrisVXF32;
typedef	volatile IrisXF64		IrisVXF64;

// argment type
#if	defined(__cplusplus)
// C++
typedef const IrisInt&			IrisArgInt;
typedef const IrisSInt&			IrisArgSInt;
typedef const IrisUInt&			IrisArgUInt;

typedef const IrisLong&			IrisArgLong;
typedef const IrisSLong&		IrisArgSLong;
typedef const IrisULong&		IrisArgULong;

typedef const IrisC8&			IrisArgC8;
typedef const IrisS8&			IrisArgS8;
typedef const IrisU8&			IrisArgU8;

typedef const IrisS16&			IrisArgS16;
typedef const IrisU16&			IrisArgU16;

typedef const IrisS32&			IrisArgS32;
typedef const IrisU32&			IrisArgU32;

typedef const IrisS64&			IrisArgS64;
typedef const IrisU64&			IrisArgU64;

typedef const IrisF32&			IrisArgF32;
typedef const IrisF64&			IrisArgF64;

typedef	const IrisS32W64&		IrisArgS32W64;
typedef	const IrisU32W64&		IrisArgU32W64;

typedef	const IrisXF16&			IrisArgXF16;
typedef	const IrisXF32&			IrisArgXF32;
typedef	const IrisXF64&			IrisArgXF64;

#else
// C
typedef IrisInt			IrisArgInt;
typedef IrisSInt		IrisArgSInt;
typedef IrisUInt		IrisArgUInt;

typedef IrisLong		IrisArgLong;
typedef IrisSLong		IrisArgSLong;
typedef IrisULong		IrisArgULong;

typedef IrisC8			IrisArgC8;
typedef IrisS8			IrisArgS8;
typedef IrisU8			IrisArgU8;

typedef IrisS16			IrisArgS16;
typedef IrisU16			IrisArgU16;

typedef IrisS32			IrisArgS32;
typedef IrisU32			IrisArgU32;

typedef IrisS64			IrisArgS64;
typedef IrisU64			IrisArgU64;

typedef IrisF32			IrisArgF32;
typedef IrisF64			IrisArgF64;

typedef	IrisS32W64		IrisArgS32W64;
typedef	IrisU32W64		IrisArgU32W64;

typedef	IrisXF16		IrisArgXF16;
typedef	IrisXF32		IrisArgXF32;
typedef	IrisXF64		IrisArgXF64;


#endif

#if 1 || !defined(__cplusplus)
typedef BOOL				IrisBool;
#define	IRIS_TRUE			TRUE
#define	IRIS_FALSE			FALSE
#else
typedef bool				IrisBool;
#define	IRIS_TRUE			true
#define	IRIS_FALSE			false
#endif

// ^
#ifndef _WIN32

#define UNALIGNED

typedef char			CHAR, CCHAR;
typedef CHAR			*PCHAR, *LPCH, *PCH;
typedef const CHAR		*LPCCH, *PCCH;
typedef CHAR			*NPSTR, *LPSTR, *PSTR;
typedef PSTR			*PZPSTR;
typedef const PSTR		*PCZPSTR;
typedef const CHAR		*LPCSTR, *PCSTR;
typedef PCSTR			*PZPCSTR;

#if IRIS_WCS

#ifdef IRIS_WCHAR_NAITIVE
typedef wchar_t			WCHAR, BCHAR;
#else
typedef unsigned short	WCHAR, BCHAR;
#endif
typedef WCHAR			*PWCHAR, *LPWCH, *PWCH;
typedef const WCHAR		*LPCWCH, *PCWCH;
typedef WCHAR			*NWPSTR, *LPWSTR, *PWSTR;
typedef PWSTR			*PZPWSTR;
typedef const PWSTR		*PCZPWSTR;
typedef WCHAR UNALIGNED *LPUWSTR, *PUWSTR;
typedef const WCHAR		*LPCWSTR, *PCWSTR;
typedef PCWSTR			*PZPCWSTR;
typedef const WCHAR UNALIGNED *LPCUWSTR, *PCUWSTR;

#endif

#if		defined(UNICODE) && IRIS_WCS
typedef WCHAR			TCHAR, *PTCHAR;
typedef LPWSTR			LPTCH, PTCH;
typedef LPWSTR			PTSTR, LPTSTR;
typedef LPCWSTR			PCTSTR, LPCTSTR;
typedef LPUWSTR			PUTSTR, LPUTSTR;
typedef LPCUWSTR		PCUTSTR, LPCUTSTR;

#else
typedef CHAR			TCHAR, *PTCHAR;
typedef LPSTR			LPTCH, PTCH;
typedef LPSTR			PTSTR, LPTSTR, PUTSTR, LPUTSTR;
typedef LPCSTR			PCTSTR, LPCTSTR, PCUTSTR, LPCUTSTR;

#endif

#endif

//======================================================================
// struct, union
//----------
// `^
//! `\(IrisS16)
typedef struct IrisSRect
{
	IrisS16 left, top, right, bottom;
} IrisSRect;
//! `\(IrisUS16)
typedef struct IrisUSRect
{
	IrisU16 left, top, right, bottom;
} IrisURect;
//! `\(IrisF32)
typedef struct IrisFRect
{
	IrisF32 left, top, right, bottom;
} IrisFRect;
//! `\(IrisXF32)
typedef struct IrisXFRect
{
	IrisXF32 left, top, right, bottom;
} IrisXFRect;
//! `\(IrisS32)
typedef struct IrisIRect
{
	IrisS32 left, top, right, bottom;
} IrisIRect;
//! `\
typedef union IrisRect
{
	IrisFRect  fv;
	IrisXFRect xfv;
	IrisIRect  iv;
} IrisRect;

//----------
// 2DxNg^
//! 2DxNg\(IrisS16)
typedef struct IrisSVec2
{
	IrisS16 x, y;
} IrisSVec2;
//! 2DxNg\(IrisF32)
typedef struct IrisFVec2
{
	IrisF32 x, y;
} IrisFVec2;
//! 2DxNg\(IrisXF32)
typedef struct IrisXFVec2
{
	IrisXF32 x, y;
} IrisXFVec2;
//! 2DxNg\(IrisS32)
typedef struct IrisIVec2
{
	IrisS32 x, y;
} IrisIVec2;
//! 2DxNg\
typedef union IrisVec2
{
	IrisFVec2  fv;
	IrisXFVec2 xfv;
	IrisIVec2  iv;
} IrisVec2;

//----------
// 3DxNg^
//! 3DxNg\(IrisS16)
typedef struct IrisSVec3
{
	IrisS16 x, y, z;
} IrisSVec3;
//! 3DxNg\(IrisF32)
typedef struct IrisFVec3
{
	IrisF32 x, y, z;
} IrisFVec3;
//! 3DxNg\(IrisXF32)
typedef struct IrisXFVec3
{
	IrisXF32 x, y, z;
} IrisXFVec3;
//! 3DxNg\(IrisS32)
typedef struct IrisIVec3
{
	IrisS32 x, y, z;
} IrisIVec3;
//! 3DxNg\
typedef union IrisVec3
{
	IrisFVec3  fv;
	IrisXFVec3 xfv;
	IrisIVec3  iv;
} IrisVec3;

//----------
// 4DxNg^
//! 4DxNg\(IrisS16)
typedef struct IrisSVec4
{
	IrisS16 x, y, z, w;
} IrisSVec4;
//! 4DxNg\(IrisF32)
typedef struct IrisFVec4
{
	IrisF32 x, y, z, w;
} IrisFVec4;
//! 4DxNg\(IrisF64)
typedef struct IrisDVec4
{
	IrisF64 x, y, z, w;
} IrisDVec4;
//! 4DxNg\(IrisXF32)
typedef struct IrisXFVec4
{
	IrisXF32 x, y, z, w;
} IrisXFVec4;
//! 4DxNg\(IrisS32)
typedef struct IrisIVec4
{
	IrisS32 x, y, z, w;
} IrisIVec4;
//! 4DxNg\
typedef union IrisVec4
{
	IrisFVec4  fv;
	IrisXFVec4 xfv;
	IrisIVec4  iv;
} IrisVec4;

//----------
// 2x2}gbNX
//! 2x2}gbNX(IrisF32)
typedef union IrisFMtx22
{
	struct
	{
		IrisF32 _00, _01;
		IrisF32 _10, _11;
	};
	struct 
	{
		IrisFVec2	x, y;
	};
	IrisFVec2	v[2];
	IrisF32		a[4];
	IrisF32		m[2][2];
} IrisFMtx22;
//! 2x2}gbNX(IrisXF32)
typedef union IrisXFMtx22
{
	struct
	{
		IrisXF32 _00, _01;
		IrisXF32 _10, _11;
	};
	struct 
	{
		IrisXFVec2	x, y;
	};
	IrisXFVec2	v[2];
	IrisXF32	a[4];
	IrisXF32	m[2][2];
} IrisXFMtx22;
//! 2x2}gbNX(IrisS32)
typedef union IrisIMtx22
{
	struct
	{
		IrisS32 _00, _01;
		IrisS32 _10, _11;
	};
	struct 
	{
		IrisIVec2	x, y;
	};
	IrisIVec2	v[2];
	IrisS32		a[4];
	IrisS32		m[2][2];
} IrisIMtx22;
//! 2x2}gbNX
typedef union IrisMtx22
{
	IrisFMtx22	fm;
	IrisXFMtx22	xfm;
	IrisIMtx22	im;
	IrisFVec2	fv[2];
	IrisXFVec2	xfv[2];
	IrisIVec2	iv[2];
	IrisVec2	v[2];
} IrisMtx22;

//----------
// 3x3}gbNX
//! 3x3}gbNX(IrisF32)
typedef union IrisFMtx33
{
	struct
	{
		IrisF32 _00, _01, _02;
		IrisF32 _10, _11, _12;
		IrisF32 _20, _21, _22;
	};
	struct 
	{
		IrisFVec3	x, y, z;
	};
	IrisFVec3	v[3];
	IrisF32		a[9];
	IrisF32		m[3][3];
} IrisFMtx33;
//! 3x3}gbNX(IrisXF32)
typedef union IrisXFMtx33
{
	struct
	{
		IrisXF32 _00, _01, _02;
		IrisXF32 _10, _11, _12;
		IrisXF32 _20, _21, _22;
	};
	struct 
	{
		IrisXFVec3	x, y, z;
	};
	IrisXFVec3	v[3];
	IrisXF32	a[9];
	IrisXF32	m[3][3];
} IrisXFMtx33;
//! 3x3}gbNX(IrisS32)
typedef union IrisIMtx33
{
	struct
	{
		IrisS32 _00, _01, _02;
		IrisS32 _10, _11, _12;
		IrisS32 _20, _21, _22;
	};
	struct 
	{
		IrisIVec3	x, y, z;
	};
	IrisIVec3	v[3];
	IrisS32		a[9];
	IrisS32		m[3][3];
} IrisIMtx33;
//! 3x3}gbNX
typedef union IrisMtx33
{
	IrisFMtx33	fm;
	IrisXFMtx33	xfm;
	IrisIMtx33	im;
	IrisFVec3	fv[3];
	IrisXFVec3	xfv[3];
	IrisIVec3	iv[3];
	IrisVec3	v[3];
} IrisMtx33;

//----------
// 4x3}gbNX
//! 4x3}gbNX(IrisF32)
typedef union IrisFMtx43
{
	struct
	{
		IrisF32 _00, _01, _02;
		IrisF32 _10, _11, _12;
		IrisF32 _20, _21, _22;
		IrisF32 _30, _31, _32;
	};
	struct 
	{
		IrisFVec3	x, y, z, w;
	};
	IrisFVec3	v[4];
	IrisF32		a[12];
	IrisF32		m[4][3];
} IrisFMtx43;
//! 4x3}gbNX(IrisXF32)
typedef union IrisXFMtx43
{
	struct
	{
		IrisXF32 _00, _01, _02;
		IrisXF32 _10, _11, _12;
		IrisXF32 _20, _21, _22;
		IrisXF32 _30, _31, _32;
	};
	struct 
	{
		IrisXFVec3	x, y, z, w;
	};
	IrisXFVec3	v[4];
	IrisXF32	a[12];
	IrisXF32	m[4][3];
} IrisXFMtx43;
//! 4x3}gbNX(IrisS32)
typedef union IrisIMtx43
{
	struct
	{
		IrisS32 _00, _01, _02;
		IrisS32 _10, _11, _12;
		IrisS32 _20, _21, _22;
		IrisS32 _30, _31, _32;
	};
	struct 
	{
		IrisIVec3	x, y, z, w;
	};
	IrisIVec3	v[4];
	IrisS32		a[12];
	IrisS32		m[4][3];
} IrisIMtx43;
//! 4x3}gbNX
typedef union IrisMtx43
{
	IrisFMtx43	fm;
	IrisXFMtx43	xfm;
	IrisIMtx43	im;
	IrisFVec3	fv[4];
	IrisXFVec3	xfv[4];
	IrisIVec3	iv[4];
	IrisVec3	v[4];
} IrisMtx43;

//----------
// 4x4}gbNX
//! 4x4}gbNX(IrisF32)
typedef union IrisFMtx44
{
	struct
	{
		IrisF32 _00, _01, _02, _03;
		IrisF32 _10, _11, _12, _13;
		IrisF32 _20, _21, _22, _23;
		IrisF32 _30, _31, _32, _33;
	};
	struct 
	{
		IrisFVec4	x, y, z, w;
	};
	IrisFVec4	v[4];
	IrisF32		a[16];
	IrisF32		m[4][4];
} IrisFMtx44;
//! 4x4}gbNX(IrisXF32)
typedef union IrisXFMtx44
{
	struct
	{
		IrisXF32 _00, _01, _02, _03;
		IrisXF32 _10, _11, _12, _13;
		IrisXF32 _20, _21, _22, _23;
		IrisXF32 _30, _31, _32, _33;
	};
	struct 
	{
		IrisXFVec4	x, y, z, w;
	};
	IrisXFVec4	v[4];
	IrisXF32	a[16];
	IrisXF32	m[4][4];
} IrisXFMtx44;
//! 4x4}gbNX(IrisS32)
typedef union IrisIMtx44
{
	struct
	{
		IrisS32 _00, _01, _02, _03;
		IrisS32 _10, _11, _12, _13;
		IrisS32 _20, _21, _22, _23;
		IrisS32 _30, _31, _32, _33;
	};
	struct 
	{
		IrisIVec4	x, y, z, w;
	};
	IrisIVec4	v[4];
	IrisS32		a[16];
	IrisS32		m[4][4];
} IrisIMtx44;
//! 4x4}gbNX
typedef union IrisMtx44
{
	IrisFMtx44	fm;
	IrisXFMtx44	xfm;
	IrisIMtx44	im;
	IrisFVec4	fv[4];
	IrisXFVec4	xfv[4];
	IrisIVec4	iv[4];
	IrisVec4	v[4];
} IrisMtx44;

//----------
// NH[^jI
//! NH[^jI(IrisF32)
typedef struct IrisFQuaternion
{
	IrisF32 x, y, z, w;
} IrisFQuaternion;
//! NH[^jI(IrisXF32)
typedef struct IrisXFQuaternion
{
	IrisXF32 x, y, z, w;
} IrisXFQuaternion;
//! NH[^jI
typedef union IrisQuaternion
{
	IrisXFQuaternion	xfq;
	IrisXFVec4			xfv;
} IrisQuaternion;

//----------
// 
//! ʌ^(IrisF32)
typedef struct IrisFPlane
{
	IrisF32 a, b, c, d;
} IrisFPlane;
//! ʌ^(IrisXF32)
typedef struct IrisXFPlane
{
	IrisXF32 a, b, c, d;
} IrisXFPlane;

//----------
// F^
//! f32RGBAJ[
typedef struct IrisFColor
{
	IrisF32 r, g, b, a;
} IrisFColor;
//! xf32RGBAJ[
typedef struct IrisXFColor
{
	IrisXF32 r, g, b, a;
} IrisXFColor;
//! RGBA8888^p
typedef union IrisRGBA8888
{
	IrisU32	col;
	IrisU8	v[4];
	struct 
	{
		IrisU8 a, b, g, r;
	};
#if	defined(__cplusplus)
	operator IrisU32	(void)	{ return col; }
#endif
} IrisRGBA8888;
//! RGBA4444^p
typedef union IrisRGBA4444
{
	IrisU16	col;
	struct 
	{
		IrisU16 a:4;
		IrisU16 b:4;
		IrisU16 g:4;
		IrisU16 r:4;
	};
#if	defined(__cplusplus)
	operator IrisU16	(void)	{ return col; }
#endif
} IrisRGBA4444;
//! RGB555^p
typedef union IrisRGB555
{
	IrisU16	col;
	struct 
	{
		IrisU16 b:5;
		IrisU16 g:5;
		IrisU16 r:5;
		IrisU16 reserved:1;
	};
#if	defined(__cplusplus)
	operator IrisU16	(void)	{ return col; }
#endif
} IrisRGB555;
//! RGBA5551^p
typedef union IrisRGBA5551
{
	IrisU16	col;
	struct 
	{
		IrisU16 a:1;
		IrisU16 b:5;
		IrisU16 g:5;
		IrisU16 r:5;
	};
#if	defined(__cplusplus)
	operator IrisU16	(void)	{ return col; }
#endif
} IrisRGBA5551;
//! RGB565^p
typedef union IrisRGB565
{
	IrisU16	col;
	struct 
	{
		IrisU16 b:5;
		IrisU16 g:6;
		IrisU16 r:5;
	};
#if	defined(__cplusplus)
	operator IrisU16	(void)	{ return col; }
#endif
} IrisRGB565;
//! ARGB^p
typedef union IrisARGB8888
{
	IrisU32	col;
	IrisU8	v[4];
	struct 
	{
		IrisU8 b, g, r, a;
	};
#if	defined(__cplusplus)
	operator IrisU32	(void)	{ return col; }
#endif
} IrisARGB8888;
//! RGBA4444^p
typedef union IrisARGB4444
{
	IrisU16	col;
	struct 
	{
		IrisU16 b:4;
		IrisU16 g:4;
		IrisU16 r:4;
		IrisU16 a:4;
	};
#if	defined(__cplusplus)
	operator IrisU16	(void)	{ return col; }
#endif
} IrisARGB4444;
//! BGR^p
typedef struct IrisBGR888
{
	IrisU8 b, g, r;
#if	defined(__cplusplus)
	IrisBGR888(IrisU8 _b=0, IrisU8 _g=0, IrisU8 _r=0) : b(_b), g(_g), r(_r) {}
	IrisBGR888(IrisU32 col)	: b(static_cast<IrisU8>((col>>16)&0xFF))
		, g(static_cast<IrisU8>((col>>8)&0xFF))
		, r(static_cast<IrisU8>(col&0xFF)) {}
	operator IrisU32	(void)	{ return (IrisU32)((b<<16) | (g<<8) | r); }
#endif
} IrisBGR888;
//! BGR555^p
typedef union IrisBGR555
{
	IrisU16	col;
	struct 
	{
		IrisU16 r:5;
		IrisU16 g:5;
		IrisU16 b:5;
		IrisU16 reserved:1;
	};
#if	defined(__cplusplus)
	operator IrisU16	(void)	{ return col; }
#endif
} IrisBGR555;
//! RGBQUAD^p
typedef union IrisRGBQUAD
{
	IrisU32	col;
	struct 
	{
		IrisU8 b, g, r, Re;
	};
#if	defined(__cplusplus)
	operator IrisU32	(void)	{ return col; }
#endif
} IrisRGBQUAD;

//! CMYJ[(IrisF32)
typedef struct IrisFCMY
{
	IrisF32 c, m, y;
} IrisFCMY;
//! CMYJ[(IrisXF32)
typedef struct IrisXFCMY
{
	IrisXF32 c, m, y;
} IrisXFCMY;
//! CMYKJ[(IrisF32)
typedef struct IrisFCMYK
{
	IrisF32 c, m, y, k;
} IrisFCMYK;
//! CMYKJ[(IrisXF32)
typedef struct IrisXFCMYK
{
	IrisXF32 c, m, y, k;
} IrisXFCMYK;
//! HSVJ[(IrisF32)
typedef struct IrisFHSV
{
	IrisF32 h, s, v;
} IrisFHSV;
//! HSVJ[(IrisXF32)
typedef struct IrisXFHSV
{
	IrisXF32 h, s, v;
} IrisXFHSV;

//! f^(IrisF32)
typedef struct IrisFComplex
{
	IrisF32	re;	//!< 
	IrisF32	im;	//!< 
} IrisFComplex;
//! f^(IrisXF32)
typedef struct IrisXFComplex
{
	IrisXF32	re;	//!< 
	IrisXF32	im;	//!< 
} IrisXFComplex;


//! float, intp
typedef union IrisFInt
{
	IrisF32	fv;
	IrisU32	iv;

#if defined(__cplusplus)
	IrisFInt(void)	: fv(0.0f)		{}
	IrisFInt(IrisF32 f)	: fv(f)			{}
	IrisFInt(IrisF64 f)	: fv((IrisF32)f)	{}
	IrisFInt(IrisU32 i) : iv((IrisU32)i)	{}
	void operator = (IrisF32 f)		{ fv = f; }
	void operator = (IrisF64 f)		{ fv = (IrisF32)f; }
	void operator = (IrisU32 i)		{ iv = (IrisU32)i; }

	operator IrisF32		(void)	{ return fv; }
	operator IrisU32		(void)	{ return iv; }
	operator IrisS32		(void)	{ return (IrisS32)iv; }

	IrisFInt(IrisS32 i) : iv((IrisU32)i) {}
	IrisFInt(IrisS16 i) : iv((IrisU32)i) {}
	IrisFInt(IrisU16 i) : iv((IrisU32)i) {}
	IrisFInt(IrisS8  i) : iv((IrisU32)i) {}
	IrisFInt(IrisU8  i) : iv((IrisU32)i) {}
	IrisFInt(int	 i) : iv((IrisU32)i) {}
#endif

} IrisFInt;

//----------
//! IrisXF32, intp
typedef union IrisXFInt
{
	IrisXF32	fv;
	IrisU32		iv;

#if defined(__cplusplus)
	IrisXFInt(void)	: fv(XF32_ZERO)	{}
	IrisXFInt(IrisXF32 f) : fv(f) {}
	IrisXFInt(IrisU32 i)  : iv((IrisU32)i)	{}
	void operator = (IrisXF32 f)	{ fv = f; }
	void operator = (IrisU32 i)		{ iv = (IrisU32)i; }

	operator IrisXF32		(void)	{ return fv; }
	operator IrisU32		(void)	{ return iv; }
#if !IRIS_XF_FIXED_FLOAT
	operator IrisS32		(void)	{ return (IrisS32)iv; }
#endif

	IrisXFInt(IrisS32 i) : iv((IrisU32)i) {}
	IrisXFInt(IrisS16 i) : iv((IrisU32)i) {}
	IrisXFInt(IrisU16 i) : iv((IrisU32)i) {}
	IrisXFInt(IrisS8  i) : iv((IrisU32)i) {}
	IrisXFInt(IrisU8  i) : iv((IrisU32)i) {}
	IrisXFInt(int	  i) : iv((IrisU32)i) {}
#endif
} IrisXFInt;

//----------
//! 128bitϐ
typedef union IrisW128
{
#ifdef	_IRIS_SUPPORT_SSE2
	__m128i	si;
#endif
	IrisU32	u[4];
} IrisW128;

//----------
// GCAVOɂœK~XhړIŎgp
//! union 32
typedef union IrisUnion32
{
	IrisS32		i;
	IrisU32		ui;
	IrisS16		s[2];
	IrisU16		us[2];
	IrisS8		c[4];
	IrisU8		uc[4];
	IrisF32		f;
	IrisXF32	xf;
	IrisRGBA8888	rgba8888;
	IrisRGBA4444	rgba4444[2];
	IrisRGBA5551	rgba5551[2];
	IrisRGB565		rgb565[2];
	IrisSVec2		sv2;
	void*	p;
} IrisUnion32;

//! union 64
typedef union IrisUnion64
{
	IrisS64		l;
	IrisU64		ul;
	IrisS32		i[2];
	IrisU32		ui[2];
	IrisS16		s[4];
	IrisU16		us[4];
	IrisS8		c[8];
	IrisU8		uc[8];
	IrisF32		f[2];
	IrisXF32	xf[2];
	IrisXF64	xfl;
	IrisRGBA8888	rgba8888[2];
	IrisRGBA4444	rgba4444[4];
	IrisRGBA5551	rgba5551[4];
	IrisRGB565		rgb565[4];
	IrisSVec4	sv4;
} IrisUnion64;

//! union 128
typedef union IrisUnion128
{
	IrisS64		l[2];
	IrisU64		ul[2];
	IrisS32		i[4];
	IrisU32		ui[4];
	IrisS16		s[8];
	IrisU16		us[8];
	IrisS8		c[16];
	IrisU8		uc[16];
	IrisF32		f[4];
	IrisXF32	xf[4];
	IrisXF64	xfl[2];
	IrisW128	w;
	IrisRGBA8888	rgba8888[4];
	IrisRGBA4444	rgba4444[8];
	IrisRGBA5551	rgba5551[8];
	IrisRGB565		rgb565[8];
	IrisVec4	v;
	IrisFPlane	fp;
	IrisXFPlane	xfp;
	IrisFColor  fc;
	IrisXFColor xfc;
} IrisUnion128;

#endif

