//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_types.hpp
* @brief		iris ^`wb_(c++̂)
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_types_HPP_
#define INCG_IRIS_iris_types_HPP_

//======================================================================
// include
#include "iris_types.h"
#include "c++0x/cpp0x_nullptr.h"	// nullptr

#if defined(__cplusplus)

//======================================================================
// declare
template<typename _TN, _TN _FIXED>struct IrisFixedType;
template<typename _TN>struct IrisTRect;
template<typename _TN>union IrisTVec2;
template<typename _TN>union IrisTVec3;
template<typename _TN>union IrisTVec4;
template<typename _TN>union IrisTMtx22;
template<typename _TN>union IrisTMtx33;
template<typename _TN>union IrisTMtx43;
template<typename _TN>union IrisTMtx44;
template<typename _TN>struct IrisTQuaternion;
template<typename _TN>struct IrisTPlane;
template<typename _TN>struct IrisTRGBA;
template<typename _TN, IrisU32 _SIZE>struct IrisFixedArray;
class IrisVaugeBool;

namespace iris
{

//======================================================================
// typedef
typedef IrisC8			c8;
typedef IrisS8			s8;
typedef IrisU8			u8;

typedef IrisS16			s16;
typedef IrisU16			u16;

typedef IrisS32			s32;
typedef IrisU32			u32;

typedef IrisS64			s64;
typedef IrisU64			u64;

typedef IrisF32			f32;
typedef IrisF32_va		f32_va;
typedef IrisF64			f64;

typedef	IrisS32W64		s32w64;
typedef	IrisU32W64		u32w64;

typedef IrisU4CC		u4cc;		// FOURCC

typedef IrisXF16		xf16;
typedef	IrisXF32		xf32;		// Œ菬̌vZɑΉKv^
typedef IrisXF32_va		xf32_va;	// ϒɓndouble^ɂ̂ɑΉ
typedef IrisXF64		xf64;

// volatile
typedef IrisVC8			vc8;
typedef IrisVS8			vs8;
typedef IrisVU8			vu8;

typedef IrisVS16		vs16;
typedef IrisVU16		vu16;

typedef IrisVS32		vs32;
typedef IrisVU32		vu32;

typedef IrisVS64		vs64;
typedef IrisVU64		vu64;

typedef IrisVF32		vf32;
typedef IrisVF64		vf64;

typedef	IrisVS32W64		vs32w64;
typedef	IrisVU32W64		vu32w64;

typedef	IrisVXF16		vxf16;
typedef	IrisVXF32		vxf32;
typedef	IrisVXF64		vxf64;

}	// enf of namespace iris

//======================================================================
// struct
//! 萔^
template<typename _TN, _TN _FIXED>struct IrisFixedType
{
	typedef _TN value_type;
	typedef IrisFixedType<_TN, _FIXED>	type;

	static const value_type	value = _FIXED;
};

//! ̈^
template<typename _TN>struct IrisTRect
{
	_TN	left, top, right, bottom;
};
//! 2DxNg^
template<typename _TN>union IrisTVec2
{
	struct { _TN x, y; };
	_TN	a[2];

	IrisTVec2() : x(0), y(0) {}
	IrisTVec2(const IrisTVec2<_TN>& obj) : x(obj.x), y(obj.y) {}
	template<typename _TT>
	IrisTVec2(const IrisTVec2<_TT>& obj) : x((_TN)obj.x), y((_TN)obj.y) {}
};
//! 3DxNg^
template<typename _TN>union IrisTVec3
{
	struct { _TN x, y, z; };
	_TN	a[3];

	IrisTVec3() : x(0), y(0), z(0) {}
	IrisTVec3(const IrisTVec3<_TN>& obj) : x(obj.x), y(obj.y), z(obj.z) {}
	template<typename _TT>
	IrisTVec3(const IrisTVec3<_TT>& obj) : x((_TN)obj.x), y((_TN)obj.y), z((_TN)obj.z) {}
};
//! 4DxNg^
template<typename _TN>union IrisTVec4
{
	struct { _TN x, y, z, w; };
	_TN	a[4];

	IrisTVec4() : x(0), y(0), z(0), w(0) {}
	IrisTVec4(const IrisTVec4<_TN>& obj) : x(obj.x), y(obj.y), z(obj.z), w(obj.w) {}
	template<typename _TT>
	IrisTVec4(const IrisTVec4<_TT>& obj) : x((_TN)obj.x), y((_TN)obj.y), z((_TN)obj.z), w((_TN)obj.w) {}
};

//! 2x2}gbNX^
template<typename _TN>union IrisTMtx22
{
	struct
	{
		_TN _00, _01;
		_TN _10, _11;
	};
	struct
	{
		IrisTVec2<_TN>	x, y;
	};
	_TN	a[4];
	_TN m[2][2];
};
//! 3x3}gbNX^
template<typename _TN>union IrisTMtx33
{
	struct
	{
		_TN _00, _01, _02;
		_TN _10, _11, _12;
		_TN _20, _21, _22;
	};
	struct
	{
		IrisTVec3<_TN>	x, y, z;
	};
	_TN	a[9];
	_TN m[3][3];
};
//! 4x3}gbNX^
template<typename _TN>union IrisTMtx43
{
	struct
	{
		_TN _00, _01, _02;
		_TN _10, _11, _12;
		_TN _20, _21, _22;
		_TN _30, _31, _32;
	};
	struct
	{
		IrisTVec3<_TN>	x, y, z, w;
	};
	_TN	a[12];
	_TN m[4][3];
};
//! 4x4}gbNX^
template<typename _TN>union IrisTMtx44
{
	struct
	{
		_TN _00, _01, _02, _03;
		_TN _10, _11, _12, _13;
		_TN _20, _21, _22, _23;
		_TN _30, _31, _32, _33;
	};
	struct
	{
		IrisTVec4<_TN>	x, y, z, w;
	};
	_TN	a[16];
	_TN m[4][4];
};

//! NH[^jI^
template<typename _TN>struct IrisTQuaternion
{
	_TN	x, y, z, w;

	IrisTQuaternion(void)
		: x(0), y(0), z(0), w(0) {}
	IrisTQuaternion(_TN _x, _TN _y, _TN _z, _TN _w)
		: x(_x), y(_y), z(_z), w(_w) {}
};
//! ʌ^
template<typename _TN>struct IrisTPlane
{
	_TN a, b, c, d;

	IrisTPlane(void)
		: a(0), b(0), c(0), d(0) {}
	IrisTPlane(_TN _a, _TN _b, _TN _c, _TN _d)
		: a(_a), b(_b), c(_c), d(_d) {}
};

//! J[^
template<typename _TN>struct IrisTRGBA
{
private:
	typedef _TN		type;
	typedef _TN		*ptr;
	typedef IrisTRGBA<_TN>	_Myt;
public:
	_TN r, g, b, a;

	IrisTRGBA(void)
		: r(0), g(0), b(0), a(0) {}
	IrisTRGBA(_TN _r, _TN _g, _TN _b, _TN _a)
		: r(_r), g(_g), b(_b), a(_a) {}
	IrisTRGBA(_TN* v)
		: r(v[0]), g(v[1]), b(v[2]), a(v[3]) {}

	operator ptr		(void)			{ return reinterpret_cast<ptr>(this); }

	bool operator == (const _Myt& t)	{ return (r == t.r) && (g == t.g) && (b == t.b) && (a == t.a); }
	bool operator != (const _Myt& t)	{ return (r != t.r) || (g != t.g) || (b != t.b) || (a != t.a); }
};

/**
 * @brief	ŒTCYzNX
 * @tparam	_TN		= ž^
 * @tparam	_SIZE	= z̗vf
*/
template<typename _TN, IrisU32 _SIZE>
struct IrisFixedArray
{
private:
	typedef IrisFixedArray<_TN, _SIZE>	_Myt;
public:
	_TN	m_Array[_SIZE];
public:
	template<IrisU32 _RSIZE>
	_Myt&	operator = (const IrisFixedArray<_TN, _RSIZE>& r)
	{
		copy(r);
		return *this;
	}
	
	_TN&		operator [] (int index)			{ return m_Array[index]; }
	const _TN&	operator [] (int index) const	{ return m_Array[index]; }

	operator	_TN*		(void)			{ return m_Array; }
	operator	const _TN*	(void)	const	{ return m_Array; }

	_TN*		ptr(void)		{ return m_Array; }
	const _TN*	ptr(void) const { return m_Array; }

	/**
	 * @brief	vf̎擾
	 * @return	vf
	*/
	IrisU32		size(void)	const		{ return _SIZE; }

	_TN&		at(int index)			{ return m_Array[index]; }
	const _TN&	at(int index)	const	{ return m_Array[index]; }

public:
	template<IrisU32 _RSIZE>
	void		copy(const IrisFixedArray<_TN, _RSIZE>& r)
	{
		IrisU32 _size = size();
		if( _size > r.size() ) _size = r.size;
		for( u32 i=0; i < _size; ++i )
		{
			m_Array[i] = r[i];
		}
	}
};

/**
 * @brief	BȐ^Ul^
 * @note	 = ^
 *			 = U
 *			0	 = B
*/
typedef class IrisVaugeBool
{
public:
	enum TYPE
	{
		VB_TRUE		= -1,
		VB_FALSE	= 1,
		VB_VAUGE	= 0
	};
	int		val;

	IrisVaugeBool(void) : val(0) {}
	IrisVaugeBool(TYPE v) : val(v) {}
	IrisVaugeBool(const IrisVaugeBool& v) : val(v.val) {}

	operator bool	(void)	const	{ return val < 0; }	// ^킵͋U
	operator int	(void)	const	{ return val; }

	bool	is_true(void)	const 	{ return val < 0; }
	bool	is_false(void)	const 	{ return val > 0; }
	bool	is_vauge(void)	const 	{ return val == 0; }

	bool	boolean_test(void)	const { return is_true(); }

	template<typename _TN>
	bool operator == (_TN v)		const 	{ return val == v; }
	bool operator == (bool v)		const	{ return is_true() == v; }
	template<typename _TN>
	bool operator != (_TN v)		const 	{ return val != v; }
	bool operator != (bool v)		const 	{ return is_true() != v; }

	bool operator <  (int v)		const	{ return val <  v; }
	bool operator <= (int v)		const	{ return val <= v; }
	bool operator >  (int v)		const	{ return val >  v; }
	bool operator >= (int v)		const	{ return val >= v; }

	bool operator ! (void)			const	{ return !is_true(); }
} IrisVaugeBool;

// EӔrp
template<typename _TN>
bool operator == (const _TN& lhs, const IrisVaugeBool& rhs)				{ return rhs == lhs; }
STATICINLINE	bool operator == (bool lhs, const IrisVaugeBool& rhs)	{ return rhs == lhs; }
STATICINLINE	bool operator <  (int lhs, const IrisVaugeBool& rhs)	{ return rhs <  lhs; }
STATICINLINE	bool operator <= (int lhs, const IrisVaugeBool& rhs)	{ return rhs <= lhs; }
STATICINLINE	bool operator >  (int lhs, const IrisVaugeBool& rhs)	{ return rhs >  lhs; }
STATICINLINE	bool operator >= (int lhs, const IrisVaugeBool& rhs)	{ return rhs >= lhs; }

#endif

#endif

