//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_xf.h
 * @brief		iris Œ菬^`wb_
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_xf_H_
#define INCG_IRIS_iris_xf_H_

//======================================================================
// include
#include "iris_const.h"

#if defined(__cplusplus)
namespace iris
{
#endif

//======================================================================
// macros
// f32 macros
#define F32_Mul(a,b)			((a)*(b))			//!< Z
#define F32_Div(a,b)			((a)/(b))			//!< Z
#define F32_Sqrt(d_v)			sqrtf(d_v)			//!< ݏ捪
#define F32_Rsqrt(d_v)			(1.0f/sqrtf(d_v))	//!< ݏ捪

#define F32_Abs(d_v)			fabsf((d_v))				//!< abs
#define F32_Ceil(d_v)			ceilf((d_v))				//!< ceil
#define F32_Trunc(d_v)			(IrisF32)((IrisS32)(d_v))	//!< trunc	TODO:
#define F32_Floor(d_v)			floorf((d_v))				//!< floor
#define F32_Round(d_v)			roundf(d_v)					//!< round

#define F32_RAD2IDX(rd)			((rd)*0x10000/F32_2PI)		//!< WAl->16bitCfbNX
#define F32_IDX2RAD(idx)		((F32_2PI*(idx))/0x10000)	//!< 16bitCfbNX->WAl

#define F32_Sin(rd)				sinf(rd)			//!< sin
#define F32_Cos(rd)				cosf(rd)			//!< cos
#define F32_Tan(rd)				tanf(rd)			//!< tan
#define F32_SinIdx(idx)			F32_Sin(F32_IDX2RAD(idx))		//!< sin
#define F32_CosIdx(idx)			F32_Cos(F32_IDX2RAD(idx))		//!< cos
#define F32_TanIdx(idx)			F32_Tan(F32_IDX2RAD(idx))		//!< tan
#define F32_Asin(d_v)			asinf(d_v)						//!< asin
#define F32_Acos(d_v)			acosf(d_v)						//!< acos
#define F32_AsinIdx(d_v)		F32_RAD2IDX(F32_Asin(d_v))		//!< asin
#define F32_AcosIdx(d_v)		F32_RAD2IDX(F32_Acos(d_v))		//!< acos
#define F32_Atan(d_v)			atanf(d_v)							//!< atan
#define F32_Atan2(d_vy, d_vx)	atan2f(d_vy, d_vx)					//!< atan2
#define F32_AtanIdx(d_v)		F32_RAD2IDX(F32_Atan(d_v))			//!< atan
#define F32_Atan2Idx(rdy, rdx)	F32_RAD2IDX(F32_Atan2(d_vy, d_vx))	//!< atan2

#define F32_Exp(d_v)			expf((d_v))				//!< exp
#define F32_Log(d_v)			logf((d_v))				//!< log
#define F32_Log2(d_v)			(logf(d_v) / logf(2.0f))//!< log2
#define F32_Log10(d_v)			log10f((d_v))			//!< log10
#define F32_Pow(x, y)			powf(x, y)			//!< pow
#define F32_Pow2(d_v)			powf(2.0f, d_v)		//!< pow2
#define F32_Hypot(x, y)			hypotf(x, y)		//!< hypot

#define F32_PI					3.14159265358979323846f	//!< 
#define F32_2PI					(F32_PI*2.0f)			//!< 2


// f64 macros
#define F64_Abs(d_v)			fabs((d_v))				//!< abs
#define F64_Ceil(d_v)			ceil((d_v))				//!< ceil
#define F64_Trunc(d_v)			(IrisF64)((IrisS64)(d_v))		//!< trunc	TODO:
#define F64_Floor(d_v)			floor((d_v))			//!< floor
#define F64_Round(d_v)			F64_Floor((d_v)+0.5)	//!< round
#define F64_Pow(x, y)			::pow(x, y)				//!< pow
#define F64_Pow2(d_v)			::pow(2.0, d_v)			//!< pow2


// XF macros
#if		defined(IRIS_XF_FIXED_FLOAT) && IRIS_XF_FIXED_FLOAT

#else

#define XF32_SHIFT				0

#define XF32_Mul(a,b)			F32_Mul(a, b)	//!< Z
#define XF32_Div(a,b)			F32_Div(a, b)	//!< Z
#define XF32_Sqrt(d_v)			F32_Sqrt(d_v)	//!< ݏ捪

#define XF_F32_TO_XF32(d_v)		(d_v)			//!< f32  -> IrisXF32LXg
#define XF_XF32_TO_F32(d_v)		(d_v)			//!< IrisXF32 ->  f32LXg
#define XF_XF32_TO_S32(d_v)		((IrisS32)(d_v))	//!< IrisXF32 ->  s32LXg
#define XF_XF32_TO_U32(d_v)		((IrisU32)(d_v))	//!< IrisXF32 ->  u32LXg
#define XF_S32_TO_XF32(d_v)		((IrisF32)(d_v))	//!< s32  -> IrisXF32LXg

#define XF32_CONST(d_v)			(d_v)			//!< f32 -> IrisXF32萔
#define XF32_ZERO				(0.0f)			//!< (IrisXF32)0
#define XF32_ONE				(1.0f)			//!< (IrisXF32)1
#define XF32_HALF				(0.5f)			//!< (IrisXF32)0.5
#define XF32_QUATER				(0.25f)			//!< (IrisXF32)0.25
#define XF32_2					(2.0f)			//!< (IrisXF32)2
#define XF32_4					(4.0f)			//!< (IrisXF32)4
#define XF32_10					(10.0f)			//!< (IrisXF32)10
#define XF32_60					(60.0f)			//!< (IrisXF32)60
#define XF32_180				(180.0f)		//!< (IrisXF32)180
#define XF32_255				(255.0f)		//!< (IrisXF32)255
#define XF32_360				(360.0f)		//!< (IrisXF32)360

#define XF64_ZERO				(0.0)			//!< (IrisXF64)0
#define XF64_ONE				(1.0)			//!< (IrisXF64)1
#define XF64_HALF				(0.5)			//!< (IrisXF64)0.5
#define XF64_QUATER				(0.25)			//!< (IrisXF64)0.25
#define XF64_2					(2.0)			//!< (IrisXF64)2
#define XF64_4					(4.0)			//!< (IrisXF64)4
#define XF64_10					(10.0)			//!< (IrisXF64)10
#define XF64_60					(60.0)			//!< (IrisXF64)60
#define XF64_180				(180.0)			//!< (IrisXF64)180
#define XF64_255				(255.0)			//!< (IrisXF64)255
#define XF64_360				(360.0)			//!< (IrisXF64)360

#define XF32_PI					F32_PI			//!< (IrisXF32)PI
#define XF32_2PI				F32_2PI			//!< (IrisXF32)2*PI

#define XF32_P_INF_BITS			MATH_F32_P_INF_BITS		//!< +
#define XF32_N_INF_BITS			MATH_F32_N_INF_BITS		//!< -
#define XF32_P_NAN_BITS			MATH_F32_P_NAN_BITS		//!< +NaN
#define XF32_N_NAN_BITS			MATH_F32_N_NAN_BITS		//!< -NaN
#define XF32_P_QNAN_BITS		MATH_F32_P_QNAN_BITS	//!< +QNaN
#define XF32_N_QNAN_BITS		MATH_F32_N_QNAN_BITS	//!< -QNaN
#define XF32_P_SNAN_BITS(s)		MATH_F32_P_SNAN_BITS(s)	//!< +SNaN
#define XF32_N_SNAN_BITS(s)		MATH_F32_N_SNAN_BITS(s)	//!< -SNaN


#define XF64_Abs(d_v)			F64_Abs(d_v)		//!< abs
#define XF32_Abs(d_v)			F32_Abs(d_v)		//!< abs

#define XF64_Ceil(d_v)			F64_Ceil(d_v)		//!< ceil
#define XF32_Ceil(d_v)			F32_Ceil(d_v)		//!< ceil

#define XF64_Trunc(d_v)			F64_Trunc(d_v)		//!< trunc	TODO:
#define XF32_Trunc(d_v)			F32_Trunc(d_v)		//!< trunc	TODO:

#define XF64_Floor(d_v)			F64_Floor(d_v)		//!< floor
#define XF32_Floor(d_v)			F32_Floor(d_v)		//!< floor

#define XF64_Round(d_v)			F64_Round(d_v)		//!< round
#define XF32_Round(d_v)			F32_Round(d_v)		//!< round

#define XF32_Sin(rd)			F32_Sin(rd)			//!< sin
#define XF32_Cos(rd)			F32_Cos(rd)			//!< cos
#define XF32_Tan(rd)			F32_Tan(rd)			//!< tan
#define XF32_SinIdx(idx)		F32_Sin(XF_IDX2RAD(idx))		//!< sin
#define XF32_CosIdx(idx)		F32_Cos(XF_IDX2RAD(idx))		//!< cos
#define XF32_TanIdx(idx)		F32_Tan(XF_IDX2RAD(idx))		//!< tan
#define XF32_Asin(d_v)			F32_Asin(d_v)					//!< asin
#define XF32_Acos(d_v)			F32_Acos(d_v)					//!< acos
#define XF32_AsinIdx(d_v)		(XF_RAD2IDX(F32_Asin(d_v)))		//!< asin
#define XF32_AcosIdx(d_v)		(XF_RAD2IDX(F32_Acos(d_v)))		//!< acos
#define XF32_Atan(d_v)			F32_Atan(d_v)					//!< atan
#define XF32_Atan2(d_vy, d_vx)	F32_Atan2(d_vy, d_vx)			//!< atan2
#define XF32_AtanIdx(d_v)		(XF_RAD2IDX(F32_Atan(d_v))				//!< atan
#define XF32_Atan2Idx(d_vy, d_vx)	(XF_RAD2IDX(F32_Atan2(d_vy, d_vx)))	//!< atan2

#define XF32_Exp(d_v)			F32_Exp((d_v))		//!< exp
#define XF32_Log(d_v)			F32_Log((d_v))		//!< log
#define XF32_Log2(d_v)			F32_Log2(d_v)		//!< log2
#define XF32_Log10(d_v)			F32_Log10(d_v)		//!< log10
#define XF32_Pow(x, y)			F32_Pow(x, y)		//!< pow
#define XF32_Pow2(d_v)			F32_Pow2(d_v)		//!< pow2
#define XF32_Hypot(x, y)		F32_Hypot(x, y)		//!< hypot

#endif

#define XF32_Rsqrt(d_v)			(XF_Div(XF32_ONE, XF32_Sqrt(d_v)))	//!< 1 / sqrt(d_v)

#define XF_DEG2RAD(d_v)			(XF_Div(XF_Mul((d_v), XF32_PI), XF32_180))	//!< x->WA
#define XF_RAD2DEG(d_v)			(XF_Div(XF_Mul((d_v), XF32_180), XF32_PI))	//!< WA->x
#define XF_RAD2IDX(d_v)			(XF_XF32_TO_S32(XF_Div((d_v) * 0x10000, XF32_2PI)))	//!< WA->CfbNX
#define XF_IDX2RAD(d_v)			(XF32_2PI * (d_v) / 0x10000)							//!< WA->CfbNX

#define XF_Mul					XF32_Mul
#define XF_Div					XF32_Div
#define XF_Sqrt					XF32_Sqrt
#define XF_Rsqrt				XF32_Rsqrt
#define XF_Abs					XF32_Abs
#define XF_Ceil					XF32_Ceil
#define XF_Floor				XF32_Floor
#define XF_Sin					XF32_Sin
#define XF_Cos					XF32_Cos
#define XF_SinIdx				XF32_SinIdx
#define XF_CosIdx				XF32_CosIdx
#define XF_Asin					XF32_Asin
#define XF_Acos					XF32_Acos
#define XF_AsinIdx				XF32_AsinIdx
#define XF_AcosIdx				XF32_AcosIdx
#define XF_Atan					XF32_Atan
#define XF_Atan2				XF32_Atan2
#define XF_AtanIdx				XF32_AtanIdx
#define XF_Atan2Idx				XF32_Atan2Idx

#if defined(__cplusplus)
}	// end of namespace iris
#endif

#endif
