//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathPractical.h
 * @brief		Ww֐t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathPractical_H_
#define INCG_IRIS_MathPractical_H_

//======================================================================
// include
#include "../iris_inchead.h"

namespace iris {
namespace math
{

//======================================================================
// declare
// K
STATICINLINE	s32		Factorial(s32 n);
// gݍ킹(s32)
STATICINLINE	s32		Combination(s32 n, s32 r);

//======================================================================
// function

//======================================================================
// inline function
/**
 * @brief	n̊K擾
 * @param [in]	n	= ߂n
 * @return	n̊K
*/
STATICINLINE	s32		Factorial(s32 n)
{ 
	s32 ret=1;
	for(s32 i=2; i <= n; ++i) ret *= i;
	return ret;
}

/**
 * @brief	n̊K/m̊K擾
 * @note	n > młȂƐʂȂ
 * @param [in]	n	= ߂n
 * @param [in]	m	= ߂m
 * @return	n̊K/m̊K
*/
STATICINLINE	s32		FactorialDiv(s32 n, s32 m)
{ 
	s32 ret=1;
	for(s32 i=m+1; i <= n; ++i) ret *= i;
	return ret;
}

/**
 * @brief	gݍ킹擾(nCr)
 * @param [in]	n	= ߂n
 * @param [in]	r	= ߂r
 * @return	gݍ킹
*/
STATICINLINE	s32		Combination(s32 n, s32 r)
{
//	return Factorial(n) / (Factorial(r) * Factorial(n-r));
	return FactorialDiv(n, r) / Factorial(n-r);	// œK
}

}	// end of namespace math
}	// end of namespace iris

#endif
