//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathGalois.h
 * @brief		KÃNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathGalois_H_
#define INCG_IRIS_MathGalois_H_

//======================================================================
// include
#include "../../iris_object.h"
#include "MathPrimitivePolynomial.h"

#include "../../c++0x/cpp0x_type_traits.hpp"
#include "../../ml/iml_type_select.hpp"

#include "../../iris_debug.h"

namespace iris {
namespace math
{

//======================================================================
// class

/**
 * @brief	GF(2) _Ng̃NX(KA)
 * @note	0 < _EXP < 32
 * @param [in]	_EXP	= w(1~32)
 * @param [in]	_TN		= z^(0~(2^_EXP-1)i[ł鐮^łȂ΂ȂȂ)
*/
template<u32 _EXP, typename _TN=u32>
class CGF2N : public IIrisObject
{
public:
	typedef _TN		value_type;	//!< ž^
	typedef _TN		*value_ptr;
	typedef _TN		&value_ref;
	typedef typename ::iml::type_select< ::cpp0x::is_scalar<_TN>::value, _TN, const _TN& >::type arg_type;	//!< ^

	typedef CPrimitivePolynomial<_TN>	CPrimPoly;

	enum 
	{
		EXP			= _EXP		//!< w
	};

private:
	value_type	m_Value;	//!< ݂̐l
public:
	/// RXgN^
	CGF2N(void)
		: m_Value(1)
	{
	}

	/// fXgN^
	~CGF2N(void)	{}

public:
	/**
	 * @brief ̐l擾
	 * @param prim	= 
	 * @return	KA̐l
	*/
	value_type	Next(arg_type poly)
	{
		value_type n = m_Value;
		value_type msb = (value_type)((n >> (EXP-1)) & 1);
		value_type msk = (1<<EXP) - 1;
		n <<= 1;
		n = (msb * poly) ^ (n & msk);
		n &= msk;
		m_Value = n;
		return n;
	}

public:
	/// ݒ
	void		SetValue(arg_type value)	{ m_Value = value; }
	/// 擾
	arg_type	GetValue(void)				{ return m_Value; }
};

/**
 * @brief	GF(2) _Ng̃NX(KA)e[u
 * @note	0 < _EXP < 32
 * @param [in]	_EXP	= w(1~32)
 * @param [in]	_TN		= z^(0~(2^_EXP-1)i[ł鐮^łȂ΂ȂȂ)
*/
template<u32 _EXP, typename _TN=u32>
class CGF2NTable : public IIrisObject
{
public:
	typedef CGF2N<_EXP, _TN>	GF2N;
	typedef _TN		value_type;	//!< ž^
	typedef _TN		*value_ptr;
	typedef _TN		&value_ref;
	typedef typename ::iml::type_select< ::cpp0x::is_scalar<_TN>::value, _TN, const _TN& >::type arg_type;	//!< ^

	typedef typename GF2N::CPrimPoly CPrimPoly;

	enum 
	{
		EXP			= _EXP,			//!< w
		ELEMENTS	= (1<<EXP)-1	//!< vf
	};

	IRIS_STATIC_ASSERT( _EXP > 0 && _EXP < 32 );

private:
	value_type	m_F[ELEMENTS];	//!< W

public:
	/// RXgN^
	CGF2NTable(void)
	{
		CPrimPoly poly(EXP);
		Init(poly());
	}
	/// RXgN^
	CGF2NTable(u32 poly)
	{
		Init(poly);
	}

	/// fXgN^
	~CGF2NTable(void)	{}

public:
	/// 
	void	Init(arg_type poly)
	{
		GF2N gf;
		for( u32 i=0; i < ELEMENTS; ++i )
		{
			m_F[i] = gf.GetValue();
			gf.Next(poly);
		}
	}

public:
	/// 擾
	arg_type	operator [] (u32 idx)	{ IRIS_ASSERT(idx < ELEMENTS); return m_F[idx]; }
	/// 擾
	arg_type	GetValue(u32 idx)		{ IRIS_ASSERT(idx < ELEMENTS); return m_F[idx]; }
};

}	// end of namespace math
}	// end of namespace iris

#endif
