//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathHermiteCurve.cpp
 * @brief		G~[gȐt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_MathHermiteCurve_CPP_

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

//======================================================================
// include
#include "MathHermiteCurve.h"
#include "../../unit/UnitCore.h"
#include "../../iris_using.h"
#include "../../iris_iostream.h"

//======================================================================
// test
IRIS_UNITTEST(CMathHermiteCurveUnitTest,MathHermiteCurveUnitTest)
{
	f32 P0 =    1.0f;
	f32 P1 = 3000.0f;
	f32 T0 =   10.0f;
	f32 T1 =  300.0f;

	for( int i=0; i < 11; ++i )
	{
		std::cout << HermiteCurve(P0, T0, P1, T1, i/10.0f) << std::endl;
	}
}

#endif // #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
