//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathPrimitivePolynomial.cpp
 * @brief		nNXeXgt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_MathPrimitivePolynomial_CPP_

//======================================================================
// include
#include "MathPrimitivePolynomial.h"


#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

//======================================================================
// include
#include "../../unit/UnitCore.h"
#include "../../iris_iostream.h"
#include <string.h>
#include <stdio.h>
#include "../../iris_using.h"

//======================================================================
// test
IRIS_UNITTEST(CMathPrimitivePolynomialUnitTest, MathPrimitivePolynomialUnitTest)
{
	typedef CPrimitivePolynomial<u32> CPrimPoly;
	CPrimPoly prim;

	while(1)
	{
		u32 exp;
		std::clog << "ׂw͂Ă(0~32)B(0:I)" << std::endl;
		std::safe_cin >> exp;

		if( exp == 0 || exp > 32) break;
		std::clog << "no͂܂B" << std::endl;
		if(prim.Calc(exp))
		{
			do
			{
				printf("%d. : ", prim());
				for( u32 i=0; i <= exp; ++i )
				{
					printf("%d", prim() & (1<<(exp-i)) ? 1 : 0);
					if( (exp-i) != 0 && (exp-i)%4 == 0) printf(" ");
				}
				puts(".");
			} while(prim.Next(exp));
		}
	}
}

#endif // #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

