//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathColor.h
 * @brief		J[Zt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathColor_H_
#define INCG_IRIS_MathColor_H_

//======================================================================
// include
#include "MathFpuDef.h"

namespace iris {
namespace math
{

//======================================================================
// declare
IRIS_FPU_INLINE IrisFColor*		FpuColorSet(IrisFColor* pc, f32 r, f32 g, f32 b, f32 a);
IRIS_FPU_INLINE IrisFColor*		FpuColorSetRGB(IrisFColor* pc, f32 r, f32 g, f32 b);
IRIS_FPU_INLINE IrisFColor*		FpuColorCopy(IrisFColor* pc0, const IrisFColor* pc1);
IRIS_FPU_INLINE IrisFColor*		FpuColorZero(IrisFColor* pc0);
IRIS_FPU_INLINE IrisRGBA8888	FpuColorToRGBA8888(const IrisFColor* pc);
IRIS_FPU_INLINE IrisARGB8888	FpuColorToARGB8888(const IrisFColor* pc);
IRIS_FPU_INLINE IrisRGBA4444	FpuColorToRGBA4444(const IrisFColor* pc);
IRIS_FPU_INLINE IrisRGBA5551	FpuColorToRGBA5551(const IrisFColor* pc, f32 q);
IRIS_FPU_INLINE IrisRGB565		FpuColorToRGB565(const IrisFColor* pc);
IRIS_FPU_INLINE IrisFCMY*		FpuColorToCMY(IrisFCMY*  pcmy, const IrisFColor* pc);
IRIS_FPU_INLINE IrisFCMYK*		FpuColorToCMYK(IrisFCMYK* pcmyk, const IrisFColor* pc);
IRIS_FPU_INLINE IrisFHSV*		FpuColorToHSV(IrisFHSV* phsv, const IrisFColor* pc);
IRIS_FPU_INLINE IrisFColor*		FpuColorFromRGBA8888(IrisFColor* pc, IrisRGBA8888 rgba);
IRIS_FPU_INLINE IrisFColor*		FpuColorFromARGB8888(IrisFColor* pc, IrisARGB8888 argb);
IRIS_FPU_INLINE IrisFColor*		FpuColorFromRGBA4444(IrisFColor* pc, IrisRGBA4444 rgba);
IRIS_FPU_INLINE IrisFColor*		FpuColorFromRGBA5551(IrisFColor* pc, IrisRGBA5551 rgba, f32 q);
IRIS_FPU_INLINE IrisFColor*		FpuColorFromRGB565(IrisFColor* pc, IrisRGB565 rgb, f32 q);
IRIS_FPU_INLINE IrisFColor*		FpuColorFromCMY(IrisFColor* pc, const IrisFCMY* pcmy, f32 q);
IRIS_FPU_INLINE IrisFColor*		FpuColorFromCMYK(IrisFColor* pc, const IrisFCMYK* pcmyk, f32 q);
IRIS_FPU_INLINE IrisFColor*		FpuColorFromHSV(IrisFColor* pc, const IrisFHSV* phsv, f32 q);
IRIS_FPU_INLINE IrisFColor*		FpuColorAdd(IrisFColor* pc0, const IrisFColor* pc1, const IrisFColor* pc2);
IRIS_FPU_INLINE IrisFColor*		FpuColorAddRGB(IrisFColor* pc0, const IrisFColor* pc1, const IrisFColor* pc2);
IRIS_FPU_INLINE IrisFColor*		FpuColorSub(IrisFColor* pc0, const IrisFColor* pc1, const IrisFColor* pc2);
IRIS_FPU_INLINE IrisFColor*		FpuColorSubRGB(IrisFColor* pc0, const IrisFColor* pc1, const IrisFColor* pc2);
IRIS_FPU_INLINE IrisFColor*		FpuColorMul(IrisFColor* pc0, const IrisFColor* pc1, const IrisFColor* pc2);
IRIS_FPU_INLINE IrisFColor*		FpuColorMulRGB(IrisFColor* pc0, const IrisFColor* pc1, const IrisFColor* pc2);
IRIS_FPU_INLINE IrisFColor*		FpuColorNeg(IrisFColor* pc0, const IrisFColor* pc1);
IRIS_FPU_INLINE IrisFColor*		FpuColorNegRGB(IrisFColor* pc0, const IrisFColor* pc1);
IRIS_FPU_INLINE IrisFColor*		FpuColorLerp(IrisFColor* pc0, const IrisFColor* pc1, const IrisFColor* pc2, f32 t);
IRIS_FPU_INLINE IrisFColor*		FpuColorLerpRGB(IrisFColor* pc0, const IrisFColor* pc1, const IrisFColor* pc2, f32 t);
IRIS_FPU_INLINE IrisFColor*		FpuColorScale(IrisFColor* pc0, const IrisFColor* pc1, f32 s);
IRIS_FPU_INLINE IrisFColor*		FpuColorScaleRGB(IrisFColor* pc0, const IrisFColor* pc1, f32 s);
IRIS_FPU_INLINE IrisFColor*		FpuColorClamp(IrisFColor* pc0, const IrisFColor* pc1, f32 min, f32 max);
IRIS_FPU_INLINE IrisFColor*		FpuColorClampRGB(IrisFColor* pc0, const IrisFColor* pc1, f32 min, f32 max);
IRIS_FPU_INLINE IrisFColor*		FpuColorMax(IrisFColor* pc0, const IrisFColor* pc1, const IrisFColor* pc2);
IRIS_FPU_INLINE IrisFColor*		FpuColorMin(IrisFColor* pc0, const IrisFColor* pc1, const IrisFColor* pc2);
IRIS_FPU_INLINE IrisBool		FpuColorIsEqual(const IrisFColor* pc1, const IrisFColor* pc2);
IRIS_FPU_INLINE IrisBool		FpuColorIsZero(const IrisFColor* pc1);
IRIS_FPU_INLINE IrisFColor*		FpuColorNormalize(IrisFColor* pc0, const IrisFColor* pc1);
IRIS_FPU_INLINE IrisFColor*		FpuColorNormalizeRGB(IrisFColor* pc0, const IrisFColor* pc1);

}	// end of namespace math
}	// end of namespace iris

#ifdef _IRIS_FPU_INLINE
	#include "inl/MathColor.inl"
#endif

#endif
