//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathFpuInline.h
 * @brief		inline g֐t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathFpuInline_H_
#define INCG_IRIS_MathFpuInline_H_

//======================================================================
// include
#include "MathVector2.h"
#include "MathVector3.h"
#include "MathVector4.h"

namespace iris {
namespace math
{

//======================================================================
// decalre
STATICINLINE	f32		InlFpu_Vec2PointToLineInnerProduct(const IrisFVec2* ppnt, const IrisFVec2* pv0, const IrisFVec2* pv1);
STATICINLINE	f32		InlFpu_Vec3PointToLineInnerProduct(const IrisFVec3* ppnt, const IrisFVec3* pv0, const IrisFVec3* pv1);
STATICINLINE	f32		InlFpu_Vec4PointToLineInnerProduct(const IrisFVec4* ppnt, const IrisFVec4* pv0, const IrisFVec4* pv1);
STATICINLINE	f32		InlFpu_Vec2PointToLineOuterProduct(const IrisFVec2* ppnt, const IrisFVec2* pv0, const IrisFVec2* pv1);
STATICINLINE	IrisFVec3*	InlFpu_Vec3PointToLineOuterProduct(IrisFVec3* pv0, const IrisFVec3* ppnt, const IrisFVec3* pv1, const IrisFVec3* pv2);
STATICINLINE	IrisFVec4*	InlFpu_Vec4PointToLineOuterProduct(IrisFVec4* pv0, const IrisFVec4* ppnt, const IrisFVec4* pv1, const IrisFVec4* pv2);


//======================================================================
// inline function
/**
 * @brief	_PƐA̓
 * @note	_Ǝn_ȂBƐA̓
 * @param [in]	ppnt	= _
 * @param [in]	pv0		= n_
 * @param [in]	pv1		= I_
 * @return	
*/
STATICINLINE	f32		InlFpu_Vec2PointToLineInnerProduct(const IrisFVec2* ppnt, const IrisFVec2* pv0, const IrisFVec2* pv1)
{
	MATH_FPU_NULLASSERT( ppnt );
	MATH_FPU_NULLASSERT( pv0 );
	MATH_FPU_NULLASSERT( pv1 );
	IrisFVec2 v0, v1;
	FpuVec2Sub(&v0, ppnt, pv0);
	FpuVec2Sub(&v1, pv1 , pv0);
	return FpuVec2InnerProduct(&v0, &v1);
}

/**
 * @brief	_PƐA̓
 * @note	_Ǝn_ȂBƐA̓
 * @param [in]	ppnt	= _
 * @param [in]	pv0		= n_
 * @param [in]	pv1		= I_
 * @return	
*/
STATICINLINE	f32		InlFpu_Vec3PointToLineInnerProduct(const IrisFVec3* ppnt, const IrisFVec3* pv0, const IrisFVec3* pv1)
{
	MATH_FPU_NULLASSERT( ppnt );
	MATH_FPU_NULLASSERT( pv0 );
	MATH_FPU_NULLASSERT( pv1 );
	IrisFVec3 v0, v1;
	FpuVec3Sub(&v0, ppnt, pv0);
	FpuVec3Sub(&v1, pv1 , pv0);
	return FpuVec3InnerProduct(&v0, &v1);
}

/**
 * @brief	_PƐA̓
 * @note	_Ǝn_ȂBƐA̓
 * @param [in]	ppnt	= _
 * @param [in]	pv0		= n_
 * @param [in]	pv1		= I_
 * @return	
*/
STATICINLINE	f32		InlFpu_Vec4PointToLineInnerProduct(const IrisFVec4* ppnt, const IrisFVec4* pv0, const IrisFVec4* pv1)
{
	MATH_FPU_NULLASSERT( ppnt );
	MATH_FPU_NULLASSERT( pv0 );
	MATH_FPU_NULLASSERT( pv1 );
	IrisFVec4 v0, v1;
	FpuVec4Sub(&v0, ppnt, pv0);
	FpuVec4Sub(&v1, pv1 , pv0);
	return FpuVec4InnerProduct(&v0, &v1);
}

/**
 * @brief	_PƐÅO
 * @note	_Ǝn_ȂBƐÅO
 * @param [in]	ppnt	= _
 * @param [in]	pv0		= n_
 * @param [in]	pv1		= I_
 * @return	O
*/
STATICINLINE	f32		InlFpu_Vec2PointToLineOuterProduct(const IrisFVec2* ppnt, const IrisFVec2* pv0, const IrisFVec2* pv1)
{
	MATH_FPU_NULLASSERT( ppnt );
	MATH_FPU_NULLASSERT( pv0 );
	MATH_FPU_NULLASSERT( pv1 );
	IrisFVec2 v0, v1;
	FpuVec2Sub(&v0, ppnt, pv0);
	FpuVec2Sub(&v1, pv1 , pv0);
	return FpuVec2OuterProduct(&v0, &v1);
}

/**
 * @brief	_PƐÅO
 * @note	_Ǝn_ȂBƐÅO
 * @param [out]	pv0		= o̓xNg
 * @param [in]	ppnt	= _
 * @param [in]	pv1		= n_
 * @param [in]	pv2		= I_
 * @return	o̓xNg
*/
STATICINLINE	IrisFVec3*	InlFpu_Vec3PointToLineOuterProduct(IrisFVec3* pv0, const IrisFVec3* ppnt, const IrisFVec3* pv1, const IrisFVec3* pv2)
{
	MATH_FPU_NULLASSERT( ppnt );
	MATH_FPU_NULLASSERT( pv0 );
	MATH_FPU_NULLASSERT( pv1 );
	MATH_FPU_NULLASSERT( pv2 );
	IrisFVec3 v0, v1;
	FpuVec3Sub(&v0, ppnt, pv1);
	FpuVec3Sub(&v1, pv2 , pv1);
	return FpuVec3OuterProduct(pv0, &v0, &v1);
}

/**
 * @brief	_PƐÅO
 * @note	_Ǝn_ȂBƐÅO
 * @param [out]	pv0		= o̓xNg
 * @param [in]	ppnt	= _
 * @param [in]	pv1		= n_
 * @param [in]	pv2		= I_
 * @return	o̓xNg
*/
STATICINLINE	IrisFVec4*	InlFpu_Vec3PointToLineOuterProduct(IrisFVec4* pv0, const IrisFVec4* ppnt, const IrisFVec4* pv1, const IrisFVec4* pv2)
{
	MATH_FPU_NULLASSERT( ppnt );
	MATH_FPU_NULLASSERT( pv0 );
	MATH_FPU_NULLASSERT( pv1 );
	MATH_FPU_NULLASSERT( pv2 );
	IrisFVec4 v0, v1;
	FpuVec4SubXYZ(&v0, ppnt, pv1);
	FpuVec4SubXYZ(&v1, pv2 , pv1);
	return FpuVec4OuterProductXYZ(pv0, &v0, &v1);
}

}	// end of namespace math
}	// end of namespace iris

#endif
