//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathMatrix33.h
 * @brief		3x3}gbNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathMatrix33_H_
#define INCG_IRIS_MathMatrix33_H_

//======================================================================
// include
#include "MathFpuDef.h"
#include "MathVector3.h"

namespace iris {
namespace math
{

//======================================================================
// declare
IRIS_FPU_INLINE IrisFMtx33*		FpuMtx33Unit(IrisFMtx33* pm0);
IRIS_FPU_INLINE IrisFMtx33*		FpuMtx33Zero(IrisFMtx33* pm0);
IRIS_FPU_INLINE IrisFMtx33*		FpuMtx33Copy(IrisFMtx33* pm0, const IrisFMtx33* pm1);
IRIS_FPU_INLINE IrisFVec3*		FpuMtx33Transform(IrisFVec3* pv0, const IrisFMtx33* pm0, const IrisFVec3* pv1);
IRIS_FPU_INLINE IrisFMtx33*		FpuMtx33Mul(IrisFMtx33* pm0, const IrisFMtx33* pm1, const IrisFMtx33* pm2);
IRIS_FPU_INLINE IrisFMtx33*		FpuMtx33Scale(IrisFMtx33* pm0, const IrisFMtx33* pm1, f32 s);
IRIS_FPU_INLINE IrisFMtx33*		FpuMtx33Transpose(IrisFMtx33* pm0, const IrisFMtx33* pm1);
IRIS_FPU_INLINE IrisFMtx33*		FpuMtx33RotZ(IrisFMtx33* pm0, const IrisFMtx33* pm1, f32 rz);
IRIS_FPU_INLINE IrisFMtx33*		FpuMtx33RotIdxZ(IrisFMtx33* pm0, const IrisFMtx33* pm1, u16 idz);
IRIS_FPU_INLINE IrisFMtx33*		FpuMtx33RotY(IrisFMtx33* pm0, const IrisFMtx33* pm1, f32 ry);
IRIS_FPU_INLINE IrisFMtx33*		FpuMtx33RotIdxY(IrisFMtx33* pm0, const IrisFMtx33* pm1, u16 idy);
IRIS_FPU_INLINE IrisFMtx33*		FpuMtx33RotX(IrisFMtx33* pm0, const IrisFMtx33* pm1, f32 rx);
IRIS_FPU_INLINE IrisFMtx33*		FpuMtx33RotIdxX(IrisFMtx33* pm0, const IrisFMtx33* pm1, u16 idx);
IRIS_FPU_INLINE IrisFMtx33*		FpuMtx33Rot(IrisFMtx33* pm0, const IrisFMtx33* pm1, const IrisFVec3* pv0);
IRIS_FPU_INLINE IrisFMtx33*		FpuMtx33RotIdx(IrisFMtx33* pm0, const IrisFMtx33* pm1, const IrisSVec3* pv0);
IRIS_FPU_INLINE IrisBool		FpuMtx33IsUnit(const IrisFMtx33* pm0);
IRIS_FPU_INLINE f32				FpuMtx33Trace(const IrisFMtx33* pm0);
IRIS_FPU_INLINE f32				FpuMtx33Determinant(const IrisFMtx33* pm0);
IRIS_FPU_INLINE IrisFMtx33*		FpuMtx33Adjoint(IrisFMtx33* pm0, const IrisFMtx33* pm1);
IRIS_FPU_INLINE IrisFMtx33*		FpuMtx33Inverse(IrisFMtx33* pm0, f32* pDeterminant, const IrisFMtx33* pm1);
IRIS_FPU_INLINE IrisFMtx33*		FpuMtx33Normalize(IrisFMtx33* pm0, const IrisFMtx33* pm1);
IRIS_FPU_INLINE IrisFMtx33*		FpuMtx33TruncatePrecision24(IrisFMtx33* pm0, const IrisFMtx33* pm1);

//======================================================================
// inline
STATICINLINE IrisFMtx33*	FpuMtx33Identity(IrisFMtx33* pm0)			{ return FpuMtx33Unit(pm0); }
STATICINLINE IrisFMtx33*	FpuMtx33Null(IrisFMtx33* pm0)				{ return FpuMtx33Zero(pm0); }
STATICINLINE IrisFVec3*	FpuMtx33Apply(IrisFVec3* pv0, const IrisFMtx33* pm0, const IrisFVec3* pv1)	{ return FpuMtx33Transform(pv0, pm0, pv1); }
STATICINLINE IrisBool		FpuMtx33IsIdentity(const IrisFMtx33* pm0)	{ return FpuMtx33IsUnit(pm0); }

}	// end of namespace math
}	// end of namespace iris

#ifdef _IRIS_FPU_INLINE
	#include "inl/MathMatrix33.inl"
#endif

#endif
