//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathQuaternion.h
 * @brief		NH[^jI֐t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathQuaternion_H_
#define INCG_IRIS_MathQuaternion_H_

//======================================================================
// include
#include "MathVector4.h"

namespace iris {
namespace math
{

//======================================================================
// declare
IRIS_FPU_INLINE	IrisFQuaternion*	FpuQuaternionUnit(IrisFQuaternion* pq0);
IRIS_FPU_INLINE	IrisFQuaternion*	FpuQuaternionCopy(IrisFQuaternion* pq0, const IrisFQuaternion* pq1);
IRIS_FPU_INLINE	IrisFQuaternion*	FpuQuaternionAdd(IrisFQuaternion* pq0, const IrisFQuaternion* pq1, const IrisFQuaternion* pq2);
IRIS_FPU_INLINE	IrisFQuaternion*	FpuQuaternionSub(IrisFQuaternion* pq0, const IrisFQuaternion* pq1, const IrisFQuaternion* pq2);
IRIS_FPU_INLINE	IrisFQuaternion*	FpuQuaternionMul(IrisFQuaternion* pq0, const IrisFQuaternion* pq1, const IrisFQuaternion* pq2);
IRIS_FPU_INLINE	f32					FpuQuaternionInnerProduct(const IrisFQuaternion* pq0, const IrisFQuaternion* pq1);
IRIS_FPU_INLINE	IrisFQuaternion*	FpuQuaternionConj(IrisFQuaternion* pq0, const IrisFQuaternion* pq1);
IRIS_FPU_INLINE	IrisFVec4*			FpuQuaternionTransform(IrisFVec4* pv0, const IrisFQuaternion* pq0, const IrisFVec4* pv1);
IRIS_FPU_INLINE	IrisFQuaternion*	FpuQuaternionSlerp(IrisFQuaternion* pq0, const IrisFQuaternion* pq1, const IrisFQuaternion* pq2, f32 t);
IRIS_FPU_INLINE	IrisFQuaternion*	FpuQuaternionSquad(IrisFQuaternion* pq0, const IrisFQuaternion* pq1, const IrisFQuaternion* pq2
													   , const IrisFQuaternion* pq3, const IrisFQuaternion* pq4, f32 t);
IRIS_FPU_INLINE	IrisFQuaternion*	FpuQuaternionNormalize(IrisFQuaternion* pq0, const IrisFQuaternion* pq1);
IRIS_FPU_INLINE	IrisFQuaternion*	FpuQuaternionInverse(IrisFQuaternion* pq0, const IrisFQuaternion* pq1);
IRIS_FPU_INLINE	IrisFQuaternion*	FpuQuaternionLn(IrisFQuaternion* pq0, const IrisFQuaternion* pq1);
IRIS_FPU_INLINE	IrisFQuaternion*	FpuQuaternionExp(IrisFQuaternion* pq0, const IrisFQuaternion* pq1);
IRIS_FPU_INLINE	IrisFMtx44*			FpuQuaternionToMatrix(IrisFMtx44* pm0, const IrisFQuaternion* pq0);
IRIS_FPU_INLINE	IrisFQuaternion*	FpuQuaternionFromMatrix(IrisFQuaternion* pq0, const IrisFMtx44* pm0);
IRIS_FPU_INLINE	IrisFQuaternion*	FpuQuaternionFromRotZYX(IrisFQuaternion* pq0, const IrisFVec4* pv0);
IRIS_FPU_INLINE	IrisFQuaternion*	FpuQuaternionFromRotXYZ(IrisFQuaternion* pq0, const IrisFVec4* pv0);
IRIS_FPU_INLINE	IrisFQuaternion*	FpuQuaternionFromRotYXZ(IrisFQuaternion* pq0, const IrisFVec4* pv0);
IRIS_FPU_INLINE	IrisFQuaternion*	FpuQuaternionFromRotate(IrisFQuaternion* pq0, f32 angle, const IrisFVec4* pvAxis);
IRIS_FPU_INLINE	IrisFVec4*			FpuQuaternionToRotZYX(IrisFVec4* pv0, const IrisFQuaternion* pq0);
IRIS_FPU_INLINE	IrisFVec4*			FpuQuaternionToRotXYZ(IrisFVec4* pv0, const IrisFQuaternion* pq0);
IRIS_FPU_INLINE	IrisFVec4*			FpuQuaternionToRotYXZ(IrisFVec4* pv0, const IrisFQuaternion* pq0);

//======================================================================
// inline
STATICINLINE IrisFQuaternion*	FpuQuaternionIdentity(IrisFQuaternion* pq0)	{ return FpuQuaternionUnit(pq0); }
STATICINLINE IrisFVec4*			FpuQuaternionApply(IrisFVec4* pv0, const IrisFQuaternion* pq0, const IrisFVec4* pv1)	{ return FpuQuaternionTransform(pv0, pq0, pv1); }
STATICINLINE f32				FpuQuaternionDot(const IrisFQuaternion* pq0, const IrisFQuaternion* pq1)				{ return FpuQuaternionInnerProduct(pq0, pq1); }

}	// end of namespace math
}	// end of namespace iris

#ifdef _IRIS_FPU_INLINE
	#include "inl/MathQuaternion.inl"
#endif

#endif
