//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathVector2.h
 * @brief		2DxNgt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathVector2_H_
#define INCG_IRIS_MathVector2_H_

//======================================================================
// include
#include "MathFpuDef.h"

namespace iris {
namespace math
{

//======================================================================
// declare
IRIS_FPU_INLINE	IrisFVec2*	FpuVec2Set(IrisFVec2* pv0, f32 x, f32 y);
IRIS_FPU_INLINE	IrisFVec2*	FpuVec2Copy(IrisFVec2* pv0, const IrisFVec2* pv1);
IRIS_FPU_INLINE	IrisFVec2*	FpuVec2PositiveZero(IrisFVec2* pv0);
IRIS_FPU_INLINE	IrisFVec2*	FpuVec2NegativeZero(IrisFVec2* pv0);
IRIS_FPU_INLINE	IrisIVec2*	FpuVec2Ceil(IrisIVec2* pv0, const IrisFVec2* pv1);
IRIS_FPU_INLINE	IrisIVec2*	FpuVec2Trunc(IrisIVec2* pv0, const IrisFVec2* pv1);
IRIS_FPU_INLINE	IrisIVec2*	FpuVec2Round(IrisIVec2* pv0, const IrisFVec2* pv1);
IRIS_FPU_INLINE	IrisIVec2*	FpuVec2Floor(IrisIVec2* pv0, const IrisFVec2* pv1);
IRIS_FPU_INLINE	IrisFVec2*	FpuVec2FromIVec2(IrisFVec2* pv0, const IrisIVec2* pv1);
IRIS_FPU_INLINE	IrisFVec2*	FpuVec2Add(IrisFVec2* pv0, const IrisFVec2* pv1, const IrisFVec2* pv2);
IRIS_FPU_INLINE	IrisFVec2*	FpuVec2Sub(IrisFVec2* pv0, const IrisFVec2* pv1, const IrisFVec2* pv2);
IRIS_FPU_INLINE	IrisFVec2*	FpuVec2Mul(IrisFVec2* pv0, const IrisFVec2* pv1, const IrisFVec2* pv2);
IRIS_FPU_INLINE	IrisFVec2*	FpuVec2Div(IrisFVec2* pv0, const IrisFVec2* pv1, const IrisFVec2* pv2);
IRIS_FPU_INLINE	IrisFVec2*	FpuVec2Neg(IrisFVec2* pv0, const IrisFVec2* pv1);
IRIS_FPU_INLINE	IrisFVec2*	FpuVec2Abs(IrisFVec2* pv0, const IrisFVec2* pv1);
IRIS_FPU_INLINE	IrisFVec2*	FpuVec2Lerp(IrisFVec2* pv0, const IrisFVec2* pv1, const IrisFVec2* pv2, f32 t);
IRIS_FPU_INLINE	IrisFVec2*	FpuVec2Scale(IrisFVec2* pv0, const IrisFVec2* pv1, f32 s);
IRIS_FPU_INLINE	IrisFVec2*	FpuVec2ScaleAdd(IrisFVec2* pv0, const IrisFVec2* pv1, const IrisFVec2* pv2, f32 s);
IRIS_FPU_INLINE	IrisFVec2*	FpuVec2Hermite(IrisFVec2* pv0, const IrisFVec2* pv1, const IrisFVec2* pt1
									  , const IrisFVec2* pv2, const IrisFVec2* pt2, f32 t);
IRIS_FPU_INLINE	IrisFVec2*	FpuVec2Bezier(IrisFVec2* pv0, s32 n, const IrisFVec2* pva, f32 t);
IRIS_FPU_INLINE	IrisFVec2*	FpuVec2Clamp(IrisFVec2* pv0, const IrisFVec2* pv1, f32 min, f32 max);
IRIS_FPU_INLINE	IrisFVec2*	FpuVec2Max(IrisFVec2* pv0, const IrisFVec2* pv1, const IrisFVec2* pv2);
IRIS_FPU_INLINE	IrisFVec2*	FpuVec2Min(IrisFVec2* pv0, const IrisFVec2* pv1, const IrisFVec2* pv2);
IRIS_FPU_INLINE	f32			FpuVec2InnerProduct(const IrisFVec2* pv0, const IrisFVec2* pv1);
IRIS_FPU_INLINE	f32			FpuVec2OuterProduct(const IrisFVec2* pv0, const IrisFVec2* pv1);
IRIS_FPU_INLINE	f32			FpuVec2Funnel(const IrisFVec2* pv0);
IRIS_FPU_INLINE	f32			FpuVec2Average(const IrisFVec2* pv0);
IRIS_FPU_INLINE	IrisBool	FpuVec2IsEqual(const IrisFVec2* pv0, const IrisFVec2* pv1);
IRIS_FPU_INLINE	IrisBool	FpuVec2IsZero(const IrisFVec2* pv0);
IRIS_FPU_INLINE	IrisFVec2*	FpuVec2SignFloat(IrisFVec2* pv0, const IrisFVec2* pv1);
IRIS_FPU_INLINE	IrisIVec2*	FpuVec2SignInt(IrisIVec2* pv0, const IrisFVec2* pv1);
IRIS_FPU_INLINE	IrisFVec2*	FpuVec2Normalize(IrisFVec2* pv0, const IrisFVec2* pv1);
IRIS_FPU_INLINE	f32			FpuVec2Length(const IrisFVec2* pv0);
IRIS_FPU_INLINE	f32			FpuVec2Distance(const IrisFVec2* pv0, const IrisFVec2* pv1);
IRIS_FPU_INLINE	IrisFVec2*	FpuVec2FaceForward(IrisFVec2* pv0, const IrisFVec2* pv1, const IrisFVec2* pv2, const IrisFVec2* pv3);
IRIS_FPU_INLINE	IrisFVec2*	FpuVec2Reflect(IrisFVec2* pv0, const IrisFVec2* pv1, const IrisFVec2* pv2);
IRIS_FPU_INLINE	IrisFVec2*	FpuVec2Refract(IrisFVec2* pv0, const IrisFVec2* pv1, const IrisFVec2* pv2, f32 eta);
IRIS_FPU_INLINE	IrisFVec2*	FpuVec2TruncatePrecision24(IrisFVec2* pv0, const IrisFVec2* pv1);

//======================================================================
// function
STATICINLINE IrisFVec2*		FpuVec2Null(IrisFVec2* pv0)	{ return FpuVec2PositiveZero(pv0); }
STATICINLINE IrisFVec2*		FpuVec2Zero(IrisFVec2* pv0)	{ return FpuVec2PositiveZero(pv0); }
STATICINLINE f32			FpuVec2Dot(const IrisFVec2* pv0, const IrisFVec2* pv1)	{ return FpuVec2InnerProduct(pv0, pv1); }
STATICINLINE f32			FpuVec2Cross(const IrisFVec2* pv0, const IrisFVec2* pv1)	{ return FpuVec2OuterProduct(pv0, pv1); }
STATICINLINE IrisFVec2*		FpuVec2Subtract(IrisFVec2* pv0, const IrisFVec2* pv1, const IrisFVec2* pv2)	{ return FpuVec2Sub(pv0, pv1, pv2); }
STATICINLINE IrisFVec2*		FpuVec2Multiply(IrisFVec2* pv0, const IrisFVec2* pv1, const IrisFVec2* pv2)	{ return FpuVec2Mul(pv0, pv1, pv2); }
STATICINLINE IrisFVec2*		FpuVec2Divide(IrisFVec2* pv0, const IrisFVec2* pv1, const IrisFVec2* pv2)	{ return FpuVec2Div(pv0, pv1, pv2); }
STATICINLINE IrisFVec2*		FpuVec2Inter(IrisFVec2* pv0, const IrisFVec2* pv1, const IrisFVec2* pv2, f32 t)	{ return FpuVec2Lerp(pv0, pv1, pv2, t); }

}	// end of namespace math
}	// end of namespace iris

#ifdef _IRIS_FPU_INLINE
	#include "inl/MathVector2.inl"
#endif

#endif
