//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathVector4.h
 * @brief		4DxNgt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathVector4_H_
#define INCG_IRIS_MathVector4_H_

//======================================================================
// include
#include "MathFpuDef.h"

namespace iris {
namespace math
{

//======================================================================
// declare
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4Set(IrisFVec4* pv0, f32 x, f32 y, f32 z, f32 w);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4SetXYZ(IrisFVec4* pv0, f32 x, f32 y, f32 z);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4Copy(IrisFVec4* pv0, const IrisFVec4* pv1);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4PositiveZero(IrisFVec4* pv0);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4NegativeZero(IrisFVec4* pv0);
IRIS_FPU_INLINE	IrisIVec4*	FpuVec4Ceil(IrisIVec4* pv0, const IrisFVec4* pv1);
IRIS_FPU_INLINE	IrisIVec4*	FpuVec4Trunc(IrisIVec4* pv0, const IrisFVec4* pv1);
IRIS_FPU_INLINE	IrisIVec4*	FpuVec4Round(IrisIVec4* pv0, const IrisFVec4* pv1);
IRIS_FPU_INLINE	IrisIVec4*	FpuVec4Floor(IrisIVec4* pv0, const IrisFVec4* pv1);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4FromIVec4(IrisFVec4* pv0, const IrisIVec4* pv1);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4Add(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pv2);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4AddXYZ(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pv2);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4Sub(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pv2);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4SubXYZ(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pv2);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4Mul(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pv2);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4MulXYZ(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pv2);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4Div(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pv2);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4DivXYZ(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pv2);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4Neg(IrisFVec4* pv0, const IrisFVec4* pv1);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4Abs(IrisFVec4* pv0, const IrisFVec4* pv1);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4Lerp(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pv2, f32 t);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4LerpXYZ(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pv2, f32 t);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4Scale(IrisFVec4* pv0, const IrisFVec4* pv1, f32 s);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4ScaleXYZ(IrisFVec4* pv0, const IrisFVec4* pv1, f32 s);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4ScaleAdd(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pv2, f32 s);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4ScaleAddXYZ(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pv2, f32 s);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4Hermite(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pt1
									  , const IrisFVec4* pv2, const IrisFVec4* pt2, f32 t);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4HermiteXYZ(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pt1
									  , const IrisFVec4* pv2, const IrisFVec4* pt2, f32 t);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4Bezier(IrisFVec4* pv0, s32 n, const IrisFVec4* pva, f32 t);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4BezierXYZ(IrisFVec4* pv0, s32 n, const IrisFVec4* pva, f32 t);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4Clamp(IrisFVec4* pv0, const IrisFVec4* pv1, f32 min, f32 max);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4ClampXYZ(IrisFVec4* pv0, const IrisFVec4* pv1, f32 min, f32 max);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4Max(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pv2);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4Min(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pv2);
IRIS_FPU_INLINE	f32			FpuVec4InnerProduct(const IrisFVec4* pv0, const IrisFVec4* pv1);
IRIS_FPU_INLINE	f32			FpuVec4InnerProductXYZ(const IrisFVec4* pv0, const IrisFVec4* pv1);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4OuterProductXYZ(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pv2);
IRIS_FPU_INLINE	f32			FpuVec4Funnel(const IrisFVec4* pv0);
IRIS_FPU_INLINE	f32			FpuVec4Average(const IrisFVec4* pv0);
IRIS_FPU_INLINE	IrisBool	FpuVec4IsEqual(const IrisFVec4* pv0, const IrisFVec4* pv1);
IRIS_FPU_INLINE	IrisBool	FpuVec4IsZero(const IrisFVec4* pv0);
IRIS_FPU_INLINE	IrisBool	FpuVec4IsZeroXYZ(const IrisFVec4* pv0);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4SignFloat(IrisFVec4* pv0, const IrisFVec4* pv1);
IRIS_FPU_INLINE	IrisIVec4*	FpuVec4SignInt(IrisIVec4* pv0, const IrisFVec4* pv1);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4Normalize(IrisFVec4* pv0, const IrisFVec4* pv1);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4NormalizeXYZ(IrisFVec4* pv0, const IrisFVec4* pv1);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4NormalizePhase(IrisFVec4* pv0, const IrisFVec4* pv1);
IRIS_FPU_INLINE	f32			FpuVec4LengthXYZ(const IrisFVec4* pv0);
IRIS_FPU_INLINE	f32			FpuVec4DistanceXYZ(const IrisFVec4* pv0, const IrisFVec4* pv1);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4FaceForwardXYZ(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pv2, const IrisFVec4* pv3);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4ReflectXYZ(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pv2);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4RefractXYZ(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pv2, f32 eta);
IRIS_FPU_INLINE	IrisFVec4*	FpuVec4TruncatePrecision24(IrisFVec4* pv0, const IrisFVec4* pv1);

//======================================================================
// inline
STATICINLINE IrisFVec4*	FpuVec4Null(IrisFVec4* pv0)	{ return FpuVec4PositiveZero(pv0); }
STATICINLINE IrisFVec4*	FpuVec4Zero(IrisFVec4* pv0)	{ return FpuVec4PositiveZero(pv0); }
STATICINLINE f32		FpuVec4Dot(const IrisFVec4* pv0, const IrisFVec4* pv1)						{ return FpuVec4InnerProduct(pv0, pv1); }
STATICINLINE f32		FpuVec4DotXYZ(const IrisFVec4* pv0, const IrisFVec4* pv1)						{ return FpuVec4InnerProductXYZ(pv0, pv1); }
STATICINLINE IrisFVec4*	FpuVec4Cross(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pv2)		{ return FpuVec4OuterProductXYZ(pv0, pv1, pv2); }
STATICINLINE IrisFVec4*	FpuVec4Subtract(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pv2)	{ return FpuVec4Sub(pv0, pv1, pv2); }
STATICINLINE IrisFVec4*	FpuVec4Multiply(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pv2)	{ return FpuVec4Mul(pv0, pv1, pv2); }
STATICINLINE IrisFVec4*	FpuVec4Divide(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pv2)	{ return FpuVec4Div(pv0, pv1, pv2); }
STATICINLINE IrisFVec4*	FpuVec4Inter(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pv2, f32 t)	{ return FpuVec4Lerp(pv0, pv1, pv2, t); }
STATICINLINE IrisFVec4*	FpuVec4SubtractXYZ(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pv2)	{ return FpuVec4SubXYZ(pv0, pv1, pv2); }
STATICINLINE IrisFVec4*	FpuVec4MultiplyXYZ(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pv2)	{ return FpuVec4MulXYZ(pv0, pv1, pv2); }
STATICINLINE IrisFVec4*	FpuVec4DivideXYZ(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pv2)		{ return FpuVec4DivXYZ(pv0, pv1, pv2); }
STATICINLINE IrisFVec4*	FpuVec4InterXYZ(IrisFVec4* pv0, const IrisFVec4* pv1, const IrisFVec4* pv2, f32 t)	{ return FpuVec4LerpXYZ(pv0, pv1, pv2, t); }

}	// end of namespace math
}	// end of namespace iris

#ifdef _IRIS_FPU_INLINE
	#include "inl/MathVector4.inl"
#endif

#endif
