//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathCRC32L.h
 * @brief		CRC32 t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathCRC32L_H_
#define INCG_IRIS_MathCRC32L_H_

//======================================================================
// include
#include "../../iris_object.h"

namespace iris {
namespace math
{

//======================================================================
// function
// CRC32e[u̍쐬ij
bool	CRC32LMakeTable(u32* pDst, u32 nSize, u32 uPoly);

// CRC32vZij
u32		CRC32LUpdate(u8* lpBuffer, u32 uLength, u32 uFirst=0xFFFFFFFF, u32 uXor=0);
u32		CRC32LUpdate(u8* lpBuffer, u32 uLength, const u32* lpTable, u32 uFirst=0xFFFFFFFF, u32 uXor=0);

//======================================================================
// class
/// CRC32L
class CCRC32L : public IIrisObject
{
	u32		m_Hash;		//!< nbVl
public:
	/// RXgN^
	CCRC32L(void) : m_Hash(0xFFFFFFFF) {}
	/// RXgN^
	CCRC32L(u32 uFirst) : m_Hash(uFirst) {}
	/// fXgN^
	~CCRC32L(void)	{}
public:
	// 
	void		Init(void);
	// XV
	void		Update(u8* lpBuffer, u32 uLength);
public:
	/// nbVl̎擾
	const u8*	GetDigest(void)	{ return reinterpret_cast<u8*>(&m_Hash); }
	/// nbVTCY̎擾
	u32			GetSize(void)	{ return sizeof(m_Hash); }
};

}	// end of namespace math
}	// end of namespace iris

#endif
