//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathMD5.cpp
 * @brief		MD5 t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_MathMD5_CPP_

//======================================================================
// include
#include "MathMD5.h"
#include "../../misc/iris_allegrex.h"
#include "../../iris_debug.h"

namespace iris {
namespace math
{

//======================================================================
// declare
// obt@ϊ
static void	_MD5Encode(u8* lpDst, const u32* lpSrc, size_t uLength);
// obt@ϊ
static void	_MD5Decode(u32* lpDst, const u8* lpSrc, size_t uLength);
// gXtH[֐
static void _MD5Transform(u32* lpState, const u8* lpBuffer);

//======================================================================
// define
// ]
#define ROTATE_LEFT	iris_allegrex_rotl

//======================================================================
// function
/**********************************************************************//**
 *
 * MD5pReLXg̏
 * 
 ----------------------------------------------------------------------
 * @param [io]	lpContext	= ReLXg
 * @return	
*//***********************************************************************/
void	MD5InitContext(LPMD5CONTEXT lpContext)
{
	IRIS_ASSERT( lpContext != nullptr );
	lpContext->uCount[0] = lpContext->uCount[1] = 0;
	lpContext->uState[0] = 0x67452301;
	lpContext->uState[1] = 0xefcdab89;
	lpContext->uState[2] = 0x98badcfe;
	lpContext->uState[3] = 0x10325476;
	//ZeroMemory(lpContext->uBuffer, sizeof(lpContext->uBuffer));
}

/**********************************************************************//**
 *
 * MD5pReLXg̃NA
 * 
 ----------------------------------------------------------------------
 * @param [io]	lpContext	= ReLXg
 * @return	
*//***********************************************************************/
void	MD5ClearContext(LPMD5CONTEXT lpContext)
{
	IRIS_ASSERT( lpContext != nullptr );
	MD5InitContext(lpContext);
	ZeroMemory(lpContext->uBuffer, sizeof(lpContext->uBuffer));
}

/**********************************************************************//**
 *
 * MD5vZ
 * 
 ----------------------------------------------------------------------
 * @param [io]	lpContext	= ReLXg
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= ̓obt@TCY
*//***********************************************************************/
void	MD5Update(LPMD5CONTEXT lpContext, const u8* lpBuffer, size_t uLength)
{
	IRIS_ASSERT( lpContext != nullptr );
	IRIS_ASSERT( lpBuffer != nullptr );
	u32 i=0;
	u32 index = static_cast<u32>((lpContext->uCount[0] >> 3) & 0x3F);
	u32 partLen = 64 - index;

	lpContext->uCount[0] += static_cast<u32>(uLength << 3);
	if( lpContext->uCount[0] < static_cast<u32>(uLength << 3) )
		++lpContext->uCount[1];
	lpContext->uCount[1] += static_cast<u32>(uLength >> 29);

	if( uLength >= partLen )
	{
		memcpy(lpContext->uBuffer + index, lpBuffer, partLen);
		_MD5Transform(lpContext->uState, lpContext->uBuffer);

		for( i=partLen; i + 63 < uLength; i += 64 )
			_MD5Transform(lpContext->uState, lpBuffer + i);

		index = 0;
	}

	memcpy(lpContext->uBuffer + index, lpBuffer + i, uLength - i);
}

/**********************************************************************//**
 *
 * ŏIIMD5vZ
 * 
 ----------------------------------------------------------------------
 * @param [io]	lpContext	= ReLXg
*//***********************************************************************/
void	MD5Final(LPMD5CONTEXT lpContext)
{
	IRIS_ASSERT( lpContext != nullptr );
	static const u8 padding[64] = 
	{
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
		, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
		, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
		, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
		, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
		, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
		, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
		, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
	};
	u8 bits[8] = {0};
	u32 index  = static_cast<u32>((lpContext->uCount[0] >> 3) & 0x3F);
	u32 padLen = (index < 56) ? static_cast<u32>(56 - index) : static_cast<u32>(120 - index);
	_MD5Encode(bits, lpContext->uCount, 8);
	MD5Update(lpContext, padding, padLen);
	MD5Update(lpContext, bits, 8);
}

/**********************************************************************//**
 *
 * MD5o
 * 
 ----------------------------------------------------------------------
 * @param [io]	lpContext	= ReLXg
 * @param [out]	lpBuffer	= o̓obt@
*//***********************************************************************/
void	MD5Output(LPCMD5CONTEXT lpContext, u8* lpBuffer)
{
	_MD5Encode(lpBuffer, lpContext->uState, MD5HASHSIZE);
}

/**********************************************************************//**
 *
 * MD5܂Ƃ߂ČvZ(Init ` Final)
 * 
 ----------------------------------------------------------------------
 * @param [io]	lpContext	= ReLXg
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= ̓obt@TCY
*//***********************************************************************/
void	MD5Encode(LPMD5CONTEXT lpContext, const u8* lpBuffer, size_t uLength)
{
	MD5InitContext(lpContext);
	MD5Update(lpContext, lpBuffer, uLength);
	MD5Final(lpContext);
}

/**********************************************************************//**
 *
 * MD5܂Ƃ߂ČvZ(Init ` Output)
 * 
 ----------------------------------------------------------------------
 * @param [io]	lpDst		= o̓obt@
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= ̓obt@TCY
*//***********************************************************************/
void	MD5Encode(u8* lpDst, const u8* lpBuffer, size_t uLength)
{
	MD5CONTEXT ctx;
	MD5InitContext(&ctx);
	MD5Update(&ctx, lpBuffer, uLength);
	MD5Final(&ctx);
	MD5Output(&ctx, lpDst);
	MD5ClearContext(&ctx);
}

/**********************************************************************//**
 *
 * MD5o͒l𕶎ɕϊ
 * 
 ----------------------------------------------------------------------
 * @param [out]	lpString	= o̓obt@
 * @param [in]	uSize		= o̓obt@TCY
 * @param [in]	lpMD5		= ̓obt@(MD5)
*//***********************************************************************/
LPTSTR	MD5ToString (LPTSTR lpString, size_t uSize, const u8* lpMD5)
{
#ifdef UNICODE
	return MD5ToStringW(lpString, uSize, lpMD5);
#else
	return MD5ToStringA(lpString, uSize, lpMD5);
#endif
}
/// MD5ToString Q
LPSTR	MD5ToStringA(LPSTR lpString, size_t uSize, const u8* lpMD5)
{
	if( lpString == nullptr ) return nullptr;
	if( lpMD5 == nullptr ) return nullptr;
	CHAR tmp[33];
	const u8* src = lpMD5;
	LPSTR dst = tmp;
	for( int i=0, j=0; i < 16; ++i, j+=2, dst+=2)
	{
		sprintf_s(dst, static_cast<u32>(33-j), "%.2x", *src++);
	}
	strcpy_s(lpString, uSize, tmp);
	return lpString;
}
/// MD5ToString Q
LPWSTR	MD5ToStringW(LPWSTR lpString, size_t uSize, const u8* lpMD5)
{
	if( lpString == nullptr ) return nullptr;
	if( lpMD5 == nullptr ) return nullptr;
	WCHAR tmp[34];
	const u8* src = lpMD5;
	LPWSTR dst = tmp;
	for( int i=0, j=0; i < 16; ++i, j+=2, dst+=2)
	{
		swprintf_s(dst, (size_t)33-j, L"%.2x", *src++);
	}
	wcscpy_s(lpString, uSize, tmp);
	return lpString;
}

// u32 array -> u8 array
void _MD5Encode(u8* lpDst, const u32* lpSrc, size_t uLength)
{
#ifdef __BIG_ENDIAN__
	for( u32 i=0; i < uLength; i+=4, ++lpSrc )
	{
		*(lpDst++) = (*lpSrc      ) & 0xFF;
		*(lpDst++) = (*lpSrc >>  8) & 0xFF;
		*(lpDst++) = (*lpSrc >> 16) & 0xFF;
		*(lpDst++) = (*lpSrc >> 24) & 0xFF;
	}
#else
	memcpy(lpDst, lpSrc, uLength);
#endif
}

// u8 array -> u32 array
void _MD5Decode(u32* lpDst, const u8* lpSrc, size_t uLength)
{
	for( u32 i=0; i < uLength; i+=4, lpSrc+=4 )
	{
		*lpDst++ = IRIS_Bytes2DWord(*(lpSrc), *(lpSrc+1), *(lpSrc+2), *(lpSrc+3));
	}
}

void _MD5Transform(u32* lpState, const u8* lpBuffer)
{
#define S11 7
#define S12 12
#define S13 17
#define S14 22

#define S21 5
#define S22 9
#define S23 14
#define S24 20

#define S31 4
#define S32 11
#define S33 16
#define S34 23

#define S41 6
#define S42 10
#define S43 15
#define S44 21

#define TF(x, y, z) (((x) & (y)) | ((~(x)) & (z)))
#define TG(x, y, z) (((x) & (z)) | ((y) & (~(z))))
#define TH(x, y, z) ((x) ^ (y) ^ (z))
#define TI(x, y, z) ((y) ^ ((x) | (~(z))))

#define FF(a, b, c, d, x, s, ac) (a) = ROTATE_LEFT( ((a) + TF((b), (c), (d)) + ((x) + static_cast<u32>(ac))), (s) ) + (b)
#define GG(a, b, c, d, x, s, ac) (a) = ROTATE_LEFT( ((a) + TG((b), (c), (d)) + ((x) + static_cast<u32>(ac))), (s) ) + (b)
#define HH(a, b, c, d, x, s, ac) (a) = ROTATE_LEFT( ((a) + TH((b), (c), (d)) + ((x) + static_cast<u32>(ac))), (s) ) + (b)
#define II(a, b, c, d, x, s, ac) (a) = ROTATE_LEFT( ((a) + TI((b), (c), (d)) + ((x) + static_cast<u32>(ac))), (s) ) + (b)

	u32 a = *(lpState);
	u32 b = *(lpState+1);
	u32 c = *(lpState+2);
	u32 d = *(lpState+3);
#ifdef __BIG_ENDIAN__
	u32 x[16];
	_MD5Decode(x, lpBuffer, 64);
#else
	const u32* x = reinterpret_cast<const u32*>(lpBuffer);
#endif

	FF(a, b, c, d, x[ 0], S11, 0xd76aa478);
	FF(d, a, b, c, x[ 1], S12, 0xe8c7b756);
	FF(c, d, a, b, x[ 2], S13, 0x242070db);
	FF(b, c, d, a, x[ 3], S14, 0xc1bdceee);
	FF(a, b, c, d, x[ 4], S11, 0xf57c0faf);
	FF(d, a, b, c, x[ 5], S12, 0x4787c62a);
	FF(c, d, a, b, x[ 6], S13, 0xa8304613);
	FF(b, c, d, a, x[ 7], S14, 0xfd469501);
	FF(a, b, c, d, x[ 8], S11, 0x698098d8);
	FF(d, a, b, c, x[ 9], S12, 0x8b44f7af);
	FF(c, d, a, b, x[10], S13, 0xffff5bb1);
	FF(b, c, d, a, x[11], S14, 0x895cd7be);
	FF(a, b, c, d, x[12], S11, 0x6b901122);
	FF(d, a, b, c, x[13], S12, 0xfd987193);
	FF(c, d, a, b, x[14], S13, 0xa679438e);
	FF(b, c, d, a, x[15], S14, 0x49b40821);

	GG(a, b, c, d, x[ 1], S21, 0xf61e2562);
	GG(d, a, b, c, x[ 6], S22, 0xc040b340);
	GG(c, d, a, b, x[11], S23, 0x265e5a51);
	GG(b, c, d, a, x[ 0], S24, 0xe9b6c7aa);
	GG(a, b, c, d, x[ 5], S21, 0xd62f105d);
	GG(d, a, b, c, x[10], S22, 0x02441453);
	GG(c, d, a, b, x[15], S23, 0xd8a1e681);
	GG(b, c, d, a, x[ 4], S24, 0xe7d3fbc8);
	GG(a, b, c, d, x[ 9], S21, 0x21e1cde6);
	GG(d, a, b, c, x[14], S22, 0xc33707d6);
	GG(c, d, a, b, x[ 3], S23, 0xf4d50d87);
	GG(b, c, d, a, x[ 8], S24, 0x455a14ed);
	GG(a, b, c, d, x[13], S21, 0xa9e3e905);
	GG(d, a, b, c, x[ 2], S22, 0xfcefa3f8);
	GG(c, d, a, b, x[ 7], S23, 0x676f02d9);
	GG(b, c, d, a, x[12], S24, 0x8d2a4c8a);

	HH(a, b, c, d, x[ 5], S31, 0xfffa3942);
	HH(d, a, b, c, x[ 8], S32, 0x8771f681);
	HH(c, d, a, b, x[11], S33, 0x6d9d6122);
	HH(b, c, d, a, x[14], S34, 0xfde5380c);
	HH(a, b, c, d, x[ 1], S31, 0xa4beea44);
	HH(d, a, b, c, x[ 4], S32, 0x4bdecfa9);
	HH(c, d, a, b, x[ 7], S33, 0xf6bb4b60);
	HH(b, c, d, a, x[10], S34, 0xbebfbc70);
	HH(a, b, c, d, x[13], S31, 0x289b7ec6);
	HH(d, a, b, c, x[ 0], S32, 0xeaa127fa);
	HH(c, d, a, b, x[ 3], S33, 0xd4ef3085);
	HH(b, c, d, a, x[ 6], S34, 0x04881d05);
	HH(a, b, c, d, x[ 9], S31, 0xd9d4d039);
	HH(d, a, b, c, x[12], S32, 0xe6db99e5);
	HH(c, d, a, b, x[15], S33, 0x1fa27cf8);
	HH(b, c, d, a, x[ 2], S34, 0xc4ac5665);

	II(a, b, c, d, x[ 0], S41, 0xf4292244);
	II(d, a, b, c, x[ 7], S42, 0x432aff97);
	II(c, d, a, b, x[14], S43, 0xab9423a7);
	II(b, c, d, a, x[ 5], S44, 0xfc93a039);
	II(a, b, c, d, x[12], S41, 0x655b59c3);
	II(d, a, b, c, x[ 3], S42, 0x8f0ccc92);
	II(c, d, a, b, x[10], S43, 0xffeff47d);
	II(b, c, d, a, x[ 1], S44, 0x85845dd1);
	II(a, b, c, d, x[ 8], S41, 0x6fa87e4f);
	II(d, a, b, c, x[15], S42, 0xfe2ce6e0);
	II(c, d, a, b, x[ 6], S43, 0xa3014314);
	II(b, c, d, a, x[13], S44, 0x4e0811a1);
	II(a, b, c, d, x[ 4], S41, 0xf7537e82);
	II(d, a, b, c, x[11], S42, 0xbd3af235);
	II(c, d, a, b, x[ 2], S43, 0x2ad7d2bb);
	II(b, c, d, a, x[ 9], S44, 0xeb86d391);

	*(lpState  ) += a;
	*(lpState+1) += b;
	*(lpState+2) += c;
	*(lpState+3) += d;
#ifdef __BIG_ENDIAN__
	SecureZeroMemory(x, sizeof(x));
#endif
}

}	// end of namespace math
}	// end of namespace iris


#if	defined(_IRIS_SUPPORT_GOOGLETEST)

//======================================================================
// include
#include "../../unit/gt/gt_inchead.h"
#include "../../iris_using.h"

TEST(CMathMD5Test, Function)
{
	char comm[256] = "";
	u8 out[MD5HASHSIZE];

	MD5Encode(out, comm, 0);
	MD5ToStringA(comm, 256, out);
	ASSERT_STREQ( "d41d8cd98f00b204e9800998ecf8427e", comm );

	strcpy_s(comm, 256, "a");
	MD5Encode(out, comm, strlen(comm));
	MD5ToStringA(comm, 256, out);
	ASSERT_STREQ( "0cc175b9c0f1b6a831c399e269772661", comm );

	strcpy_s(comm, 256, "abc");
	MD5Encode(out, comm, strlen(comm));
	MD5ToStringA(comm, 256, out);
	ASSERT_STREQ( "900150983cd24fb0d6963f7d28e17f72", comm );

	strcpy_s(comm, 256, "message digest");
	MD5Encode(out, comm, strlen(comm));
	MD5ToStringA(comm, 256, out);
	ASSERT_STREQ( "f96b697d7cb7938d525a2f31aaf161d0", comm );

	strcpy_s(comm, 256, "abcdefghijklmnopqrstuvwxyz");
	MD5Encode(out, comm, strlen(comm));
	MD5ToStringA(comm, 256, out);
	ASSERT_STREQ( "c3fcd3d76192e4007dfb496cca67e13b", comm );

	strcpy_s(comm, 256, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789");
	MD5Encode(out, comm, strlen(comm));
	MD5ToStringA(comm, 256, out);
	ASSERT_STREQ( "d174ab98d277d9f5a5611c2c9f419d9f", comm );

	strcpy_s(comm, 256, "12345678901234567890123456789012345678901234567890123456789012345678901234567890");
	MD5Encode(out, comm, strlen(comm));
	MD5ToStringA(comm, 256, out);
	ASSERT_STREQ( "57edf4a22be3c955ac49da2e2107b67a", comm );
}

#endif	// #if	defined(_IRIS_SUPPORT_GOOGLETEST)

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

#define TEXT_TEST	0
//======================================================================
// include
#include "../../unit/UnitCore.h"
#include "../../iris_using.h"
#include "../../iris_iostream.h"
#if	!TEXT_TEST
#include "../../fnd/io/FndFile.h"
#endif

//======================================================================
// test
IRIS_UNITTEST(CMathMD5UnitTest, MathMD5UnitTest)
{
	char comm[256] = "";
	u8 out[MD5HASHSIZE];

#if TEXT_TEST
	std::clog << "MD5GR[h܂B" << std::endl;
#else
	std::clog << "MD5GR[h܂Bt@CpX͂ĂB" << std::endl;
#endif
	std::safe_cin >> comm;

#if	TEXT_TEST
	MD5Encode(out, comm, strlen(comm));
#else
	fnd::CFile file;
	if( !file.OpenA(comm, fnd::FOPEN_READ) ) return;
	u32	size = file.GetSize();
	char* buf = new char [size+1];
	file.Read(buf, size);
	MD5Encode(out, buf, size);
#endif

	for( int i=0; i < MD5HASHSIZE; ++i )
		printf("%.2x", out[i]);
	std::cout << std::endl;

}

#endif // #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

