//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathSHA224.h
 * @brief		SHA224 t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathSHA224_H_
#define INCG_IRIS_MathSHA224_H_

//======================================================================
// include
#include "MathSHA256.h"

namespace iris {
namespace math
{

//======================================================================
// define
//! SHA224nbVTCY
#define SHA224_HASHSIZE_IN		SHA256_HASHSIZE_IN
//! SHA224nbVTCY
#define SHA224_HASHSIZE			28
//! SHA256bZ[Wobt@TCY
#define SHA224_LENGTHBUFSIZE	SHA256_LENGTHBUFSIZE
//! SHA224bZ[WubNTCY
#define SHA224_MSGBLKSIZE		SHA256_MSGBLKSIZE

//======================================================================
// struct
typedef SHA256CONTEXT		SHA224CONTEXT;		//!< SHA224pReLXg
typedef LPSHA256CONTEXT		LPSHA224CONTEXT;	//!< SHA224pReLXg|C^[^
typedef LPCSHA256CONTEXT	LPCSHA224CONTEXT;	//!< SHA224pReLXg|C^[^

//! SHA224nbVo͌^
typedef struct tagSHA224DIGEST
{
	u8	hash[SHA224_HASHSIZE];		//!< obt@
} SHA224DIGEST, LPSHA224DIGEST;	//!< SHA224nbVo͌^

//======================================================================
// function
// SHA224pReLXg̏
void	SHA224InitContext(LPSHA224CONTEXT lpContext);
// SHA224pReLXg̃NA
void	SHA224ClearContext(LPSHA224CONTEXT lpContext);
// SHA224o
void	SHA224Output(LPCSHA224CONTEXT lpContext, u8* lpBuffer);
// SHA224܂Ƃ߂ČvZ
void	SHA224Encode(LPSHA224CONTEXT lpContext, const u8* lpBuffer, size_t uLength);
// SHA224܂Ƃ߂ČvZ
void	SHA224Encode(u8* lpDst, const u8* lpBuffer, size_t uLength);
// SHA224o͒l𕶎ɕϊ
LPTSTR	SHA224ToString (LPTSTR lpString, size_t uSize, const u8* lpSHA224);
LPSTR	SHA224ToStringA(LPSTR  lpString, size_t uSize, const u8* lpSHA224);
LPWSTR	SHA224ToStringW(LPWSTR lpString, size_t uSize, const u8* lpSHA224);

/**
 * @brief	SHA224vZ
 * @note	iris::math::SHA256Update
*/
STATICINLINE	void	SHA224Update(LPSHA224CONTEXT lpContext, const u8* lpBuffer, size_t uLength)
{
	SHA256Update(lpContext, lpBuffer, uLength);
}
/**
 * @brief	ŏIISHA224vZ
 * @note	iris::math::SHA256Final
*/
STATICINLINE	void	SHA224Final(LPSHA224CONTEXT lpContext)
{
	SHA256Final(lpContext);
}


// template
/**
 * @brief	SHA224vZ
 * @tparam	_TN	= Ώی^
 * @param [io]	lpContext	= ReLXg
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= obt@
*/
template<typename _TN>
void	SHA224Update(LPSHA224CONTEXT lpContext, const _TN* lpBuffer, size_t uLength)
{
	SHA224Update(lpContext, reinterpret_cast<const u8*>(lpBuffer), uLength);
}

/**
 * @brief	SHA224܂Ƃ߂ČvZ
 * @tparam	_TN	= Ώی^
 * @param [io]	lpContext	= ReLXg
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= obt@
*/
template<typename _TN>
void	SHA224Encode(LPSHA224CONTEXT lpContext, const _TN* lpBuffer, size_t uLength)
{
	SHA224Encode(lpContext, reinterpret_cast<const u8*>(lpBuffer), uLength);
}

/**
 * @brief	SHA224܂Ƃ߂ČvZ
 * @tparam	_TN	= Ώی^
 * @param [io]	lpDst		= o̓obt@
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	uLength		= obt@
*/
template<typename _TN>
void	SHA224Encode(u8* lpDst, const _TN* lpBuffer, size_t uLength)
{
	SHA224Encode(lpDst, reinterpret_cast<const u8*>(lpBuffer), uLength);
}

}	// end of namespace math
}	// end of namespace iris

#endif
